/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAction;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAOperation;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAParameter;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.modify.JPAConversionHelper;
import com.sap.olingo.jpa.processor.core.processor.JPAModifyUtil;
import com.sap.olingo.jpa.processor.core.processor.JPAOperationRequestProcessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.Parameter;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;

public class JPAActionRequestProcessor
extends JPAOperationRequestProcessor {
    public JPAActionRequestProcessor(OData odata, JPAODataCRUDContextAccess sessionContext, JPAODataRequestContextAccess requestContext) throws ODataException {
        super(odata, sessionContext, requestContext);
    }

    public void performAction(ODataRequest request, ODataResponse response, ContentType requestFormat) throws ODataApplicationException {
        List resourceList = this.uriInfo.getUriResourceParts();
        UriResourceAction resource = (UriResourceAction)resourceList.get(resourceList.size() - 1);
        try {
            JPAAction jpaAction = this.sd.getAction(resource.getAction());
            Object instance = this.createInstanze(jpaAction.getConstructor());
            ArrayList<Object> parameter = new ArrayList<Object>();
            java.lang.reflect.Parameter[] methodParameter = jpaAction.getMethod().getParameters();
            ODataDeserializer deserializer = this.odata.createDeserializer(requestFormat);
            Map actionParameter = deserializer.actionParameters(request.getBody(), resource.getAction()).getActionParameters();
            for (int i = 0; i < methodParameter.length; ++i) {
                java.lang.reflect.Parameter declairedParameter = methodParameter[i];
                if (i == 0 && resource.getAction().isBound()) {
                    parameter.add(this.createBindingParameter((UriResourceEntitySet)resourceList.get(resourceList.size() - 2), jpaAction.getParameter(declairedParameter)));
                    continue;
                }
                String externalName = jpaAction.getParameter(declairedParameter).getName();
                Parameter param = (Parameter)actionParameter.get(externalName);
                if (param != null) {
                    parameter.add(JPAConversionHelper.convertParameter(param, this.sd));
                    continue;
                }
                parameter.add(null);
            }
            Annotatable r = null;
            EdmType returnType = null;
            if (resource.getAction().getReturnType() != null) {
                returnType = resource.getAction().getReturnType().getType();
                Object result = jpaAction.getMethod().invoke(instance, parameter.toArray());
                r = this.convertResult(result, returnType, (JPAOperation)jpaAction);
            } else {
                jpaAction.getMethod().invoke(instance, parameter.toArray());
            }
            if (this.serializer != null) {
                this.serializeResult(returnType, response, this.serializer.getContentType(), r, request);
            } else {
                response.setStatusCode(this.successStatusCode);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        catch (InvocationTargetException | ODataException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof ODataApplicationException) {
                throw (ODataApplicationException)cause;
            }
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private Object createBindingParameter(UriResourceEntitySet entitySet, JPAParameter parameter) throws ODataJPAModelException, ODataApplicationException {
        try {
            JPAConversionHelper helper = new JPAConversionHelper();
            JPAModifyUtil util = new JPAModifyUtil();
            Constructor c = parameter.getType().getConstructor(new Class[0]);
            Map<String, Object> jpaAttributes = helper.convertUriKeys(this.odata, (JPAStructuredType)this.sd.getEntity((EdmType)entitySet.getEntityType()), entitySet.getKeyPredicates());
            if (c != null) {
                Object param = c.newInstance(new Object[0]);
                util.setAttributesDeep(jpaAttributes, param, (JPAStructuredType)this.sd.getEntity((EdmType)entitySet.getEntityType()));
                return param;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof ODataApplicationException) {
                throw (ODataApplicationException)cause;
            }
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        return null;
    }

    protected Object createInstanze(Constructor<?> c) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object instance = c.getParameterCount() == 1 ? c.newInstance(this.em) : c.newInstance(new Object[0]);
        return instance;
    }
}

