/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPACUDRequestHandler;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataTransactionFactory;
import com.sap.olingo.jpa.processor.core.converter.JPATupleChildConverter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAInvocationTargetException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.modify.JPAConversionHelper;
import com.sap.olingo.jpa.processor.core.modify.JPACreateResultFactory;
import com.sap.olingo.jpa.processor.core.modify.JPAUpdateResult;
import com.sap.olingo.jpa.processor.core.processor.JPAAbstractRequestProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPARequestEntity;
import com.sap.olingo.jpa.processor.core.processor.JPARequestEntityImpl;
import com.sap.olingo.jpa.processor.core.processor.JPARequestLink;
import com.sap.olingo.jpa.processor.core.processor.JPARequestLinkImpl;
import com.sap.olingo.jpa.processor.core.query.EdmEntitySetInfo;
import com.sap.olingo.jpa.processor.core.query.ExpressionUtil;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.UriResourceValue;

public final class JPACUDRequestProcessor
extends JPAAbstractRequestProcessor {
    private static final String DEBUG_CREATE_ENTITY = "createEntity";
    private static final String DEBUG_UPDATE_ENTITY = "updateEntity";
    private final ServiceMetadata serviceMetadata;
    private final JPAConversionHelper helper;

    public JPACUDRequestProcessor(OData odata, ServiceMetadata serviceMetadata, JPAODataCRUDContextAccess sessionContext, JPAODataRequestContextAccess requestContext, JPAConversionHelper cudHelper) throws ODataException {
        super(odata, sessionContext, requestContext);
        this.serviceMetadata = serviceMetadata;
        this.helper = cudHelper;
    }

    public void clearFields(ODataRequest request, ODataResponse response) throws ODataJPAProcessException {
        int handle = this.debugger.startRuntimeMeasurement(this, "clearFields");
        JPACUDRequestHandler handler = this.requestContext.getCUDRequestHandler();
        EdmEntitySetInfo edmEntitySetInfo = Util.determineTargetEntitySetAndKeys(this.uriInfo.getUriResourceParts());
        JPARequestEntity requestEntity = this.createRequestEntity(edmEntitySetInfo, this.uriInfo.getUriResourceParts(), (Map<String, List<String>>)request.getAllHeaders());
        JPAODataTransactionFactory.JPAODataTransaction ownTransaction = null;
        boolean foreignTransaction = this.requestContext.getTransactionFactory().hasActiveTransaction();
        if (!foreignTransaction) {
            ownTransaction = this.requestContext.getTransactionFactory().createTransaction();
        }
        try {
            int updateHandle = this.debugger.startRuntimeMeasurement(handler, DEBUG_UPDATE_ENTITY);
            handler.updateEntity(requestEntity, this.em, this.determineHttpVerb(request, this.uriInfo.getUriResourceParts()));
            if (!foreignTransaction) {
                handler.validateChanges(this.em);
            }
            this.debugger.stopRuntimeMeasurement(updateHandle);
        }
        catch (ODataJPAProcessException e) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw e;
        }
        catch (Exception e) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        if (!foreignTransaction) {
            ownTransaction.commit();
        }
        this.debugger.stopRuntimeMeasurement(handle);
        response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
    }

    public void createEntity(ODataRequest request, ODataResponse response, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        int handle = this.debugger.startRuntimeMeasurement(this, DEBUG_CREATE_ENTITY);
        JPACUDRequestHandler handler = this.requestContext.getCUDRequestHandler();
        EdmEntitySetInfo edmEntitySetInfo = Util.determineModifyEntitySetAndKeys(this.uriInfo.getUriResourceParts());
        Entity odataEntity = this.helper.convertInputStream(this.odata, request, requestFormat, this.uriInfo.getUriResourceParts());
        JPARequestEntity requestEntity = this.createRequestEntity(edmEntitySetInfo, odataEntity, (Map<String, List<String>>)request.getAllHeaders());
        Object result = null;
        JPAODataTransactionFactory.JPAODataTransaction ownTransaction = null;
        boolean foreignTransaction = this.requestContext.getTransactionFactory().hasActiveTransaction();
        if (!foreignTransaction) {
            ownTransaction = this.requestContext.getTransactionFactory().createTransaction();
        }
        try {
            int createHandle = this.debugger.startRuntimeMeasurement(handler, DEBUG_CREATE_ENTITY);
            result = handler.createEntity(requestEntity, this.em);
            if (!foreignTransaction) {
                handler.validateChanges(this.em);
            }
            this.debugger.stopRuntimeMeasurement(createHandle);
        }
        catch (ODataJPAProcessException e) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw e;
        }
        catch (Exception e) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        if (result != null && result.getClass() != requestEntity.getEntityType().getTypeClass() && !(result instanceof Map)) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.WRONG_RETURN_TYPE, HttpStatusCode.INTERNAL_SERVER_ERROR, result.getClass().toString(), requestEntity.getEntityType().getTypeClass().toString());
        }
        if (!foreignTransaction) {
            ownTransaction.commit();
        }
        this.createCreateResponse(request, response, responseFormat, requestEntity, edmEntitySetInfo, result);
        this.debugger.stopRuntimeMeasurement(handle);
    }

    public void deleteEntity(ODataRequest request, ODataResponse response) throws ODataJPAProcessException {
        JPAEntityType et;
        int handle = this.debugger.startRuntimeMeasurement(this, "deleteEntity");
        JPACUDRequestHandler handler = this.requestContext.getCUDRequestHandler();
        HashMap<String, Object> jpaKeyPredicates = new HashMap<String, Object>();
        List resourcePaths = this.uriInfo.getUriResourceParts();
        UriResourceEntitySet uriResourceEntitySet = (UriResourceEntitySet)resourcePaths.get(0);
        EdmEntitySet edmEntitySet = uriResourceEntitySet.getEntitySet();
        try {
            et = this.sessionContext.getEdmProvider().getServiceDocument().getEntity(edmEntitySet.getName());
            List uriKeyPredicates = uriResourceEntitySet.getKeyPredicates();
            for (UriParameter uriParam : uriKeyPredicates) {
                JPAAttribute attribute = et.getPath(uriParam.getName()).getLeaf();
                jpaKeyPredicates.put(attribute.getInternalName(), ExpressionUtil.convertValueOnAttribute(this.odata, attribute, uriParam.getText(), true));
            }
        }
        catch (ODataException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
        }
        JPARequestEntity requestEntity = this.createRequestEntity(et, jpaKeyPredicates, (Map<String, List<String>>)request.getAllHeaders());
        JPAODataTransactionFactory.JPAODataTransaction ownTransaction = null;
        boolean foreignTransaction = this.requestContext.getTransactionFactory().hasActiveTransaction();
        if (!foreignTransaction) {
            ownTransaction = this.requestContext.getTransactionFactory().createTransaction();
        }
        try {
            int deleteHandle = this.debugger.startRuntimeMeasurement(handler, "deleteEntity");
            handler.deleteEntity(requestEntity, this.em);
            if (!foreignTransaction) {
                handler.validateChanges(this.em);
            }
            this.debugger.stopRuntimeMeasurement(deleteHandle);
        }
        catch (ODataJPAProcessException e) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw e;
        }
        catch (Throwable e) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        if (!foreignTransaction) {
            ownTransaction.commit();
        }
        response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
        this.debugger.stopRuntimeMeasurement(handle);
    }

    public void updateEntity(ODataRequest request, ODataResponse response, ContentType requestFormat, ContentType responseFormat) throws ODataJPAProcessException, ODataLibraryException {
        int handle = this.debugger.startRuntimeMeasurement(this, DEBUG_UPDATE_ENTITY);
        JPACUDRequestHandler handler = this.requestContext.getCUDRequestHandler();
        EdmEntitySetInfo edmEntitySetInfo = Util.determineModifyEntitySetAndKeys(this.uriInfo.getUriResourceParts());
        Entity odataEntity = this.helper.convertInputStream(this.odata, request, requestFormat, this.uriInfo.getUriResourceParts());
        JPARequestEntity requestEntity = this.createRequestEntity(edmEntitySetInfo, odataEntity, (Map<String, List<String>>)request.getAllHeaders());
        JPAUpdateResult updateResult = null;
        JPAODataTransactionFactory.JPAODataTransaction ownTransaction = null;
        boolean foreignTransaction = this.requestContext.getTransactionFactory().hasActiveTransaction();
        if (!foreignTransaction) {
            ownTransaction = this.requestContext.getTransactionFactory().createTransaction();
        }
        try {
            int updateHandle = this.debugger.startRuntimeMeasurement(handler, DEBUG_UPDATE_ENTITY);
            updateResult = handler.updateEntity(requestEntity, this.em, this.determineHttpVerb(request, this.uriInfo.getUriResourceParts()));
            if (!foreignTransaction) {
                handler.validateChanges(this.em);
            }
            this.debugger.stopRuntimeMeasurement(updateHandle);
        }
        catch (ODataJPAProcessException e) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw e;
        }
        catch (Throwable e) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        if (updateResult == null) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.RETURN_NULL, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        if (updateResult.getModifyedEntity() != null && !requestEntity.getEntityType().getTypeClass().isInstance(updateResult.getModifyedEntity())) {
            if (!foreignTransaction) {
                ownTransaction.rollback();
            }
            this.debugger.stopRuntimeMeasurement(handle);
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.WRONG_RETURN_TYPE, HttpStatusCode.INTERNAL_SERVER_ERROR, updateResult.getModifyedEntity().getClass().toString(), requestEntity.getEntityType().getTypeClass().toString());
        }
        if (!foreignTransaction) {
            ownTransaction.commit();
        }
        if (updateResult.wasCreate()) {
            this.createCreateResponse(request, response, responseFormat, requestEntity.getEntityType(), edmEntitySetInfo.getEdmEntitySet(), updateResult.getModifyedEntity());
            this.debugger.stopRuntimeMeasurement(handle);
        } else {
            this.createUpdateResponse(request, response, responseFormat, requestEntity, edmEntitySetInfo, updateResult);
            this.debugger.stopRuntimeMeasurement(handle);
        }
    }

    private HttpMethod determineHttpVerb(ODataRequest request, List<UriResource> resourceParts) {
        HttpMethod originalMethod = request.getMethod();
        int noResourceParts = resourceParts.size();
        HttpMethod targetMethod = originalMethod == HttpMethod.PUT && resourceParts.get(noResourceParts - 1) instanceof UriResourceProperty ? HttpMethod.PATCH : originalMethod;
        return targetMethod;
    }

    final JPARequestEntity createRequestEntity(EdmEntitySet edmEntitySet, Entity odataEntity, Map<String, List<String>> headers) throws ODataJPAProcessorException {
        try {
            JPAEntityType et = this.sessionContext.getEdmProvider().getServiceDocument().getEntity(edmEntitySet.getName());
            return this.createRequestEntity(et, odataEntity, new HashMap<String, Object>(0), headers, null);
        }
        catch (ODataException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    final JPARequestEntity createRequestEntity(EdmEntitySetInfo edmEntitySetInfo, Entity odataEntity, Map<String, List<String>> headers) throws ODataJPAProcessorException {
        try {
            JPAEntityType et = this.sessionContext.getEdmProvider().getServiceDocument().getEntity(edmEntitySetInfo.getName());
            Map<String, Object> keys = this.helper.convertUriKeys(this.odata, (JPAStructuredType)et, edmEntitySetInfo.getKeyPredicates());
            JPARequestEntityImpl requestEntity = (JPARequestEntityImpl)this.createRequestEntity(et, odataEntity, keys, headers, et.getAssociationPath(edmEntitySetInfo.getNavigationPath()));
            requestEntity.setBeforeImage(this.createBeforeImage(requestEntity, this.em));
            return requestEntity;
        }
        catch (ODataException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    final JPARequestEntity createRequestEntity(JPAEntityType et, Entity odataEntity, Map<String, Object> keys, Map<String, List<String>> headers, JPAAssociationPath jpaAssociationPath) throws ODataJPAProcessorException {
        try {
            if (jpaAssociationPath == null) {
                Map<String, Object> jpaAttributes = this.helper.convertProperties(this.odata, (JPAStructuredType)et, odataEntity.getProperties());
                Map<JPAAssociationPath, List<JPARequestEntity>> relatedEntities = this.createInlineEntities(et, odataEntity, headers);
                Map<JPAAssociationPath, List<JPARequestLink>> relationLinks = this.createRelationLinks(et, odataEntity);
                return new JPARequestEntityImpl(et, jpaAttributes, relatedEntities, relationLinks, keys, headers, this.requestContext);
            }
            Map<JPAAssociationPath, List<JPARequestEntity>> relatedEntities = this.createInlineEntities(odataEntity, jpaAssociationPath, headers);
            return new JPARequestEntityImpl(et, Collections.emptyMap(), relatedEntities, Collections.emptyMap(), keys, headers, this.requestContext);
        }
        catch (ODataException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    final JPARequestEntity createRequestEntity(JPAEntityType et, Map<String, Object> keys, Map<String, List<String>> headers) {
        HashMap<String, Object> jpaAttributes = new HashMap<String, Object>(0);
        HashMap<JPAAssociationPath, List<JPARequestEntity>> relatedEntities = new HashMap<JPAAssociationPath, List<JPARequestEntity>>(0);
        HashMap<JPAAssociationPath, List<JPARequestLink>> relationLinks = new HashMap<JPAAssociationPath, List<JPARequestLink>>(0);
        return new JPARequestEntityImpl(et, jpaAttributes, relatedEntities, relationLinks, keys, headers, this.requestContext);
    }

    private Entity convertEntity(JPAEntityType et, Object result, Map<String, List<String>> headers) throws ODataJPAProcessorException {
        try {
            JPATupleChildConverter converter = new JPATupleChildConverter(this.sd, this.odata.createUriHelper(), this.serviceMetadata);
            JPACreateResultFactory factory = new JPACreateResultFactory(converter);
            return (Entity)((EntityCollection)converter.getResult(factory.getJPACreateResult(et, result, headers), (Collection)Collections.emptySet()).get("root")).getEntities().get(0);
        }
        catch (ODataJPAModelException | ODataApplicationException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private Map<String, Object> convertUriPath(JPAEntityType et, List<UriResource> resourcePaths) throws ODataJPAModelException {
        HashMap<String, Object> jpaAttributes;
        HashMap<String, Object> currentMap = jpaAttributes = new HashMap<String, Object>();
        JPAEntityType st = et;
        int lastIndex = resourcePaths.get(resourcePaths.size() - 1) instanceof UriResourceValue ? resourcePaths.size() - 1 : resourcePaths.size();
        for (int i = 1; i < lastIndex; ++i) {
            UriResourceProperty uriResourceProperty = (UriResourceProperty)resourcePaths.get(i);
            if (uriResourceProperty instanceof UriResourceComplexProperty && i < resourcePaths.size() - 1) {
                HashMap jpaEmbedded = new HashMap();
                JPAPath path = st.getPath(uriResourceProperty.getProperty().getName());
                String internalName = ((JPAElement)path.getPath().get(0)).getInternalName();
                currentMap.put(internalName, jpaEmbedded);
                currentMap = jpaEmbedded;
                st = st.getAttribute(internalName).getStructuredType();
                continue;
            }
            currentMap.put(st.getPath(uriResourceProperty.getProperty().getName()).getLeaf().getInternalName(), null);
        }
        return jpaAttributes;
    }

    private Optional<Object> createBeforeImage(JPARequestEntity requestEntity, EntityManager em) throws ODataJPAProcessorException, ODataJPAInvocationTargetException {
        if (!requestEntity.getKeys().isEmpty()) {
            Object key = requestEntity.getModifyUtil().createPrimaryKey(requestEntity.getEntityType(), requestEntity.getKeys(), (JPAStructuredType)requestEntity.getEntityType());
            Optional<Object> beforeImage = Optional.ofNullable(em.find(requestEntity.getEntityType().getTypeClass(), key));
            if (beforeImage.isPresent()) {
                em.detach(beforeImage.get());
            }
            return beforeImage;
        }
        return Optional.empty();
    }

    private void createCreateResponse(ODataRequest request, ODataResponse response, ContentType responseFormat, JPAEntityType et, EdmEntitySet edmEntitySet, Object result) throws SerializerException, ODataJPAProcessorException, ODataJPASerializerException {
        this.successStatusCode = HttpStatusCode.CREATED.getStatusCode();
        Preferences prefer = this.odata.createPreferences((Collection)request.getHeaders("Prefer"));
        String location = this.helper.convertKeyToLocal(this.odata, request, edmEntitySet, et, result);
        if (prefer.getReturn() == Preferences.Return.MINIMAL) {
            this.createMinimalCreateResponce(response, location);
        } else {
            Entity createdEntity = this.convertEntity(et, result, request.getAllHeaders());
            EntityCollection entities = new EntityCollection();
            entities.getEntities().add(createdEntity);
            this.createSuccessResponce(response, responseFormat, this.serializer.serialize(request, entities));
            response.setHeader("Location", location);
        }
    }

    private void createCreateResponse(ODataRequest request, ODataResponse response, ContentType responseFormat, JPARequestEntity requestEntity, EdmEntitySetInfo edmEntitySet, Object result) throws SerializerException, ODataJPAProcessorException, ODataJPASerializerException {
        if (!requestEntity.getKeys().isEmpty()) {
            try {
                JPAAssociationPath path = requestEntity.getEntityType().getAssociationPath(edmEntitySet.getNavigationPath());
                JPARequestEntity linkedEntity = requestEntity.getRelatedEntities().get(path).get(0);
                Object linkedResult = this.getLinkedResult(result, path, requestEntity.getBeforeImage());
                this.createCreateResponse(request, response, responseFormat, linkedEntity.getEntityType(), edmEntitySet.getTargetEdmEntitySet(), linkedResult);
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        } else {
            this.createCreateResponse(request, response, responseFormat, requestEntity.getEntityType(), edmEntitySet.getEdmEntitySet(), result);
        }
    }

    private Map<JPAAssociationPath, List<JPARequestEntity>> createInlineEntities(Entity odataEntity, JPAAssociationPath path, Map<String, List<String>> headers) throws ODataJPAProcessorException {
        HashMap<JPAAssociationPath, List<JPARequestEntity>> relatedEntities = new HashMap<JPAAssociationPath, List<JPARequestEntity>>(1);
        ArrayList<JPARequestEntity> inlineEntities = new ArrayList<JPARequestEntity>();
        inlineEntities.add(this.createRequestEntity((JPAEntityType)path.getTargetType(), odataEntity, new HashMap<String, Object>(0), headers, null));
        relatedEntities.put(path, inlineEntities);
        return relatedEntities;
    }

    private Map<JPAAssociationPath, List<JPARequestEntity>> createInlineEntities(JPAEntityType et, Entity odataEntity, Map<String, List<String>> headers) throws ODataJPAModelException, ODataJPAProcessorException {
        HashMap<JPAAssociationPath, List<JPARequestEntity>> relatedEntities = new HashMap<JPAAssociationPath, List<JPARequestEntity>>();
        block0: for (JPAAssociationPath path : et.getAssociationPathList()) {
            List stProperties = odataEntity.getProperties();
            Property p = null;
            for (JPAElement pathItem : path.getPath()) {
                if (pathItem == path.getLeaf()) {
                    Link navigationLink = p != null ? p.asComplex().getNavigationLink(pathItem.getExternalName()) : odataEntity.getNavigationLink(pathItem.getExternalName());
                    this.createInlineEntities((JPAEntityType)path.getTargetType(), headers, relatedEntities, navigationLink, path);
                }
                if ((p = this.findProperty(pathItem.getExternalName(), stProperties)) == null) continue block0;
                if (!p.isComplex()) continue;
                stProperties = p.asComplex().getValue();
            }
        }
        return relatedEntities;
    }

    private void createInlineEntities(JPAEntityType st, Map<String, List<String>> headers, Map<JPAAssociationPath, List<JPARequestEntity>> relatedEntities, Link navigationLink, JPAAssociationPath path) throws ODataJPAProcessorException {
        if (navigationLink == null) {
            return;
        }
        ArrayList<JPARequestEntity> inlineEntities = new ArrayList<JPARequestEntity>();
        if (path.getLeaf().isCollection()) {
            for (Entity e : navigationLink.getInlineEntitySet().getEntities()) {
                inlineEntities.add(this.createRequestEntity(st, e, new HashMap<String, Object>(0), headers, null));
            }
            relatedEntities.put(path, inlineEntities);
        } else {
            inlineEntities.add(this.createRequestEntity(st, navigationLink.getInlineEntity(), new HashMap<String, Object>(0), headers, null));
            relatedEntities.put(path, inlineEntities);
        }
    }

    private void createMinimalCreateResponce(ODataResponse response, String location) {
        response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
        response.setHeader("Preference-Applied", "return=minimal");
        response.setHeader("Location", location);
        response.setHeader("OData-EntityID", location);
    }

    private Map<JPAAssociationPath, List<JPARequestLink>> createRelationLinks(JPAEntityType et, Entity odataEntity) throws ODataJPAModelException {
        HashMap<JPAAssociationPath, List<JPARequestLink>> relationLinks = new HashMap<JPAAssociationPath, List<JPARequestLink>>();
        for (Link binding : odataEntity.getNavigationBindings()) {
            ArrayList<JPARequestLinkImpl> bindingLinks = new ArrayList<JPARequestLinkImpl>();
            JPAAssociationPath path = et.getAssociationPath(binding.getTitle());
            if (path.getLeaf().isCollection()) {
                for (String bindingLink : binding.getBindingLinks()) {
                    JPARequestLinkImpl requestLink = new JPARequestLinkImpl(path, bindingLink, this.helper);
                    bindingLinks.add(requestLink);
                }
            } else {
                JPARequestLinkImpl requestLink = new JPARequestLinkImpl(path, binding.getBindingLink(), this.helper);
                bindingLinks.add(requestLink);
            }
            relationLinks.put(path, bindingLinks);
        }
        return relationLinks;
    }

    private JPARequestEntity createRequestEntity(EdmEntitySetInfo edmEntitySetInfo, List<UriResource> resourceParts, Map<String, List<String>> headers) throws ODataJPAProcessorException {
        try {
            JPAEntityType et = this.sessionContext.getEdmProvider().getServiceDocument().getEntity(edmEntitySetInfo.getEdmEntitySet().getName());
            Map<String, Object> keys = this.helper.convertUriKeys(this.odata, (JPAStructuredType)et, edmEntitySetInfo.getKeyPredicates());
            Map<String, Object> jpaAttributes = this.convertUriPath(et, resourceParts);
            return new JPARequestEntityImpl(et, jpaAttributes, Collections.emptyMap(), Collections.emptyMap(), keys, headers, this.requestContext);
        }
        catch (ODataException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    private void createUpdateResponse(ODataRequest request, ODataResponse response, ContentType responseFormat, JPARequestEntity requestEntity, EdmEntitySetInfo edmEntitySetInfo, JPAUpdateResult updateResult) throws SerializerException, ODataJPAProcessorException, ODataJPASerializerException {
        this.successStatusCode = HttpStatusCode.OK.getStatusCode();
        Preferences prefer = this.odata.createPreferences((Collection)request.getHeaders("Prefer"));
        if (updateResult == null || prefer.getReturn() == Preferences.Return.MINIMAL) {
            response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
            response.setHeader("Preference-Applied", "return=minimal");
        } else {
            JPAAssociationPath path;
            if (updateResult.getModifyedEntity() == null) {
                throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.RETURN_MISSING_ENTITY, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            Entity updatedEntity = null;
            try {
                path = requestEntity.getEntityType().getAssociationPath(edmEntitySetInfo.getNavigationPath());
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            if (path != null) {
                JPARequestEntity linkedEntity = requestEntity.getRelatedEntities().get(path).get(0);
                Object linkedResult = this.getLinkedResult(updateResult.getModifyedEntity(), path, Optional.empty());
                updatedEntity = this.convertEntity(linkedEntity.getEntityType(), linkedResult, request.getAllHeaders());
            } else {
                updatedEntity = this.convertEntity(requestEntity.getEntityType(), updateResult.getModifyedEntity(), request.getAllHeaders());
            }
            EntityCollection entities = new EntityCollection();
            entities.getEntities().add(updatedEntity);
            this.createSuccessResponce(response, responseFormat, this.serializer.serialize(request, entities));
        }
    }

    private Property findProperty(String name, List<Property> properties) {
        for (Property property : properties) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    private Object getLinkedResult(Object result, JPAAssociationPath path, Optional<Object> beforeImage) throws ODataJPAProcessorException {
        if (result instanceof Map) {
            return this.getLinkedMapBasedResult((Map)result, path);
        }
        if (beforeImage.isPresent() && beforeImage.get().equals(result)) {
            return this.getLinkedInstanceBasedResultByDelta(result, path, beforeImage);
        }
        return this.getLinkedInstanceBasedResultByIndex(result, path);
    }

    Object getLinkedInstanceBasedResultByDelta(Object result, JPAAssociationPath path, Optional<Object> beforeImage) throws ODataJPAProcessorException {
        if (beforeImage.isPresent()) {
            if (this.em.contains(beforeImage.get())) {
                throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.BEFORE_IMAGE_MERGED, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            if (!path.getLeaf().isCollection()) {
                return this.getLinkedInstanceBasedResultByIndex(result, path);
            }
            Object value = result;
            Object before = beforeImage.get();
            for (JPAElement pathItem : path.getPath()) {
                Map<String, Object> valueGetterMap = this.helper.buildGetterMap(value);
                value = valueGetterMap.get(pathItem.getInternalName());
                Map<String, Object> beforeGetterMap = this.helper.determineGetter(before);
                before = beforeGetterMap.get(pathItem.getInternalName());
            }
            if (value != null && !((Collection)value).isEmpty()) {
                for (Object element : (Collection)value) {
                    if (((Collection)before).contains(element)) continue;
                    return element;
                }
            }
            return null;
        }
        return null;
    }

    private Object getLinkedInstanceBasedResultByIndex(Object result, JPAAssociationPath path) throws ODataJPAProcessorException {
        Object value = result;
        for (JPAElement pathItem : path.getPath()) {
            Map<String, Object> embeddedGetterMap = this.helper.buildGetterMap(value);
            value = embeddedGetterMap.get(pathItem.getInternalName());
        }
        if (path.getLeaf().isCollection() && value != null) {
            value = ((Collection)value).isEmpty() ? null : ((Collection)value).toArray()[0];
        }
        return value;
    }

    private Object getLinkedMapBasedResult(Map<String, Object> result, JPAAssociationPath path) {
        Map target = result;
        for (JPAElement pathItem : path.getPath()) {
            target = (Map)target.get(pathItem.getInternalName());
        }
        return target;
    }
}

