/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.processor.core.api.JPAServiceDebugger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.olingo.server.api.debug.RuntimeMeasurement;

class JPACoreDebugger
implements JPAServiceDebugger {
    private final List<RuntimeMeasurement> runtimeInformation = new ArrayList<RuntimeMeasurement>();

    JPACoreDebugger() {
    }

    @Override
    public int startRuntimeMeasurement(Object instance, String methodName) {
        int handleId = this.runtimeInformation.size();
        RuntimeMeasurement measurement = new RuntimeMeasurement();
        measurement.setTimeStarted(System.nanoTime());
        measurement.setClassName(instance.getClass().getSimpleName());
        measurement.setMethodName(methodName);
        this.runtimeInformation.add(measurement);
        return handleId;
    }

    @Override
    public void stopRuntimeMeasurement(int handle) {
        RuntimeMeasurement runtimeMeasurement;
        if (handle < this.runtimeInformation.size() && (runtimeMeasurement = this.runtimeInformation.get(handle)) != null && runtimeMeasurement.getTimeStopped() == 0L) {
            runtimeMeasurement.setTimeStopped(System.nanoTime());
        }
    }

    @Override
    public Collection<RuntimeMeasurement> getRuntimeInformation() {
        return this.runtimeInformation;
    }
}

