/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.processor.JPAAbstractGetRequestProcessor;
import com.sap.olingo.jpa.processor.core.query.JPAJoinQuery;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;

public final class JPACountRequestProcessor
extends JPAAbstractGetRequestProcessor {
    public JPACountRequestProcessor(OData odata, JPAODataCRUDContextAccess context, JPAODataRequestContextAccess requestContext) throws ODataException {
        super(odata, context, requestContext);
    }

    @Override
    public void retrieveData(ODataRequest request, ODataResponse response, ContentType responseFormat) throws ODataException {
        UriResource uriResource = (UriResource)this.uriInfo.getUriResourceParts().get(0);
        if (!(uriResource instanceof UriResourceEntitySet)) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_RESOURCE_TYPE, HttpStatusCode.NOT_IMPLEMENTED, uriResource.getKind().toString());
        }
        EntityCollection result = this.countEntities(request, this.uriInfo);
        this.createSuccessResponce(response, ContentType.TEXT_PLAIN, this.serializer.serialize(request, result));
    }

    protected final EntityCollection countEntities(ODataRequest request, UriInfoResource uriInfo) throws ODataException {
        JPAJoinQuery query = null;
        try {
            query = new JPAJoinQuery(this.odata, this.sessionContext, request.getAllHeaders(), this.requestContext);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.QUERY_PREPARATION_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        EntityCollection entityCollection = new EntityCollection();
        entityCollection.setCount(Integer.valueOf(query.countResults().intValue()));
        return entityCollection;
    }
}

