/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.metadata.core.edm.annotation.EdmFunctionType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADataBaseFunction;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEnumerationAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAFunction;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAJavaFunction;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAOperation;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAParameter;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataDatabaseProcessor;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPADBAdaptorException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.processor.JPAOperationRequestProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPARequestProcessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceFunction;

public final class JPAFunctionRequestProcessor
extends JPAOperationRequestProcessor
implements JPARequestProcessor {
    private final JPAODataDatabaseProcessor dbProcessor;

    public JPAFunctionRequestProcessor(OData odata, JPAODataCRUDContextAccess context, JPAODataRequestContextAccess requestContext) throws ODataException {
        super(odata, context, requestContext);
        this.dbProcessor = context.getDatabaseProcessor();
    }

    @Override
    public void retrieveData(ODataRequest request, ODataResponse response, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        Object result = null;
        UriResourceFunction uriResourceFunction = (UriResourceFunction)this.uriInfo.getUriResourceParts().get(this.uriInfo.getUriResourceParts().size() - 1);
        JPAFunction jpaFunction = this.sd.getFunction(uriResourceFunction.getFunction());
        if (jpaFunction.getFunctionType() == EdmFunctionType.JavaClass) {
            result = this.processJavaFunction(uriResourceFunction, (JPAJavaFunction)jpaFunction, this.em);
        } else if (jpaFunction.getFunctionType() == EdmFunctionType.UserDefinedFunction) {
            result = this.processJavaUDF(this.uriInfo.getUriResourceParts(), (JPADataBaseFunction)jpaFunction);
        }
        EdmType returnType = uriResourceFunction.getFunction().getReturnType().getType();
        Annotatable annotatable = this.convertResult(result, returnType, (JPAOperation)jpaFunction);
        this.serializeResult(returnType, response, responseFormat, annotatable, request);
    }

    private Object getValue(EdmFunction edmFunction, JPAParameter parameter, String uriValue) throws ODataApplicationException {
        String value = uriValue.replaceAll("'", "");
        EdmParameter edmParam = edmFunction.getParameter(parameter.getName());
        try {
            switch (edmParam.getType().getKind()) {
                case PRIMITIVE: {
                    return ((EdmPrimitiveType)edmParam.getType()).valueOfString(value, Boolean.valueOf(false), edmParam.getMaxLength(), edmParam.getPrecision(), edmParam.getScale(), Boolean.valueOf(true), parameter.getType());
                }
                case ENUM: {
                    JPAEnumerationAttribute enumeration = this.sd.getEnumType(parameter.getTypeFQN().getFullQualifiedNameAsString());
                    return enumeration.enumOf(value);
                }
            }
            throw new ODataJPADBAdaptorException(ODataJPADBAdaptorException.MessageKeys.PARAMETER_CONVERSION_ERROR, HttpStatusCode.NOT_IMPLEMENTED, uriValue, parameter.getName());
        }
        catch (ODataJPAModelException | EdmPrimitiveTypeException e) {
            throw new ODataJPADBAdaptorException(ODataJPADBAdaptorException.MessageKeys.PARAMETER_CONVERSION_ERROR, HttpStatusCode.NOT_IMPLEMENTED, uriValue, parameter.getName());
        }
    }

    private Object processJavaFunction(UriResourceFunction uriResourceFunction, JPAJavaFunction jpaFunction, EntityManager em) throws ODataApplicationException {
        Constructor c = jpaFunction.getConstructor();
        try {
            Parameter[] methodParameter;
            Object instance = c.getParameterCount() == 1 ? c.newInstance(em) : c.newInstance(new Object[0]);
            ArrayList<Object> parameter = new ArrayList<Object>();
            block3: for (Parameter declairedParameter : methodParameter = jpaFunction.getMethod().getParameters()) {
                for (UriParameter providedParameter : uriResourceFunction.getParameters()) {
                    JPAParameter jpaParameter = jpaFunction.getParameter(declairedParameter.getName());
                    if (!jpaParameter.getName().equals(providedParameter.getName())) continue;
                    parameter.add(this.getValue(uriResourceFunction.getFunction(), jpaParameter, providedParameter.getText()));
                    continue block3;
                }
            }
            return jpaFunction.getMethod().invoke(instance, parameter.toArray());
        }
        catch (ODataJPAModelException | IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ODataApplicationException) {
                throw (ODataApplicationException)cause;
            }
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private Object processJavaUDF(List<UriResource> uriResourceParts, JPADataBaseFunction jpaFunction) throws ODataApplicationException {
        return this.dbProcessor.executeFunctionQuery(uriResourceParts, jpaFunction, this.em);
    }
}

