/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAOnConditionItem;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAInvocationTargetException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.processor.JPARequestEntity;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.http.HttpStatusCode;

public final class JPAModifyUtil {
    private JPAStructuredType st = null;

    public Object createPrimaryKey(JPAEntityType et, Map<String, Object> jpaKeys, JPAStructuredType st) throws ODataJPAProcessorException, ODataJPAInvocationTargetException {
        try {
            if (et.getKey().size() == 1) {
                return jpaKeys.get(((JPAAttribute)et.getKey().get(0)).getInternalName());
            }
            Object key = et.getKeyType().getConstructor(new Class[0]).newInstance(new Object[0]);
            this.setAttributes(jpaKeys, key, st);
            return key;
        }
        catch (ODataJPAModelException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    public Object createPrimaryKey(JPAEntityType et, Object instance) throws ODataJPAProcessorException {
        try {
            if (et.getKey().size() == 1) {
                return this.getAttribute(instance, (JPAElement)et.getKey().get(0));
            }
            Object key = et.getKeyType().getConstructor(new Class[0]).newInstance(new Object[0]);
            for (JPAAttribute keyElement : et.getKey()) {
                this.setAttribute(key, (JPAElement)keyElement, this.getAttribute(instance, (JPAElement)keyElement));
            }
            return key;
        }
        catch (ODataJPAModelException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    public <T> void linkEntities(Object sourceInstance, T targetInstance, JPAAssociationPath pathInfo) throws ODataJPAProcessorException {
        try {
            Object source = this.determineSourceForLink(sourceInstance, pathInfo);
            this.setLink(source, targetInstance, pathInfo.getLeaf());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    public void setForeignKey(Object parentInstance, Object newInstance, JPAAssociationPath pathInfo) throws ODataJPAProcessorException {
        try {
            for (JPAOnConditionItem joinCloumn : pathInfo.getJoinColumnsList()) {
                this.setAttribute(newInstance, (JPAElement)joinCloumn.getRightPath().getLeaf(), this.getAttribute(parentInstance, (JPAElement)joinCloumn.getLeftPath().getLeaf()));
            }
        }
        catch (ODataJPAModelException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    public void setAttributes(Map<String, Object> jpaAttributes, Object instanze, JPAStructuredType st) throws ODataJPAProcessorException, ODataJPAInvocationTargetException {
        Method[] methods;
        for (Method meth : methods = instanze.getClass().getMethods()) {
            Object value;
            String attributeName;
            if (!meth.getName().substring(0, 3).equals("set") || !jpaAttributes.containsKey(attributeName = meth.getName().substring(3, 4).toLowerCase() + meth.getName().substring(4)) || (value = jpaAttributes.get(attributeName)) instanceof Map || value instanceof JPARequestEntity) continue;
            try {
                Class<?>[] parameters = meth.getParameterTypes();
                if (parameters.length != 1 || value != null && value.getClass() != parameters[0]) continue;
                meth.invoke(instanze, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            catch (InvocationTargetException e) {
                try {
                    throw new ODataJPAInvocationTargetException(e.getCause(), st.getExternalName() + "/" + st.getAttribute(attributeName).getExternalName());
                }
                catch (ODataJPAModelException e1) {
                    throw new ODataJPAProcessorException(e1, HttpStatusCode.INTERNAL_SERVER_ERROR);
                }
            }
        }
    }

    public void setAttributesDeep(Map<String, Object> jpaAttributes, Object instanze, JPAStructuredType st) throws ODataJPAProcessorException, ODataJPAInvocationTargetException {
        Method[] methods;
        for (Method meth : methods = instanze.getClass().getMethods()) {
            String attributeName;
            if (!meth.getName().substring(0, 3).equals("set") || !jpaAttributes.containsKey(attributeName = meth.getName().substring(3, 4).toLowerCase() + meth.getName().substring(4))) continue;
            Object value = jpaAttributes.get(attributeName);
            Class<?>[] parameters = meth.getParameterTypes();
            if (value instanceof JPARequestEntity || parameters.length != 1) continue;
            try {
                JPAAttribute attribute = st.getAttribute(attributeName);
                if (!attribute.isComplex() || value == null) {
                    if (value != null && !parameters[0].isAssignableFrom(value.getClass())) continue;
                    meth.invoke(instanze, value);
                    continue;
                }
                if (attribute.isCollection()) {
                    this.setEmbeddedCollectionAttributeDeep(instanze, st, meth, value, parameters, attribute);
                    continue;
                }
                this.setEmbeddedAttributeDeep(instanze, st, meth, value, parameters, attribute);
            }
            catch (ODataJPAModelException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            catch (ODataJPAInvocationTargetException | InvocationTargetException e) {
                this.handleInvocationTargetException(st, attributeName, (Exception)e);
            }
        }
    }

    private void setEmbeddedAttributeDeep(Object instanze, JPAStructuredType st, Method meth, Object value, Class<?>[] parameters, JPAAttribute attribute) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ODataJPAModelException, ODataJPAProcessorException, ODataJPAInvocationTargetException {
        Object embedded = this.readCurrentState(instanze, (JPAElement)attribute);
        if (embedded == null) {
            embedded = this.createInstance(parameters[0]);
            meth.invoke(instanze, embedded);
        }
        if (embedded != null) {
            if (this.st == null) {
                this.st = st;
            }
            this.setAttributesDeep((Map)value, embedded, attribute.getStructuredType());
            if (this.st.equals(st)) {
                this.st = null;
            }
        }
    }

    private void setEmbeddedCollectionAttributeDeep(Object instanze, JPAStructuredType st, Method meth, Object value, Class<?>[] parameters, JPAAttribute attribute) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ODataJPAModelException, ODataJPAProcessorException, ODataJPAInvocationTargetException {
        Collection embedded = (Collection)this.readCurrentState(instanze, (JPAElement)attribute);
        if (embedded == null) {
            embedded = parameters[0].isAssignableFrom(List.class) ? (Collection)this.createInstance(ArrayList.class) : (Collection)this.createInstance(parameters[0]);
            meth.invoke(instanze, embedded);
        }
        if (embedded != null) {
            if (this.st == null) {
                this.st = st;
            }
            embedded.clear();
            for (Map collectionElement : (Collection)value) {
                Object line = this.createInstance(attribute.getStructuredType().getTypeClass());
                this.setAttributesDeep(collectionElement, line, attribute.getStructuredType());
                embedded.add(line);
            }
            if (this.st.equals(st)) {
                this.st = null;
            }
        }
    }

    private Object createInstance(Class<?> type) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] parameter = new Class[]{};
        Constructor<?> cons = type.getConstructor(parameter);
        return cons.newInstance(new Object[0]);
    }

    private Object determineSourceForLink(Object sourceInstance, JPAAssociationPath pathInfo) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ODataJPAProcessorException {
        Object source = sourceInstance;
        for (JPAElement pathItem : pathInfo.getPath()) {
            if (pathItem == pathInfo.getLeaf()) continue;
            String methodSuffix = this.buildMethodNameSuffix(pathItem);
            Method getter = source.getClass().getMethod("get" + methodSuffix, new Class[0]);
            Object next = getter.invoke(source, new Object[0]);
            if (next == null) {
                try {
                    Constructor c = ((JPAAttribute)pathItem).getStructuredType().getTypeClass().getConstructor(new Class[0]);
                    next = c.newInstance(new Object[0]);
                    Method setter = source.getClass().getMethod("set" + methodSuffix, next.getClass());
                    setter.invoke(source, next);
                }
                catch (ODataJPAModelException | InstantiationException e) {
                    throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
                }
            }
            source = next;
        }
        return source;
    }

    private String buildMethodNameSuffix(JPAElement pathItem) {
        String relationName = pathItem.getInternalName();
        return relationName.substring(0, 1).toUpperCase() + relationName.substring(1);
    }

    private void handleInvocationTargetException(JPAStructuredType st, String attributeName, Exception e) throws ODataJPAInvocationTargetException, ODataJPAProcessorException {
        String pathPart = null;
        try {
            pathPart = st.getAttribute(attributeName).getExternalName();
            if (this.st != null && this.st.equals(st)) {
                String path = st.getExternalName() + "/" + pathPart + "/" + ((ODataJPAInvocationTargetException)((Object)e)).getPath();
                this.st = null;
                throw new ODataJPAInvocationTargetException(e.getCause(), path);
            }
        }
        catch (ODataJPAModelException e1) {
            throw new ODataJPAProcessorException(e1, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        if (e instanceof ODataJPAInvocationTargetException) {
            throw new ODataJPAInvocationTargetException(e.getCause(), pathPart + "/" + ((ODataJPAInvocationTargetException)((Object)e)).getPath());
        }
        throw new ODataJPAInvocationTargetException(e.getCause(), pathPart);
    }

    private <T> void setLink(Object sourceInstance, T targetInstance, JPAAssociationAttribute attribute) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ODataJPAProcessorException {
        String methodSuffix = attribute.getInternalName().substring(0, 1).toUpperCase() + attribute.getInternalName().substring(1);
        if (attribute.isCollection()) {
            Method getter = sourceInstance.getClass().getMethod("get" + methodSuffix, new Class[0]);
            ((Collection)getter.invoke(sourceInstance, new Object[0])).add(targetInstance);
        } else {
            Method setter = null;
            Class<?> clazz = targetInstance.getClass();
            while (clazz != null && setter == null) {
                try {
                    setter = sourceInstance.getClass().getMethod("set" + methodSuffix, clazz);
                }
                catch (NoSuchMethodException e) {
                    clazz = clazz.getSuperclass();
                }
            }
            if (setter == null) {
                throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.SETTER_NOT_FOUND, HttpStatusCode.INTERNAL_SERVER_ERROR, "set" + methodSuffix, sourceInstance.getClass().getName(), targetInstance.getClass().getName());
            }
            setter.invoke(sourceInstance, targetInstance);
        }
    }

    private void setAttribute(Object instance, JPAElement attribute, Object value) throws NoSuchMethodException, ODataJPAProcessorException, IllegalAccessException, InvocationTargetException {
        Method setter = instance.getClass().getMethod("set" + this.buildMethodNameSuffix(attribute), value.getClass());
        if (setter == null) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.SETTER_NOT_FOUND, HttpStatusCode.INTERNAL_SERVER_ERROR, this.buildMethodNameSuffix(attribute), instance.getClass().getName(), value.getClass().getName());
        }
        setter.invoke(instance, value);
    }

    private Object getAttribute(Object instance, JPAElement attribute) throws NoSuchMethodException, ODataJPAProcessorException, IllegalAccessException, InvocationTargetException {
        Method getter = instance.getClass().getMethod("get" + this.buildMethodNameSuffix(attribute), new Class[0]);
        if (getter == null) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.GETTER_NOT_FOUND, HttpStatusCode.INTERNAL_SERVER_ERROR, this.buildMethodNameSuffix(attribute), instance.getClass().getName());
        }
        return getter.invoke(instance, new Object[0]);
    }

    private Object readCurrentState(Object instance, JPAElement attribute) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method getter = instance.getClass().getMethod("get" + this.buildMethodNameSuffix(attribute), new Class[0]);
        if (getter == null) {
            return null;
        }
        return getter.invoke(instance, new Object[0]);
    }
}

