/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataPage;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.converter.JPAExpandResult;
import com.sap.olingo.jpa.processor.core.converter.JPATupleChildConverter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPANotImplementedException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.processor.JPAAbstractGetRequestProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPAODataRequestContextImpl;
import com.sap.olingo.jpa.processor.core.query.JPACollectionItemInfo;
import com.sap.olingo.jpa.processor.core.query.JPACollectionJoinQuery;
import com.sap.olingo.jpa.processor.core.query.JPACollectionQueryResult;
import com.sap.olingo.jpa.processor.core.query.JPAConvertableResult;
import com.sap.olingo.jpa.processor.core.query.JPAExpandItemInfo;
import com.sap.olingo.jpa.processor.core.query.JPAExpandItemInfoFactory;
import com.sap.olingo.jpa.processor.core.query.JPAExpandJoinQuery;
import com.sap.olingo.jpa.processor.core.query.JPAExpandQueryResult;
import com.sap.olingo.jpa.processor.core.query.JPAJoinQuery;
import com.sap.olingo.jpa.processor.core.query.JPAKeyBoundary;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;

public final class JPANavigationRequestProcessor
extends JPAAbstractGetRequestProcessor {
    private final ServiceMetadata serviceMetadata;
    private final UriResource lastItem;
    private final JPAODataPage page;

    public JPANavigationRequestProcessor(OData odata, ServiceMetadata serviceMetadata, JPAODataCRUDContextAccess context, JPAODataRequestContextAccess requestContext) throws ODataException {
        super(odata, context, requestContext);
        this.serviceMetadata = serviceMetadata;
        List resourceParts = this.uriInfo.getUriResourceParts();
        this.lastItem = (UriResource)resourceParts.get(resourceParts.size() - 1);
        this.page = requestContext.getPage();
    }

    @Override
    public <K extends Comparable<K>> void retrieveData(ODataRequest request, ODataResponse response, ContentType responseFormat) throws ODataException {
        EntityCollection entityCollection;
        int handle = this.debugger.startRuntimeMeasurement(this, "retrieveData");
        JPAJoinQuery query = null;
        this.checkRequestSupported();
        try {
            query = new JPAJoinQuery(this.odata, this.sessionContext, request.getAllHeaders(), this.requestContext);
        }
        catch (ODataException e) {
            this.debugger.stopRuntimeMeasurement(handle);
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.QUERY_PREPARATION_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        JPAConvertableResult result = query.execute();
        Optional<JPAKeyBoundary> keyBoundary = result.getKeyBoundary(this.requestContext, query.getNavigationInfo());
        result.putChildren(this.readExpandEntities(request.getAllHeaders(), query.getNavigationInfo(), this.uriInfo, keyBoundary));
        int converterHandle = this.debugger.startRuntimeMeasurement(this, "convertResult");
        try {
            entityCollection = result.asEntityCollection(new JPATupleChildConverter(this.sd, this.odata.createUriHelper(), this.serviceMetadata)).get("root");
            this.debugger.stopRuntimeMeasurement(converterHandle);
        }
        catch (ODataApplicationException e) {
            this.debugger.stopRuntimeMeasurement(converterHandle);
            this.debugger.stopRuntimeMeasurement(handle);
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        entityCollection.setNext(this.buildNextLink(this.page));
        CountOption countOption = this.uriInfo.getCountOption();
        if (countOption != null && countOption.getValue()) {
            entityCollection.setCount(Integer.valueOf(new JPAJoinQuery(this.odata, this.sessionContext, request.getAllHeaders(), this.requestContext).countResults().intValue()));
        }
        if (this.hasNoContent(entityCollection.getEntities())) {
            response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
        } else if (this.doesNoeExists(entityCollection.getEntities())) {
            response.setStatusCode(HttpStatusCode.NOT_FOUND.getStatusCode());
        } else if (entityCollection.getEntities() != null) {
            int serializerHandle = this.debugger.startRuntimeMeasurement(this.serializer, "serialize");
            SerializerResult serializerResult = this.serializer.serialize(request, entityCollection);
            this.debugger.stopRuntimeMeasurement(serializerHandle);
            this.createSuccessResponce(response, responseFormat, serializerResult);
        } else {
            response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
        }
        this.debugger.stopRuntimeMeasurement(handle);
    }

    private void checkRequestSupported() throws ODataJPAProcessException {
        if (this.uriInfo.getApplyOption() != null) {
            throw new ODataJPANotImplementedException("$apply");
        }
    }

    private URI buildNextLink(JPAODataPage page) throws ODataJPAProcessorException {
        if (page != null && page.getSkiptoken() != null) {
            try {
                if (page.getSkiptoken() instanceof String) {
                    return new URI(Util.determineTargetEntitySet(this.uriInfo.getUriResourceParts()).getName() + "?" + SystemQueryOptionKind.SKIPTOKEN.toString() + "='" + page.getSkiptoken() + "'");
                }
                return new URI(Util.determineTargetEntitySet(this.uriInfo.getUriResourceParts()).getName() + "?" + SystemQueryOptionKind.SKIPTOKEN.toString() + "=" + page.getSkiptoken().toString());
            }
            catch (URISyntaxException e) {
                throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.ODATA_MAXPAGESIZE_NOT_A_NUMBER, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        return null;
    }

    private boolean complexHasNoContent(List<Entity> entities) {
        if (entities.isEmpty()) {
            return false;
        }
        String name = Util.determineStartNavigationPath(this.uriInfo.getUriResourceParts()).getProperty().getName();
        Property property = entities.get(0).getProperty(name);
        if (property != null) {
            for (Property p : ((ComplexValue)property.getValue()).getValue()) {
                if (p.getValue() == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean doesNoeExists(List<Entity> entities) throws ODataApplicationException {
        return entities.isEmpty() && (this.lastItem.getKind() == UriResourceKind.primitiveProperty || this.lastItem.getKind() == UriResourceKind.complexProperty || this.lastItem.getKind() == UriResourceKind.entitySet && !Util.determineKeyPredicates(this.lastItem).isEmpty());
    }

    private boolean hasNoContent(List<Entity> entities) {
        if (this.lastItem.getKind() == UriResourceKind.primitiveProperty || this.lastItem.getKind() == UriResourceKind.navigationProperty || this.lastItem.getKind() == UriResourceKind.complexProperty) {
            if (((UriResourcePartTyped)this.lastItem).isCollection()) {
                return false;
            }
            if (this.lastItem.getKind() == UriResourceKind.primitiveProperty) {
                return this.primitiveHasNoContent(entities);
            }
            if (this.lastItem.getKind() == UriResourceKind.complexProperty) {
                return this.complexHasNoContent(entities);
            }
            if (entities.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private boolean primitiveHasNoContent(List<Entity> entities) {
        if (entities.isEmpty()) {
            return false;
        }
        String name = Util.determineStartNavigationPath(this.uriInfo.getUriResourceParts()).getProperty().getName();
        Property property = entities.get(0).getProperty(name);
        return property != null && property.getValue() == null;
    }

    private Map<JPAAssociationPath, JPAExpandResult> readExpandEntities(Map<String, List<String>> headers, List<JPANavigationProptertyInfo> parentHops, UriInfoResource uriResourceInfo, Optional<JPAKeyBoundary> keyBoundary) throws ODataException {
        int handle = this.debugger.startRuntimeMeasurement(this, "readExpandEntities");
        HashMap<JPAAssociationPath, JPAExpandResult> allExpResults = new HashMap<JPAAssociationPath, JPAExpandResult>();
        List<JPAExpandItemInfo> itemInfoList = new JPAExpandItemInfoFactory().buildExpandItemInfo(this.sd, uriResourceInfo, parentHops);
        for (JPAExpandItemInfo item : itemInfoList) {
            JPAExpandJoinQuery expandQuery = new JPAExpandJoinQuery(this.odata, this.sessionContext, item, headers, this.requestContext, keyBoundary);
            JPAExpandQueryResult expandResult = expandQuery.execute();
            if (expandResult.getNoResults() > 0L) {
                expandResult.putChildren(this.readExpandEntities(headers, item.getHops(), item.getUriInfo(), keyBoundary));
            }
            allExpResults.put(item.getExpandAssociation(), expandResult);
        }
        List<JPACollectionItemInfo> collectionInfoList = new JPAExpandItemInfoFactory().buildCollectionItemInfo(this.sd, uriResourceInfo, parentHops, this.requestContext.getGroupsProvider());
        for (JPACollectionItemInfo item : collectionInfoList) {
            JPACollectionJoinQuery collectionQuery = new JPACollectionJoinQuery(this.odata, this.sessionContext, this.em, item, headers, new JPAODataRequestContextImpl(item.getUriInfo(), this.requestContext), keyBoundary);
            JPACollectionQueryResult expandResult = collectionQuery.execute();
            allExpResults.put(item.getExpandAssociation(), expandResult);
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return allExpResults;
    }
}

