/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.processor.core.api.JPAAbstractCUDRequestHandler;
import com.sap.olingo.jpa.processor.core.api.JPACUDRequestHandler;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDRequestContext;
import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.api.JPAODataDefaultTransactionFactory;
import com.sap.olingo.jpa.processor.core.api.JPAODataGroupProvider;
import com.sap.olingo.jpa.processor.core.api.JPAODataPage;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataTransactionFactory;
import com.sap.olingo.jpa.processor.core.api.JPAServiceDebugger;
import com.sap.olingo.jpa.processor.core.exception.JPAIllicalAccessException;
import com.sap.olingo.jpa.processor.core.processor.JPACoreDebugger;
import com.sap.olingo.jpa.processor.core.processor.JPAEmptyDebugger;
import com.sap.olingo.jpa.processor.core.processor.JPARequestContext;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.debug.DebugInformation;
import org.apache.olingo.server.api.debug.DebugSupport;
import org.apache.olingo.server.api.debug.RuntimeMeasurement;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;

public final class JPAODataRequestContextImpl
implements JPAODataCRUDRequestContext,
JPAODataRequestContextAccess,
JPARequestContext {
    private Optional<JPAODataClaimProvider> claims = Optional.empty();
    private Optional<JPAODataGroupProvider> groups = Optional.empty();
    private EntityManager em;
    private UriInfoResource uriInfo;
    private JPASerializer serializer;
    private JPAODataPage page;
    private JPACUDRequestHandler jpaCUDRequestHandler;
    private JPAServiceDebugger debugger;
    private JPADebugSupportWrapper debugSupport;
    private String debugFormat;
    private JPAODataTransactionFactory transactionFactory;

    public JPAODataRequestContextImpl() {
    }

    public JPAODataRequestContextImpl(UriInfoResource uriInfo, JPAODataRequestContextAccess context) {
        this(uriInfo, null, context);
    }

    JPAODataRequestContextImpl(JPAODataPage page, JPASerializer serializer, JPAODataRequestContextAccess context) throws JPAIllicalAccessException {
        this.copyContextValues(context);
        this.serializer = serializer;
        this.jpaCUDRequestHandler = new JPADefaultCUDRequestHandler();
        this.setJPAODataPage(page);
    }

    JPAODataRequestContextImpl(UriInfoResource uriInfo, @Nullable JPASerializer serializer, JPAODataRequestContextAccess context) {
        this.copyContextValues(context);
        this.serializer = serializer;
        this.uriInfo = uriInfo;
    }

    @Override
    public Optional<JPAODataClaimProvider> getClaimsProvider() {
        return this.claims;
    }

    @Override
    public JPACUDRequestHandler getCUDRequestHandler() {
        return this.jpaCUDRequestHandler;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public Optional<JPAODataGroupProvider> getGroupsProvider() {
        return this.groups;
    }

    @Override
    public JPAODataPage getPage() {
        return this.page;
    }

    @Override
    public JPASerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public JPAODataTransactionFactory getTransactionFactory() {
        if (this.transactionFactory == null) {
            this.createDefaultTransactionFactory();
        }
        return this.transactionFactory;
    }

    @Override
    public UriInfoResource getUriInfo() {
        return this.uriInfo;
    }

    @Override
    public void setClaimsProvider(JPAODataClaimProvider provider) {
        this.claims = Optional.ofNullable(provider);
    }

    @Override
    public void setCUDRequestHandler(@Nonnull JPACUDRequestHandler jpaCUDRequestHandler) {
        this.jpaCUDRequestHandler = Objects.requireNonNull(jpaCUDRequestHandler);
    }

    @Override
    public void setEntityManager(@Nonnull EntityManager em) {
        this.em = Objects.requireNonNull(em);
    }

    @Override
    public void setGroupsProvider(JPAODataGroupProvider provider) {
        this.groups = Optional.ofNullable(provider);
    }

    @Override
    public void setJPAODataPage(@Nonnull JPAODataPage page) throws JPAIllicalAccessException {
        if (this.uriInfo != null) {
            throw new JPAIllicalAccessException();
        }
        this.setUriInfo(page.getUriInfo());
        this.page = Objects.requireNonNull(page);
    }

    @Override
    public void setDebugSupport(DebugSupport debugSupport) {
        this.debugSupport = new JPADebugSupportWrapper(debugSupport);
    }

    @Override
    public void setJPASerializer(@Nonnull JPASerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer);
    }

    @Override
    public void setTransactionFactory(@Nullable JPAODataTransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    @Override
    public void setUriInfo(@Nonnull UriInfo uriInfo) throws JPAIllicalAccessException {
        if (this.page != null) {
            throw new JPAIllicalAccessException();
        }
        this.uriInfo = (UriInfoResource)Objects.requireNonNull(uriInfo);
    }

    @Override
    public JPAServiceDebugger getDebugger() {
        if (this.debugger == null) {
            this.initDebugger();
        }
        return this.debugger;
    }

    public void setDebugFormat(String debugFormat) {
        this.debugFormat = debugFormat;
    }

    private void initDebugger() {
        boolean isDebugMode = false;
        this.debugger = new JPAEmptyDebugger();
        if (this.debugSupport != null) {
            if (this.debugFormat != null) {
                this.debugSupport.init(OData.newInstance());
                isDebugMode = this.debugSupport.isUserAuthorized();
            }
            if (isDebugMode) {
                this.debugger = new JPACoreDebugger();
            }
            this.debugSupport.setDebugger(this.debugger);
        }
    }

    private void copyContextValues(JPAODataRequestContextAccess context) {
        this.claims = context.getClaimsProvider();
        this.groups = context.getGroupsProvider();
        this.em = context.getEntityManager();
        this.jpaCUDRequestHandler = context.getCUDRequestHandler();
        this.debugger = context.getDebugger();
    }

    private void createDefaultTransactionFactory() {
        this.transactionFactory = new JPAODataDefaultTransactionFactory(this.em);
    }

    public JPADebugSupportWrapper getDebugSupport() {
        if (this.debugger == null) {
            this.initDebugger();
        }
        return this.debugSupport;
    }

    private class JPADefaultCUDRequestHandler
    extends JPAAbstractCUDRequestHandler {
        private JPADefaultCUDRequestHandler() {
        }
    }

    private class JPADebugSupportWrapper
    implements DebugSupport {
        private final DebugSupport debugSupport;
        private JPAServiceDebugger debugger;

        public JPADebugSupportWrapper(DebugSupport debugSupport) {
            this.debugSupport = debugSupport;
        }

        public ODataResponse createDebugResponse(String debugFormat, DebugInformation debugInfo) {
            this.joinRuntimeInfo(debugInfo);
            return this.debugSupport.createDebugResponse(debugFormat, debugInfo);
        }

        public void init(OData odata) {
            this.debugSupport.init(odata);
        }

        public boolean isUserAuthorized() {
            return this.debugSupport.isUserAuthorized();
        }

        void setDebugger(JPAServiceDebugger debugger) {
            this.debugger = debugger;
        }

        private void joinRuntimeInfo(DebugInformation debugInfo) {
            List olingoInfo = debugInfo.getRuntimeInformation();
            int startIndex = 0;
            for (RuntimeMeasurement m : this.debugger.getRuntimeInformation()) {
                while (startIndex < olingoInfo.size() && ((RuntimeMeasurement)olingoInfo.get(startIndex)).getTimeStarted() <= m.getTimeStarted()) {
                    ++startIndex;
                }
                olingoInfo.add(startIndex, m);
                ++startIndex;
            }
        }
    }
}

