/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAOperation;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.converter.JPAComplexResultConverter;
import com.sap.olingo.jpa.processor.core.converter.JPAEntityResultConverter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.processor.JPAAbstractRequestProcessor;
import com.sap.olingo.jpa.processor.core.serializer.JPAOperationSerializer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriHelper;

abstract class JPAOperationRequestProcessor
extends JPAAbstractRequestProcessor {
    private static final String RESULT = "Result";

    public JPAOperationRequestProcessor(OData odata, JPAODataCRUDContextAccess context, JPAODataRequestContextAccess requestContext) throws ODataException {
        super(odata, context, requestContext);
    }

    protected Annotatable convertResult(Object result, EdmType returnType, JPAOperation jpaOperation) throws ODataApplicationException {
        switch (returnType.getKind()) {
            case PRIMITIVE: {
                if (jpaOperation.getResultParameter().isCollection()) {
                    ArrayList response = new ArrayList();
                    response.addAll((Collection)result);
                    return new Property(null, RESULT, ValueType.COLLECTION_PRIMITIVE, response);
                }
                if (result == null) {
                    return null;
                }
                return new Property(null, RESULT, ValueType.PRIMITIVE, result);
            }
            case ENTITY: {
                return this.createEntityCollection((EdmEntityType)returnType, result, this.odata.createUriHelper(), jpaOperation);
            }
            case COMPLEX: {
                if (jpaOperation.getResultParameter().isCollection()) {
                    return new Property(null, RESULT, ValueType.COLLECTION_COMPLEX, this.createComplexCollection((EdmComplexType)returnType, result));
                }
                if (result == null) {
                    return null;
                }
                return new Property(null, RESULT, ValueType.COMPLEX, (Object)this.createComplexValue((EdmComplexType)returnType, result));
            }
        }
        return null;
    }

    private List<ComplexValue> createComplexCollection(EdmComplexType returnType, Object result) throws ODataApplicationException {
        ArrayList jpaQueryResult = new ArrayList();
        jpaQueryResult.addAll((Collection)result);
        try {
            return new JPAComplexResultConverter(this.sd, jpaQueryResult, returnType).getResult();
        }
        catch (URISyntaxException | SerializerException e) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, e);
        }
    }

    private ComplexValue createComplexValue(EdmComplexType returnType, Object result) throws ODataApplicationException {
        ArrayList<Object> jpaQueryResult = new ArrayList<Object>();
        jpaQueryResult.add(result);
        try {
            Object valueList = new JPAComplexResultConverter(this.sd, jpaQueryResult, returnType).getResult();
            return (ComplexValue)valueList.get(0);
        }
        catch (URISyntaxException | SerializerException e) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, e);
        }
    }

    private EntityCollection createEntityCollection(EdmEntityType returnType, Object result, UriHelper createUriHelper, JPAOperation jpaFunction) throws ODataApplicationException {
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (jpaFunction.getResultParameter().isCollection()) {
            resultList.addAll((Collection)result);
        } else {
            if (result == null) {
                return null;
            }
            resultList.add(result);
        }
        try {
            return new JPAEntityResultConverter(createUriHelper, this.sd, resultList, returnType).getResult();
        }
        catch (ODataJPAModelException | URISyntaxException | SerializerException e) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, e);
        }
    }

    protected void serializeResult(EdmType returnType, ODataResponse response, ContentType responseFormat, Annotatable result, ODataRequest request) throws ODataJPASerializerException, SerializerException {
        if (!(result == null || result instanceof EntityCollection && ((EntityCollection)result).getEntities().isEmpty())) {
            SerializerResult serializerResult = ((JPAOperationSerializer)this.serializer).serialize(result, returnType, request);
            this.createSuccessResponce(response, responseFormat, serializerResult);
        } else {
            response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
        }
    }
}

