/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataPage;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.exception.JPAIllicalAccessException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.modify.JPAConversionHelper;
import com.sap.olingo.jpa.processor.core.processor.JPAActionRequestProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPACUDRequestProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPACountRequestProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPAFunctionRequestProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPANavigationRequestProcessor;
import com.sap.olingo.jpa.processor.core.processor.JPAODataRequestContextImpl;
import com.sap.olingo.jpa.processor.core.processor.JPARequestProcessor;
import com.sap.olingo.jpa.processor.core.query.JPAJoinQuery;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;

public final class JPAProcessorFactory {
    private final JPAODataCRUDContextAccess sessionContext;
    private final JPASerializerFactory serializerFactory;
    private final OData odata;
    private final ServiceMetadata serviceMetadata;

    public JPAProcessorFactory(OData odata, ServiceMetadata serviceMetadata, JPAODataCRUDContextAccess context) {
        this.sessionContext = context;
        this.serializerFactory = new JPASerializerFactory(odata, serviceMetadata, context);
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    public JPACUDRequestProcessor createCUDRequestProcessor(UriInfo uriInfo, ContentType responseFormat, JPAODataRequestContextAccess context, Map<String, List<String>> header) throws ODataException {
        JPAODataRequestContextImpl requestContext = new JPAODataRequestContextImpl((UriInfoResource)uriInfo, this.serializerFactory.createCUDSerializer(responseFormat, uriInfo, Optional.ofNullable(header.get("OData-MaxVersion"))), context);
        return new JPACUDRequestProcessor(this.odata, this.serviceMetadata, this.sessionContext, requestContext, new JPAConversionHelper());
    }

    public JPACUDRequestProcessor createCUDRequestProcessor(UriInfo uriInfo, JPAODataRequestContextAccess context) throws ODataException {
        JPAODataRequestContextImpl requestContext = new JPAODataRequestContextImpl((UriInfoResource)uriInfo, context);
        return new JPACUDRequestProcessor(this.odata, this.serviceMetadata, this.sessionContext, requestContext, new JPAConversionHelper());
    }

    public JPAActionRequestProcessor createActionProcessor(UriInfo uriInfo, ContentType responseFormat, Map<String, List<String>> header, JPAODataRequestContextAccess context) throws ODataException {
        JPAODataRequestContextImpl requestContext = new JPAODataRequestContextImpl((UriInfoResource)uriInfo, responseFormat != null ? this.serializerFactory.createSerializer(responseFormat, uriInfo, Optional.ofNullable(header.get("OData-MaxVersion"))) : null, context);
        return new JPAActionRequestProcessor(this.odata, this.sessionContext, requestContext);
    }

    public JPARequestProcessor createProcessor(UriInfo uriInfo, ContentType responseFormat, Map<String, List<String>> header, JPAODataRequestContextAccess context) throws ODataException {
        JPAODataRequestContextImpl requestContext;
        List resourceParts = uriInfo.getUriResourceParts();
        UriResource lastItem = (UriResource)resourceParts.get(resourceParts.size() - 1);
        JPAODataPage page = this.getPage(header, uriInfo, context);
        try {
            requestContext = new JPAODataRequestContextImpl(page, this.serializerFactory.createSerializer(responseFormat, page.getUriInfo(), Optional.ofNullable(header.get("OData-MaxVersion"))), context);
        }
        catch (JPAIllicalAccessException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        switch (lastItem.getKind()) {
            case count: {
                return new JPACountRequestProcessor(this.odata, this.sessionContext, requestContext);
            }
            case function: {
                this.checkFunctionPathSupported(resourceParts);
                return new JPAFunctionRequestProcessor(this.odata, this.sessionContext, requestContext);
            }
            case complexProperty: 
            case primitiveProperty: 
            case navigationProperty: 
            case entitySet: 
            case value: {
                this.checkNavigationPathSupported(resourceParts);
                return new JPANavigationRequestProcessor(this.odata, this.serviceMetadata, this.sessionContext, requestContext);
            }
        }
        throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_RESOURCE_TYPE, HttpStatusCode.NOT_IMPLEMENTED, lastItem.getKind().toString());
    }

    private void checkFunctionPathSupported(List<UriResource> resourceParts) throws ODataApplicationException {
        if (resourceParts.size() > 2) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_FUNC_WITH_NAVI, HttpStatusCode.NOT_IMPLEMENTED);
        }
    }

    private void checkNavigationPathSupported(List<UriResource> resourceParts) throws ODataApplicationException {
        for (UriResource resourceItem : resourceParts) {
            if (resourceItem.getKind() == UriResourceKind.complexProperty || resourceItem.getKind() == UriResourceKind.primitiveProperty || resourceItem.getKind() == UriResourceKind.navigationProperty || resourceItem.getKind() == UriResourceKind.entitySet || resourceItem.getKind() == UriResourceKind.value) continue;
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.NOT_SUPPORTED_RESOURCE_TYPE, HttpStatusCode.NOT_IMPLEMENTED, resourceItem.getKind().toString());
        }
    }

    private JPAODataPage getPage(Map<String, List<String>> headers, UriInfo uriInfo, JPAODataRequestContextAccess requestContext) throws ODataException {
        JPAODataPage page = new JPAODataPage(uriInfo, 0, Integer.MAX_VALUE, null);
        if (this.serverDrivenPaging(uriInfo)) {
            String skiptoken = this.skipToken(uriInfo);
            if (skiptoken != null && !skiptoken.isEmpty()) {
                page = this.sessionContext.getPagingProvider().getNextPage(skiptoken);
                if (page == null) {
                    throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.QUERY_SERVER_DRIVEN_PAGING_GONE, HttpStatusCode.GONE, skiptoken);
                }
            } else {
                JPAJoinQuery countQuery = new JPAJoinQuery(this.odata, this.sessionContext, headers, (JPAODataRequestContextAccess)new JPAODataRequestContextImpl((UriInfoResource)uriInfo, requestContext));
                Integer preferedPagesize = this.getPreferedPagesize(headers);
                JPAODataPage firstPage = this.sessionContext.getPagingProvider().getFirstPage(uriInfo, preferedPagesize, countQuery, requestContext.getEntityManager());
                page = firstPage != null ? firstPage : page;
            }
        }
        return page;
    }

    private Integer getPreferedPagesize(Map<String, List<String>> headers) throws ODataJPAProcessorException {
        List<String> preferedHeaders = this.getHeader("Prefer", headers);
        if (preferedHeaders != null) {
            for (String header : preferedHeaders) {
                if (!header.startsWith("odata.maxpagesize")) continue;
                try {
                    return Integer.valueOf(header.split("=")[1]);
                }
                catch (NumberFormatException e) {
                    throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
                }
            }
        }
        return null;
    }

    private boolean serverDrivenPaging(UriInfo uriInfo) throws ODataJPAProcessorException {
        for (SystemQueryOption option : uriInfo.getSystemQueryOptions()) {
            if (option.getKind() != SystemQueryOptionKind.SKIPTOKEN || this.sessionContext.getPagingProvider() != null) continue;
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.QUERY_SERVER_DRIVEN_PAGING_NOT_IMPLEMENTED, HttpStatusCode.NOT_IMPLEMENTED);
        }
        List resourceParts = uriInfo.getUriResourceParts();
        return this.sessionContext.getPagingProvider() != null && ((UriResource)resourceParts.get(resourceParts.size() - 1)).getKind() != UriResourceKind.function;
    }

    private String skipToken(UriInfo uriInfo) {
        for (SystemQueryOption option : uriInfo.getSystemQueryOptions()) {
            if (option.getKind() != SystemQueryOptionKind.SKIPTOKEN) continue;
            return option.getText();
        }
        return null;
    }

    private List<String> getHeader(String name, Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            if (!header.getKey().equalsIgnoreCase(name)) continue;
            return header.getValue();
        }
        return Collections.emptyList();
    }
}

