/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.api.JPAODataGroupProvider;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.processor.JPAModifyUtil;
import com.sap.olingo.jpa.processor.core.processor.JPARequestEntity;
import com.sap.olingo.jpa.processor.core.processor.JPARequestLink;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class JPARequestEntityImpl
implements JPARequestEntity {
    private static final JPAModifyUtil util = new JPAModifyUtil();
    private final JPAEntityType et;
    private final Map<String, Object> jpaAttributes;
    private final Map<String, Object> jpaKeys;
    private final Map<JPAAssociationPath, List<JPARequestEntity>> jpaDeepEntities;
    private final Map<JPAAssociationPath, List<JPARequestLink>> jpaLinks;
    private final Map<String, List<String>> odataHeaders;
    private Optional<Object> beforeImage;
    private final JPAODataRequestContextAccess requestContext;

    JPARequestEntityImpl(JPAEntityType et, Map<String, Object> jpaAttributes, Map<JPAAssociationPath, List<JPARequestEntity>> jpaDeepEntities, Map<JPAAssociationPath, List<JPARequestLink>> jpaLinks, Map<String, Object> keys, Map<String, List<String>> headers, JPAODataRequestContextAccess requestContext) {
        this.et = et;
        this.jpaAttributes = jpaAttributes;
        this.jpaDeepEntities = jpaDeepEntities;
        this.jpaLinks = jpaLinks;
        this.jpaKeys = keys;
        this.odataHeaders = headers;
        this.requestContext = requestContext;
    }

    @Override
    public Map<String, List<String>> getAllHeader() {
        return this.odataHeaders;
    }

    @Override
    public Optional<Object> getBeforeImage() {
        return this.beforeImage;
    }

    @Override
    public Optional<JPAODataClaimProvider> getClaims() {
        return this.requestContext.getClaimsProvider();
    }

    @Override
    public Map<String, Object> getData() {
        return this.jpaAttributes;
    }

    @Override
    public JPAEntityType getEntityType() {
        return this.et;
    }

    @Override
    public Map<String, Object> getKeys() {
        return this.jpaKeys;
    }

    @Override
    public JPAModifyUtil getModifyUtil() {
        return util;
    }

    @Override
    public Map<JPAAssociationPath, List<JPARequestEntity>> getRelatedEntities() {
        return this.jpaDeepEntities;
    }

    @Override
    public Map<JPAAssociationPath, List<JPARequestLink>> getRelationLinks() {
        return this.jpaLinks;
    }

    void setBeforeImage(Optional<Object> beforeImage) {
        this.beforeImage = beforeImage;
    }

    @Override
    public List<String> getGroups() {
        Optional<JPAODataGroupProvider> provider = this.requestContext.getGroupsProvider();
        return provider.isPresent() ? provider.get().getGroups() : Collections.emptyList();
    }
}

