/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.processor;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAOnConditionItem;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.modify.JPAConversionHelper;
import com.sap.olingo.jpa.processor.core.processor.JPARequestLink;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;

public final class JPARequestLinkImpl
implements JPARequestLink {
    private final JPAAssociationPath path;
    private final String bindingLink;
    private final Map<String, Object> keys;
    private final Map<String, Object> values;
    private final JPAConversionHelper helper;

    JPARequestLinkImpl(JPAAssociationPath path, String bindingLink, JPAConversionHelper helper) {
        this.path = path;
        this.bindingLink = bindingLink;
        this.helper = helper;
        this.keys = new HashMap<String, Object>();
        this.values = new HashMap<String, Object>();
    }

    @Override
    public JPAEntityType getEntityType() {
        return (JPAEntityType)this.path.getTargetType();
    }

    @Override
    public Map<String, Object> getRelatedKeys() throws ODataJPAProcessorException {
        if (this.keys.size() == 0) {
            try {
                this.buildKeys();
            }
            catch (Exception e) {
                throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
            }
        }
        return this.keys;
    }

    @Override
    public Map<String, Object> getValues() throws ODataJPAProcessorException {
        if (this.values.size() == 0) {
            try {
                this.buildKeys();
            }
            catch (Exception e) {
                throw new ODataJPAProcessorException(e, HttpStatusCode.BAD_REQUEST);
            }
        }
        return this.values;
    }

    private void buildKeys() throws ODataJPAModelException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, EdmPrimitiveTypeException {
        OData odata = OData.newInstance();
        String[] entityTypeAndKey = this.bindingLink.split("[\\(\\)]");
        String[] keyElements = entityTypeAndKey[1].split("[,=]");
        if (keyElements.length > 1) {
            block0: for (int i = 0; i < keyElements.length; i += 2) {
                for (JPAOnConditionItem item : this.path.getJoinColumnsList()) {
                    if (item.getLeftPath().getLeaf().getExternalName().equals(keyElements[i])) {
                        this.keys.put(item.getLeftPath().getLeaf().getInternalName(), this.convertKeyValue(odata, keyElements[i + 1], item.getLeftPath()));
                        this.values.put(item.getRightPath().getLeaf().getInternalName(), this.convertKeyValue(odata, keyElements[i + 1], item.getRightPath()));
                        continue block0;
                    }
                    if (!item.getRightPath().getLeaf().getExternalName().equals(keyElements[i])) continue;
                    this.keys.put(item.getRightPath().getLeaf().getInternalName(), this.convertKeyValue(odata, keyElements[i + 1], item.getRightPath()));
                    this.values.put(item.getLeftPath().getLeaf().getInternalName(), this.convertKeyValue(odata, keyElements[i + 1], item.getLeftPath()));
                    continue block0;
                }
            }
        } else {
            List targetKeys = ((JPAEntityType)this.path.getTargetType()).getKey();
            String attributeName = ((JPAAttribute)targetKeys.get(0)).getInternalName();
            JPAOnConditionItem item = (JPAOnConditionItem)this.path.getJoinColumnsList().get(0);
            if (item.getRightPath().getLeaf().getInternalName().equals(attributeName)) {
                this.keys.put(item.getRightPath().getLeaf().getInternalName(), this.convertKeyValue(odata, keyElements[0], item.getRightPath()));
                this.values.put(item.getLeftPath().getLeaf().getInternalName(), this.convertKeyValue(odata, keyElements[0], item.getLeftPath()));
                return;
            }
            if (item.getLeftPath().getLeaf().getInternalName().equals(attributeName)) {
                this.keys.put(item.getLeftPath().getLeaf().getInternalName(), this.convertKeyValue(odata, keyElements[0], item.getLeftPath()));
                this.values.put(item.getRightPath().getLeaf().getInternalName(), this.convertKeyValue(odata, keyElements[0], item.getRightPath()));
                return;
            }
        }
    }

    private Object convertKeyValue(OData odata, String keyElementValue, JPAPath path) throws ODataJPAModelException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, EdmPrimitiveTypeException {
        EdmPrimitiveType edmType = odata.createPrimitiveTypeInstance(path.getLeaf().getEdmType());
        Class defaultType = edmType.getDefaultType();
        Constructor c = defaultType.getConstructor(String.class);
        Object value = c.newInstance(edmType.fromUriLiteral(keyElementValue));
        return this.helper.processAttributeConverter(value, path.getLeaf());
    }
}

