/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPACollectionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADescriptionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAParamaterFacet;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.metadata.core.edm.mapper.impl.JPATypeConvertor;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAFilterException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriParameter;

public final class ExpressionUtil {
    public static final int CONTAINY_ONLY_LANGU = 1;
    public static final int CONTAINS_LANGU_COUNTRY = 2;
    public static final String SELECT_ITEM_SEPERATOR = ",";

    private ExpressionUtil() {
    }

    public static Expression<Boolean> createEQExpression(OData odata, CriteriaBuilder cb, From<?, ?> root, JPAEntityType jpaEntity, UriParameter keyPredicate) throws ODataJPAFilterException, ODataJPAModelException {
        JPAPath path = jpaEntity.getPath(keyPredicate.getName());
        JPAAttribute attribute = path.getLeaf();
        return cb.equal(ExpressionUtil.convertToCriteriaPath(root, path.getPath()), ExpressionUtil.convertValueOnAttribute(odata, attribute, keyPredicate.getText()));
    }

    public static Path<?> convertToCriteriaPath(Map<String, From<?, ?>> joinTables, From<?, ?> root, List<JPAElement> jpaPath) {
        Path p = root;
        for (JPAElement jpaPathElement : jpaPath) {
            if (jpaPathElement instanceof JPADescriptionAttribute) {
                Join join = (Join)joinTables.get(jpaPathElement.getInternalName());
                p = join.get(((JPADescriptionAttribute)jpaPathElement).getDescriptionAttribute().getInternalName());
                continue;
            }
            if (jpaPathElement instanceof JPACollectionAttribute) {
                p = (Path)joinTables.get(jpaPathElement.getExternalName());
                continue;
            }
            p = p.get(jpaPathElement.getInternalName());
        }
        return p;
    }

    public static Path<?> convertToCriteriaPath(From<?, ?> root, List<JPAElement> jpaPath) {
        Path p = root;
        for (JPAElement jpaPathElement : jpaPath) {
            p = p.get(jpaPathElement.getInternalName());
        }
        return p;
    }

    public static Object convertValueOnAttribute(OData odata, JPAAttribute attribute, String value) throws ODataJPAFilterException {
        return ExpressionUtil.convertValueOnAttribute(odata, attribute, value, true);
    }

    public static <T> Object convertValueOnAttribute(OData odata, JPAAttribute attribute, String value, Boolean isUri) throws ODataJPAFilterException {
        try {
            CsdlProperty edmProperty = (CsdlProperty)attribute.getProperty();
            EdmPrimitiveTypeKind edmTypeKind = JPATypeConvertor.convertToEdmSimpleType((JPAAttribute)attribute);
            String targetValue = null;
            EdmPrimitiveType edmType = odata.createPrimitiveTypeInstance(edmTypeKind);
            targetValue = isUri != false ? edmType.fromUriLiteral(value) : value;
            if (attribute.getConverter() != null) {
                AttributeConverter dbConverter = attribute.getConverter();
                return dbConverter.convertToEntityAttribute(edmType.valueOfString(targetValue, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(true), attribute.getType()));
            }
            return edmType.valueOfString(targetValue, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(true), attribute.getType());
        }
        catch (ODataJPAModelException | EdmPrimitiveTypeException e) {
            throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    public static Object convertValueOnFacet(OData odata, JPAParamaterFacet returnType, String value) throws ODataJPAFilterException {
        try {
            EdmPrimitiveTypeKind edmTypeKind = EdmPrimitiveTypeKind.valueOfFQN((FullQualifiedName)returnType.getTypeFQN());
            EdmPrimitiveType edmType = odata.createPrimitiveTypeInstance(edmTypeKind);
            String targetValue = edmType.fromUriLiteral(value);
            return edmType.valueOfString(targetValue, Boolean.valueOf(true), returnType.getMaxLength(), returnType.getPrecision(), returnType.getScale(), Boolean.valueOf(true), returnType.getType());
        }
        catch (ODataJPAModelException | EdmPrimitiveTypeException e) {
            throw new ODataJPAFilterException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    public static Locale determineLocale(Map<String, List<String>> headers) {
        String languageHeader;
        List<String> languageHeaders = headers.get("accept-language");
        if (languageHeaders != null && (languageHeader = languageHeaders.get(0)) != null) {
            String[] localeList = languageHeader.split(SELECT_ITEM_SEPERATOR);
            String locale = localeList[0];
            String[] languCountry = locale.split("-");
            if (languCountry.length == 2) {
                return new Locale(languCountry[0], languCountry[1]);
            }
            if (languCountry.length == 1) {
                return new Locale(languCountry[0]);
            }
            return Locale.ENGLISH;
        }
        return Locale.ENGLISH;
    }
}

