/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPACollectionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADescriptionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.api.JPAODataPage;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterComplier;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterCrossComplier;
import com.sap.olingo.jpa.processor.core.filter.JPAOperationConverter;
import com.sap.olingo.jpa.processor.core.processor.JPAODataRequestContextImpl;
import com.sap.olingo.jpa.processor.core.query.ExpressionUtil;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractQuery;
import com.sap.olingo.jpa.processor.core.query.JPAExpandItem;
import com.sap.olingo.jpa.processor.core.query.JPAKeyBoundary;
import com.sap.olingo.jpa.processor.core.query.JPAKeyPair;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import com.sap.olingo.jpa.processor.core.query.JPANoSelectionException;
import com.sap.olingo.jpa.processor.core.query.JPAQuery;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;

public abstract class JPAAbstractJoinQuery
extends JPAAbstractQuery
implements JPAQuery {
    protected static final String ALIAS_SEPERATOR = ".";
    protected final UriInfoResource uriResource;
    protected final CriteriaQuery<Tuple> cq;
    protected Root<?> root;
    protected From<?, ?> target;
    protected final JPAODataCRUDContextAccess context;
    protected final JPAODataPage page;
    protected final List<JPANavigationProptertyInfo> navigationInfo;
    protected final JPANavigationProptertyInfo lastInfo;
    protected final JPAODataRequestContextAccess requestContext;

    public JPAAbstractJoinQuery(OData odata, JPAODataCRUDContextAccess sessionContext, JPAEntityType jpaEntityType, JPAODataRequestContextAccess requestContext, Map<String, List<String>> requestHeaders, List<JPANavigationProptertyInfo> navigationInfo) throws ODataException {
        this(odata, sessionContext, jpaEntityType, requestContext.getUriInfo(), requestContext, requestHeaders, navigationInfo);
    }

    protected JPAAbstractJoinQuery(OData odata, JPAODataCRUDContextAccess sessionContext, JPAEntityType jpaEntityType, UriInfoResource uriInfo, JPAODataRequestContextAccess requestContext, Map<String, List<String>> requestHeaders, List<JPANavigationProptertyInfo> navigationInfo) throws ODataException {
        super(odata, sessionContext.getEdmProvider().getServiceDocument(), jpaEntityType, requestContext);
        this.requestContext = requestContext;
        this.locale = ExpressionUtil.determineLocale(requestHeaders);
        this.uriResource = uriInfo;
        this.cq = this.cb.createTupleQuery();
        this.context = sessionContext;
        this.page = requestContext.getPage();
        this.navigationInfo = navigationInfo;
        this.lastInfo = this.determineLastInfo(navigationInfo);
    }

    @Override
    public AbstractQuery<?> getQuery() {
        return this.cq;
    }

    @Override
    public From<?, ?> getRoot() {
        return this.target;
    }

    protected void addTopSkip(TypedQuery<Tuple> tq) throws ODataApplicationException {
        SkipOption skipOption;
        TopOption topOption = this.uriResource.getTopOption();
        if (topOption != null || this.page != null) {
            int topNumber = topOption != null ? topOption.getValue() : this.page.getTop();
            int n = topNumber = topOption != null && this.page != null ? Math.min(topOption.getValue(), this.page.getTop()) : topNumber;
            if (topNumber >= 0) {
                tq.setMaxResults(topNumber);
            } else {
                throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_INVALID_VALUE, HttpStatusCode.BAD_REQUEST, Integer.toString(topNumber), "$top");
            }
        }
        if ((skipOption = this.uriResource.getSkipOption()) != null || this.page != null) {
            int skipNumber = skipOption != null ? skipOption.getValue() : this.page.getSkip();
            int n = skipNumber = skipOption != null && this.page != null ? Math.max(skipOption.getValue(), this.page.getSkip()) : skipNumber;
            if (skipNumber >= 0) {
                tq.setFirstResult(skipNumber);
            } else {
                throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_INVALID_VALUE, HttpStatusCode.BAD_REQUEST, Integer.toString(skipNumber), "$skip");
            }
        }
    }

    protected List<JPAPath> buildEntityPathList(JPAEntityType jpaEntity) throws ODataApplicationException {
        try {
            return jpaEntity.getPathList();
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    protected final void buildSelectionAddNavigationAndSelect(UriInfoResource uriResource, Set<JPAPath> jpaPathList, SelectOption select) throws ODataApplicationException, ODataJPAModelException {
        boolean targetIsCollection = this.determineTargetIsCollection(uriResource);
        String pathPrefix = Util.determineProptertyNavigationPrefix(uriResource.getUriResourceParts());
        if ("$VALUE".equals(pathPrefix)) {
            jpaPathList.addAll(this.buildPathValue(this.jpaEntity));
        } else if (select == null || select.getSelectItems().isEmpty() || ((SelectItem)select.getSelectItems().get(0)).isStar()) {
            if (pathPrefix == null || pathPrefix.isEmpty()) {
                this.copyNonCollectionProperties(jpaPathList, this.buildEntityPathList(this.jpaEntity));
            } else {
                this.expandPath(this.jpaEntity, jpaPathList, pathPrefix, targetIsCollection);
            }
        } else {
            this.convertSelectIntoPath(select, jpaPathList, targetIsCollection, pathPrefix);
        }
    }

    protected Set<JPAPath> buildSelectionPathList(UriInfoResource uriResource) throws ODataApplicationException {
        HashSet<JPAPath> jpaPathList = new HashSet<JPAPath>();
        SelectOption select = uriResource.getSelectOption();
        try {
            this.buildSelectionAddNavigationAndSelect(uriResource, jpaPathList, select);
            this.buildSelectionAddMimeType(this.jpaEntity, jpaPathList);
            this.buildSelectionAddKeys(this.jpaEntity, jpaPathList);
            this.buildSelectionAddExpandSelection(uriResource, jpaPathList);
            this.buildSelectionAddETag(this.jpaEntity, jpaPathList);
        }
        catch (ODataJPAModelException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), (Locale)ODataJPAModelException.getLocales().nextElement(), (Throwable)e);
        }
        return jpaPathList;
    }

    protected Map<String, From<?, ?>> createFromClause(List<JPAAssociationPath> orderByTarget, Collection<JPAPath> selectionPath, CriteriaQuery<?> query, JPANavigationProptertyInfo lastInfo) throws ODataApplicationException, JPANoSelectionException {
        HashMap joinTables = new HashMap();
        this.createFromClauseRoot(query, joinTables);
        this.target = this.root;
        this.createFromClauseNavigationJoins(joinTables);
        this.createFromClauseCollectionsJoins(joinTables);
        this.createFromClauseOrderBy(orderByTarget, joinTables);
        this.createFromClauseDescriptionFields(selectionPath, joinTables);
        this.generateCollectionAttributeJoin(joinTables, selectionPath, lastInfo);
        return joinTables;
    }

    protected final Expression<Boolean> createKeyWhere(List<JPANavigationProptertyInfo> info) throws ODataApplicationException {
        Expression<Boolean> whereCondition = null;
        for (JPANavigationProptertyInfo naviInfo : info) {
            if (naviInfo.getKeyPredicates() == null) continue;
            try {
                JPAEntityType et = naviInfo.getEntityType();
                From<?, ?> f = naviInfo.getFromClause();
                List<UriParameter> keyPredicates = naviInfo.getKeyPredicates();
                whereCondition = this.createWhereByKey(f, whereCondition, keyPredicates, et);
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        }
        return whereCondition;
    }

    protected Expression<Boolean> createProtectionWhere(Optional<JPAODataClaimProvider> claimsProvider) throws ODataJPAQueryException {
        Expression<Boolean> restriction = null;
        for (JPANavigationProptertyInfo navi : this.navigationInfo) {
            try {
                JPAEntityType et = navi.getEntityType();
                From<?, ?> from = navi.getFromClause();
                restriction = this.addWhereClause(restriction, this.createProtectionWhereForEntityType(claimsProvider, et, from));
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_ENTITY_TYPE_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        }
        return restriction;
    }

    protected List<Selection<?>> createSelectClause(Map<String, From<?, ?>> joinTables, Collection<JPAPath> requestedProperties, From<?, ?> target, List<String> groups) throws ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "createSelectClause");
        ArrayList selections = new ArrayList();
        for (JPAPath jpaPath : requestedProperties) {
            if (!jpaPath.isPartOfGroups(groups)) continue;
            Path<?> p = ExpressionUtil.convertToCriteriaPath(joinTables, target, jpaPath.getPath());
            p.alias(jpaPath.getAlias());
            selections.add((Selection<?>)p);
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return selections;
    }

    protected Expression<Boolean> createWhere(UriInfoResource uriInfo, List<JPANavigationProptertyInfo> navigationInfo) throws ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "createWhere");
        Expression<Boolean> whereCondition = null;
        try {
            whereCondition = this.createKeyWhere(navigationInfo);
        }
        catch (ODataApplicationException e) {
            this.debugger.stopRuntimeMeasurement(handle);
            throw e;
        }
        try {
            whereCondition = this.addWhereClause(whereCondition, navigationInfo.get(navigationInfo.size() - 1).getFilterCompiler().compile());
        }
        catch (ExpressionVisitException e) {
            this.debugger.stopRuntimeMeasurement(handle);
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_FILTER_ERROR, HttpStatusCode.BAD_REQUEST, (Throwable)e);
        }
        if (uriInfo.getSearchOption() != null && uriInfo.getSearchOption().getSearchExpression() != null) {
            whereCondition = this.addWhereClause(whereCondition, this.context.getDatabaseProcessor().createSearchWhereClause(this.cb, this.cq, this.target, this.jpaEntity, uriInfo.getSearchOption()));
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return whereCondition;
    }

    protected JPAAssociationPath determineAssoziation(UriResourcePartTyped naviStart, StringBuilder associationName) throws ODataApplicationException {
        try {
            JPAEntityType naviStartType = naviStart instanceof UriResourceEntitySet ? this.sd.getEntity(((UriResourceEntitySet)naviStart).getType()) : this.sd.getEntity((EdmType)((UriResourceNavigation)naviStart).getProperty().getType());
            return naviStartType.getAssociationPath(associationName.toString());
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    protected JPANavigationProptertyInfo determineLastInfo(List<JPANavigationProptertyInfo> naviInfo) {
        return naviInfo.isEmpty() ? null : naviInfo.get(naviInfo.size() - 1);
    }

    protected final boolean determineTargetIsCollection(UriInfoResource uriResource) {
        UriResource last = !uriResource.getUriResourceParts().isEmpty() ? (UriResource)uriResource.getUriResourceParts().get(uriResource.getUriResourceParts().size() - 1) : null;
        return last instanceof UriResourceProperty && ((UriResourceProperty)last).isCollection();
    }

    protected void expandPath(JPAEntityType jpaEntity, Collection<JPAPath> jpaPathList, String selectItem, boolean targetIsCollection) throws ODataJPAModelException, ODataJPAQueryException {
        JPAPath selectItemPath = jpaEntity.getPath(selectItem);
        if (selectItemPath == null) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_INVALID_SELECTION_PATH, HttpStatusCode.BAD_REQUEST);
        }
        if (selectItemPath.getLeaf().isComplex()) {
            List c = jpaEntity.searchChildPath(selectItemPath);
            if (targetIsCollection) {
                jpaPathList.addAll(c);
            } else {
                this.copyNonCollectionProperties(jpaPathList, c);
            }
        } else if (!selectItemPath.getLeaf().isCollection() || targetIsCollection) {
            jpaPathList.add(selectItemPath);
        }
    }

    protected List<JPAPath> extractDescriptionAttributes(Collection<JPAPath> jpaPathList) {
        ArrayList<JPAPath> result = new ArrayList<JPAPath>();
        for (JPAPath p : jpaPathList) {
            if (!(p.getLeaf() instanceof JPADescriptionAttribute)) continue;
            result.add(p);
        }
        return result;
    }

    protected void generateCollectionAttributeJoin(Map<String, From<?, ?>> joinTables, Collection<JPAPath> jpaPathList, JPANavigationProptertyInfo lastInfo) throws JPANoSelectionException, ODataJPAProcessorException {
        for (JPAPath path : jpaPathList) {
            JPAElement collection = this.findCollection(lastInfo, path);
            this.addCollection(joinTables, path, collection);
        }
    }

    @Override
    protected Locale getLocale() {
        return this.locale;
    }

    @Override
    JPAODataCRUDContextAccess getContext() {
        return this.context;
    }

    private void addCollection(Map<String, From<?, ?>> joinTables, JPAPath path, JPAElement collection) {
        if (collection != null && !joinTables.containsKey(collection.getExternalName())) {
            Join f = this.target;
            for (JPAElement element : path.getPath()) {
                f = f.join(element.getInternalName());
                if (!(element instanceof JPACollectionAttribute)) continue;
                break;
            }
            joinTables.put(collection.getExternalName(), (From<?, ?>)f);
        }
    }

    private List<JPAPath> buildPathValue(JPAEntityType jpaEntity) throws ODataApplicationException {
        ArrayList<JPAPath> jpaPathList = new ArrayList<JPAPath>();
        try {
            jpaPathList.add(jpaEntity.getStreamAttributePath());
            jpaPathList.addAll(jpaEntity.getKeyPath());
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
        }
        return jpaPathList;
    }

    private void buildSelectionAddExpandSelection(UriInfoResource uriResource, Collection<JPAPath> jpaPathList) throws ODataApplicationException {
        Map<JPAExpandItem, JPAAssociationPath> associationPathList = Util.determineAssoziations(this.sd, uriResource.getUriResourceParts(), uriResource.getExpandOption());
        if (!associationPathList.isEmpty()) {
            ArrayList<JPAPath> tmpPathList = new ArrayList<JPAPath>(jpaPathList);
            ArrayList<JPAPath> addPathList = new ArrayList<JPAPath>();
            Collections.sort(tmpPathList);
            for (Map.Entry<JPAExpandItem, JPAAssociationPath> item : associationPathList.entrySet()) {
                JPAAssociationPath associationPath = item.getValue();
                try {
                    for (JPAPath joinItem : associationPath.getLeftColumnsList()) {
                        int pathIndex = Collections.binarySearch(tmpPathList, joinItem);
                        int insertIndex = Collections.binarySearch(addPathList, joinItem);
                        if (pathIndex >= 0 || insertIndex >= 0) continue;
                        addPathList.add(Math.abs(insertIndex) - 1, joinItem);
                    }
                }
                catch (ODataJPAModelException e) {
                    throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
                }
            }
            jpaPathList.addAll(addPathList);
        }
    }

    private void buildSelectionAddETag(JPAEntityType jpaEntity, Collection<JPAPath> jpaPathList) throws ODataJPAModelException {
        if (jpaEntity.hasEtag()) {
            jpaPathList.add(jpaEntity.getEtagPath());
        }
    }

    private void buildSelectionAddKeys(JPAEntityType jpaEntity, Collection<JPAPath> jpaPathList) throws ODataJPAModelException {
        ArrayList jpaKeyList = new ArrayList(jpaEntity.getKey());
        for (JPAPath selectItemPath : jpaPathList) {
            for (int i = 0; i < jpaKeyList.size(); ++i) {
                JPAAttribute key = (JPAAttribute)jpaKeyList.get(i);
                if (!key.getExternalFQN().equals((Object)selectItemPath.getLeaf().getExternalFQN())) continue;
                jpaKeyList.remove(i);
            }
            if (!jpaKeyList.isEmpty()) continue;
            break;
        }
        for (JPAAttribute key : jpaKeyList) {
            jpaPathList.add(jpaEntity.getPath(key.getExternalName()));
        }
    }

    private void buildSelectionAddMimeType(JPAEntityType jpaEntity, Collection<JPAPath> jpaPathList) throws ODataJPAModelException {
        JPAPath mimeTypeAttribute;
        if (jpaEntity.hasStream() && (mimeTypeAttribute = jpaEntity.getContentTypeAttributePath()) != null) {
            jpaPathList.add(mimeTypeAttribute);
        }
    }

    private boolean checkCollectionIsPartOfGroup(String collectionPath) throws ODataJPAProcessorException {
        try {
            JPAPath path = this.jpaEntity.getPath(collectionPath);
            return path.isPartOfGroups(this.groups);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAProcessorException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private void convertSelectIntoPath(SelectOption select, Collection<JPAPath> jpaPathList, boolean targetIsCollection, String pathPrefix) throws ODataJPAModelException, ODataJPAQueryException {
        for (SelectItem sItem : select.getSelectItems()) {
            String pathItem = sItem.getResourcePath().getUriResourceParts().stream().map(path -> path.getSegmentValue()).collect(Collectors.joining("/"));
            this.expandPath(this.jpaEntity, jpaPathList, (String)(pathPrefix.isEmpty() ? pathItem : pathPrefix + "/" + pathItem), targetIsCollection);
        }
    }

    private void copyNonCollectionProperties(Collection<JPAPath> jpaPathList, List<JPAPath> c) {
        for (JPAPath p : c) {
            boolean skip = false;
            for (JPAElement pathElement : p.getPath()) {
                if (!(pathElement instanceof JPAAttribute) || !((JPAAttribute)pathElement).isCollection()) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            jpaPathList.add(p);
        }
    }

    private void createFromClauseCollectionsJoins(HashMap<String, From<?, ?>> joinTables) throws ODataJPAQueryException {
        try {
            if (this.lastInfo.getAssociationPath() != null && this.lastInfo.getAssociationPath().getLeaf() instanceof JPACollectionAttribute && !this.uriResource.getUriResourceParts().isEmpty() && ((UriResource)this.uriResource.getUriResourceParts().get(this.uriResource.getUriResourceParts().size() - 1)).getKind() == UriResourceKind.complexProperty) {
                Path p = this.target;
                JPAElement element = null;
                for (JPAElement pathElement : this.lastInfo.getAssociationPath().getPath()) {
                    p = p.get(pathElement.getInternalName());
                    element = pathElement;
                }
                joinTables.put(this.lastInfo.getAssociationPath().getAlias(), (From<?, ?>)p);
                JPAEntityType targetEt = (JPAEntityType)((JPAAssociationAttribute)element).getTargetEntity();
                JPAOperationConverter converter = new JPAOperationConverter(this.cb, this.context.getOperationConverter());
                JPAODataRequestContextImpl subContext = new JPAODataRequestContextImpl(this.uriResource, this.requestContext);
                this.lastInfo.setFilterCompiler(new JPAFilterCrossComplier(this.odata, this.sd, targetEt, converter, this, (From)p, this.lastInfo.getAssociationPath(), subContext));
            } else {
                JPAOperationConverter converter = new JPAOperationConverter(this.cb, this.context.getOperationConverter());
                JPAODataRequestContextImpl subContext = new JPAODataRequestContextImpl(this.uriResource, this.requestContext);
                this.lastInfo.setFilterCompiler(new JPAFilterCrossComplier(this.odata, this.sd, this.jpaEntity, converter, this, this.lastInfo.getAssociationPath(), subContext));
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_FILTER_ERROR, HttpStatusCode.BAD_REQUEST, (Throwable)e);
        }
        this.lastInfo.setFromClause(this.target);
    }

    private void createFromClauseDescriptionFields(Collection<JPAPath> selectionPath, HashMap<String, From<?, ?>> joinTables) throws ODataApplicationException {
        List<JPAPath> descriptionFields = this.extractDescriptionAttributes(selectionPath);
        for (JPANavigationProptertyInfo info : this.navigationInfo) {
            if (info.getFilterCompiler() == null) continue;
            this.generateDesciptionJoin(joinTables, this.determineAllDescriptionPath(info.getFromClause() == this.target ? descriptionFields : Collections.emptyList(), info.getFilterCompiler()), info.getFromClause());
        }
    }

    private void createFromClauseNavigationJoins(HashMap<String, From<?, ?>> joinTables) throws ODataJPAQueryException {
        for (int i = 0; i < this.navigationInfo.size() - 1; ++i) {
            JPANavigationProptertyInfo naviInfo = this.navigationInfo.get(i);
            EdmType castType = null;
            castType = naviInfo.getUriResiource() instanceof UriResourceNavigation ? ((UriResourceNavigation)naviInfo.getUriResiource()).getTypeFilterOnEntry() : ((UriResourceEntitySet)naviInfo.getUriResiource()).getTypeFilterOnEntry();
            if (castType != null) {
                this.target = (From)this.target.as(this.sd.getEntity(castType.getFullQualifiedName()).getTypeClass());
            }
            naviInfo.setFromClause(this.target);
            if (naviInfo.getUriInfo() != null && naviInfo.getUriInfo().getFilterOption() != null) {
                try {
                    JPAOperationConverter converter = new JPAOperationConverter(this.cb, this.context.getOperationConverter());
                    JPAODataRequestContextImpl subContext = new JPAODataRequestContextImpl(naviInfo.getUriInfo(), this.requestContext);
                    naviInfo.setFilterCompiler(new JPAFilterCrossComplier(this.odata, this.sd, naviInfo.getEntityType(), converter, this, naviInfo.getFromClause(), null, subContext));
                }
                catch (ODataJPAModelException e) {
                    throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_FILTER_ERROR, HttpStatusCode.BAD_REQUEST, (Throwable)e);
                }
            }
            this.target = this.createJoinFromPath(naviInfo.getAssociationPath().getAlias(), naviInfo.getAssociationPath().getPath(), this.target, JoinType.INNER);
            joinTables.put(naviInfo.getAssociationPath().getAlias(), this.target);
        }
    }

    private void createFromClauseOrderBy(List<JPAAssociationPath> orderByTarget, HashMap<String, From<?, ?>> joinTables) {
        for (JPAAssociationPath orderBy : orderByTarget) {
            Join join = this.target;
            for (JPAElement o : orderBy.getPath()) {
                join = join.join(o.getInternalName(), JoinType.LEFT);
            }
            joinTables.put(orderBy.getAlias(), (From<?, ?>)join);
        }
    }

    private void createFromClauseRoot(CriteriaQuery<?> query, HashMap<String, From<?, ?>> joinTables) throws ODataJPAQueryException {
        try {
            JPAEntityType sourceEt = this.navigationInfo.get(0).getEntityType();
            this.root = query.from(sourceEt.getTypeClass());
            joinTables.put(sourceEt.getExternalFQN().getFullQualifiedNameAsString(), (From<?, ?>)this.root);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private Set<JPAPath> determineAllDescriptionPath(List<JPAPath> descriptionFields, JPAFilterComplier filter) throws ODataApplicationException {
        HashSet<JPAPath> allPath = new HashSet<JPAPath>(descriptionFields);
        for (JPAPath path : filter.getMember()) {
            if (!(path.getLeaf() instanceof JPADescriptionAttribute)) continue;
            allPath.add(path);
        }
        return allPath;
    }

    private JPAElement findCollection(JPANavigationProptertyInfo lastInfo, JPAPath path) throws ODataJPAProcessorException, JPANoSelectionException {
        JPAElement collection = null;
        StringBuilder collectionPath = new StringBuilder();
        for (JPAElement element : path.getPath()) {
            collectionPath.append(element.getExternalName());
            if (element instanceof JPACollectionAttribute) {
                if (this.checkCollectionIsPartOfGroup(collectionPath.toString())) {
                    collection = element;
                    break;
                }
                if (lastInfo.getAssociationPath() == null || !(lastInfo.getAssociationPath().getLeaf() instanceof JPACollectionAttribute)) break;
                throw new JPANoSelectionException();
            }
            collectionPath.append("/");
        }
        return collection;
    }

    protected <Y extends Comparable<? super Y>> Expression<Boolean> createBoundary(List<JPANavigationProptertyInfo> info, Optional<JPAKeyBoundary> keyBoundary) throws ODataJPAQueryException {
        if (keyBoundary.isPresent()) {
            JPANavigationProptertyInfo naviInfo = info.get(keyBoundary.get().getNoHops() - 1);
            try {
                JPAEntityType et = naviInfo.getEntityType();
                From<?, ?> f = naviInfo.getFromClause();
                if (keyBoundary.get().getKeyBoundary().hasUpperBoundary()) {
                    return this.createBoundaryWithUpper(et, f, keyBoundary.get().getKeyBoundary());
                }
                return this.createBoundaryEquals(et, f, keyBoundary.get().getKeyBoundary());
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        }
        return null;
    }

    private <Y extends Comparable<? super Y>> Expression<Boolean> createBoundaryWithUpper(JPAEntityType et, From<?, ?> f, JPAKeyPair jpaKeyPair) throws ODataJPAModelException {
        List keyElements = et.getKey();
        Predicate lowerExpression = null;
        Predicate upperExpression = null;
        for (int primaryIndex = 0; primaryIndex < keyElements.size(); ++primaryIndex) {
            for (int secondaryIndex = primaryIndex; secondaryIndex < keyElements.size(); ++secondaryIndex) {
                JPAAttribute keyElement = (JPAAttribute)keyElements.get(secondaryIndex);
                Path<?> keyPath = ExpressionUtil.convertToCriteriaPath(f, et.getPath(keyElement.getExternalName()).getPath());
                Object lowerBoundary = jpaKeyPair.getMinElement(keyElement);
                Object upperBoundary = jpaKeyPair.getMaxElement(keyElement);
                if (secondaryIndex == primaryIndex) {
                    if (primaryIndex == 0) {
                        lowerExpression = this.cb.greaterThanOrEqualTo(keyPath, lowerBoundary);
                        upperExpression = this.cb.lessThanOrEqualTo(keyPath, upperBoundary);
                        continue;
                    }
                    lowerExpression = this.cb.or((Expression)lowerExpression, (Expression)this.cb.greaterThan(keyPath, lowerBoundary));
                    upperExpression = this.cb.or((Expression)upperExpression, (Expression)this.cb.lessThan(keyPath, upperBoundary));
                    continue;
                }
                lowerExpression = this.cb.and((Expression)lowerExpression, (Expression)this.cb.equal(keyPath, lowerBoundary));
                upperExpression = this.cb.and((Expression)upperExpression, (Expression)this.cb.equal(keyPath, upperBoundary));
            }
        }
        return this.cb.and(lowerExpression, upperExpression);
    }

    private <Y extends Comparable<? super Y>> Expression<Boolean> createBoundaryEquals(JPAEntityType et, From<?, ?> f, JPAKeyPair jpaKeyPair) throws ODataJPAModelException {
        Predicate whereCondition = null;
        for (JPAAttribute keyElement : et.getKey()) {
            Path<?> keyPath = ExpressionUtil.convertToCriteriaPath(f, et.getPath(keyElement.getExternalName()).getPath());
            Predicate eqFragment = this.cb.equal(keyPath, (Object)jpaKeyPair.getMin().get(keyElement));
            if (whereCondition == null) {
                whereCondition = eqFragment;
                continue;
            }
            whereCondition = this.cb.and((Expression)whereCondition, (Expression)eqFragment);
        }
        return whereCondition;
    }
}

