/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADescriptionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAProtectionInfo;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAClaimsPair;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.api.JPAODataGroupProvider;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAServiceDebugger;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.query.ExpressionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.debug.RuntimeMeasurement;
import org.apache.olingo.server.api.uri.UriParameter;

public abstract class JPAAbstractQuery {
    protected static final String SELECT_ITEM_SEPERATOR = ",";
    protected static final String SELECT_ALL = "*";
    protected final EntityManager em;
    protected final CriteriaBuilder cb;
    protected final JPAEntityType jpaEntity;
    protected final JPAServiceDocument sd;
    protected final JPAServiceDebugger debugger;
    protected final OData odata;
    protected Locale locale;
    protected final Optional<JPAODataClaimProvider> claimsProvider;
    protected final List<String> groups;

    public JPAAbstractQuery(OData odata, JPAServiceDocument sd, JPAEntityType jpaEntityType, EntityManager em, Optional<JPAODataClaimProvider> claimsProvider) {
        this.em = em;
        this.cb = em.getCriteriaBuilder();
        this.sd = sd;
        this.jpaEntity = jpaEntityType;
        this.debugger = new EmptyDebugger();
        this.odata = odata;
        this.claimsProvider = claimsProvider;
        this.groups = Collections.emptyList();
    }

    public JPAAbstractQuery(OData odata, JPAServiceDocument sd, JPAEntityType jpaEntityType, EntityManager em, JPAServiceDebugger debugger, Optional<JPAODataClaimProvider> claimsProvider) {
        this.em = em;
        this.cb = em.getCriteriaBuilder();
        this.sd = sd;
        this.jpaEntity = jpaEntityType;
        this.debugger = debugger;
        this.odata = odata;
        this.claimsProvider = claimsProvider;
        this.groups = Collections.emptyList();
    }

    public JPAAbstractQuery(OData odata, JPAServiceDocument sd, EdmEntityType edmEntityType, EntityManager em, Optional<JPAODataClaimProvider> claimsProvider) throws ODataApplicationException {
        this.em = em;
        this.cb = em.getCriteriaBuilder();
        this.sd = sd;
        try {
            this.jpaEntity = sd.getEntity((EdmType)edmEntityType);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
        }
        this.debugger = new EmptyDebugger();
        this.odata = odata;
        this.claimsProvider = claimsProvider;
        this.groups = Collections.emptyList();
    }

    public JPAAbstractQuery(OData odata, JPAServiceDocument sd, JPAEntityType jpaEntityType, JPAODataRequestContextAccess requestContext) {
        Optional<JPAODataGroupProvider> groupsProvider = requestContext.getGroupsProvider();
        this.em = requestContext.getEntityManager();
        this.cb = this.em.getCriteriaBuilder();
        this.sd = sd;
        this.jpaEntity = jpaEntityType;
        this.debugger = requestContext.getDebugger();
        this.odata = odata;
        this.claimsProvider = requestContext.getClaimsProvider();
        this.groups = groupsProvider.isPresent() ? groupsProvider.get().getGroups() : Collections.emptyList();
    }

    protected Expression<Boolean> createWhereByKey(From<?, ?> root, Expression<Boolean> whereCondition, List<UriParameter> keyPredicates, JPAEntityType et) throws ODataApplicationException {
        Predicate compundCondition = whereCondition;
        if (keyPredicates != null) {
            for (UriParameter keyPredicate : keyPredicates) {
                Expression<Boolean> equalCondition;
                try {
                    equalCondition = ExpressionUtil.createEQExpression(this.odata, this.cb, root, et, keyPredicate);
                }
                catch (ODataJPAModelException e) {
                    throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
                }
                if (compundCondition == null) {
                    compundCondition = equalCondition;
                    continue;
                }
                compundCondition = this.cb.and(compundCondition, equalCondition);
            }
        }
        return compundCondition;
    }

    public abstract From<?, ?> getRoot();

    public abstract AbstractQuery<?> getQuery();

    public JPAServiceDebugger getDebugger() {
        return this.debugger;
    }

    protected abstract Locale getLocale();

    protected void generateDesciptionJoin(HashMap<String, From<?, ?>> joinTables, Set<JPAPath> pathSet, From<?, ?> target) {
        for (JPAPath descriptionFieldPath : pathSet) {
            JPADescriptionAttribute desciptionField = (JPADescriptionAttribute)descriptionFieldPath.getLeaf();
            Join<?, ?> join = this.createJoinFromPath(descriptionFieldPath.getAlias(), descriptionFieldPath.getPath(), target, JoinType.LEFT);
            if (desciptionField.isLocationJoin()) {
                join.on(this.createOnCondition(join, desciptionField, this.getLocale().toString()));
            } else {
                join.on(this.createOnCondition(join, desciptionField, this.getLocale().getLanguage()));
            }
            joinTables.put(desciptionField.getInternalName(), (From<?, ?>)join);
        }
    }

    protected <T, S> Join<T, S> createJoinFromPath(String alias, List<JPAElement> pathList, From<T, S> root, JoinType finalJoinType) {
        Join join = null;
        for (int i = 0; i < pathList.size(); ++i) {
            JoinType jt = i == pathList.size() - 1 ? finalJoinType : JoinType.INNER;
            if (i == 0) {
                join = root.join(pathList.get(i).getInternalName(), jt);
                join.alias(alias);
                continue;
            }
            if (i >= pathList.size()) continue;
            join = join.join(pathList.get(i).getInternalName(), jt);
            join.alias(pathList.get(i).getExternalName());
        }
        return join;
    }

    private Expression<Boolean> createOnCondition(Join<?, ?> join, JPADescriptionAttribute desciptionField, String localValue) {
        Predicate result = this.cb.equal(this.determienLocalePath(join, desciptionField.getLocaleFieldName()), (Object)localValue);
        for (JPAPath value : desciptionField.getFixedValueAssignment().keySet()) {
            result = this.cb.and((Expression)result, (Expression)this.cb.equal(this.determienLocalePath(join, value), desciptionField.getFixedValueAssignment().get(value)));
        }
        return result;
    }

    private Expression<?> determienLocalePath(Join<?, ?> join, JPAPath jpaPath) {
        Path p = join;
        for (JPAElement pathElement : jpaPath.getPath()) {
            p = p.get(pathElement.getInternalName());
        }
        return p;
    }

    abstract JPAODataCRUDContextAccess getContext();

    protected Expression<Boolean> addWhereClause(Expression<Boolean> whereCondition, Expression<Boolean> additioanlExpression) {
        if (additioanlExpression != null) {
            whereCondition = whereCondition == null ? additioanlExpression : this.cb.and(whereCondition, additioanlExpression);
        }
        return whereCondition;
    }

    protected Expression<Boolean> orWhereClause(Expression<Boolean> whereCondition, Expression<Boolean> additioanlExpression) {
        if (additioanlExpression != null) {
            whereCondition = whereCondition == null ? additioanlExpression : this.cb.or(whereCondition, additioanlExpression);
        }
        return whereCondition;
    }

    private <Y extends Comparable<? super Y>> Predicate createBetween(JPAClaimsPair<?> value, Path<?> p) {
        return this.cb.between(p, (Comparable)value.min, (Comparable)value.max);
    }

    private Expression<Boolean> createProtectionWhereForAttribute(List<JPAClaimsPair<?>> values, Path<?> p, boolean wildcardsSupported) throws ODataJPAQueryException {
        Expression<Boolean> attriRestriction = null;
        for (JPAClaimsPair<?> value : values) {
            if (value.hasUpperBoundary) {
                if (wildcardsSupported && ((String)value.min).matches(".*[\\*|\\%|\\+|\\_].*")) {
                    throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.WILDCARD_UPPER_NOT_SUPPORTED, HttpStatusCode.INTERNAL_SERVER_ERROR);
                }
                attriRestriction = this.orWhereClause(attriRestriction, (Expression<Boolean>)this.createBetween(value, p));
                continue;
            }
            if (wildcardsSupported && ((String)value.min).matches(".*[\\*|\\%|\\+|\\_].*")) {
                attriRestriction = this.orWhereClause(attriRestriction, (Expression<Boolean>)this.cb.like(p, ((String)value.min).replace('*', '%').replace('+', '_')));
                continue;
            }
            attriRestriction = this.orWhereClause(attriRestriction, (Expression<Boolean>)this.cb.equal(p, value.min));
        }
        return attriRestriction;
    }

    protected Expression<Boolean> createProtectionWhereForEntityType(Optional<JPAODataClaimProvider> claimsProvider, JPAEntityType et, From<?, ?> from) throws ODataJPAQueryException {
        try {
            Expression<Boolean> restriction = null;
            HashMap dummyJoinTables = new HashMap(1);
            for (JPAProtectionInfo protection : et.getProtections()) {
                List<JPAClaimsPair<?>> values = claimsProvider.get().get(protection.getClaimName());
                if (values.isEmpty()) {
                    throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.MISSING_CLAIM, HttpStatusCode.FORBIDDEN);
                }
                Path<?> p = ExpressionUtil.convertToCriteriaPath(dummyJoinTables, from, protection.getPath().getPath());
                restriction = this.addWhereClause(restriction, this.createProtectionWhereForAttribute(values, p, protection.supportsWildcards()));
            }
            return restriction;
        }
        catch (NoSuchElementException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.MISSING_CLAIMS_PROVIDER, HttpStatusCode.FORBIDDEN);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_ENTITY_TYPE_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private class EmptyDebugger
    implements JPAServiceDebugger {
        private EmptyDebugger() {
        }

        @Override
        public int startRuntimeMeasurement(Object instance, String methodName) {
            return 0;
        }

        @Override
        public void stopRuntimeMeasurement(int handle) {
        }

        @Override
        public Collection<RuntimeMeasurement> getRuntimeInformation() {
            return new ArrayList<RuntimeMeasurement>();
        }
    }
}

