/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterElementComplier;
import com.sap.olingo.jpa.processor.core.filter.JPAOperationConverter;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractQuery;
import com.sap.olingo.jpa.processor.core.query.JPANavigationQuery;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Subquery;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceLambdaAll;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.queryoption.expression.VisitableExpression;

public final class JPACollectionFilterQuery
extends JPANavigationQuery {
    public JPACollectionFilterQuery(OData odata, JPAServiceDocument sd, EntityManager em, JPAAbstractQuery parent, List<UriResource> uriResourceParts, VisitableExpression expression, From<?, ?> from, List<String> groups) throws ODataApplicationException {
        this(odata, sd, em, parent, JPACollectionFilterQuery.determineAssoziation(parent.jpaEntity, uriResourceParts), expression, from, groups);
    }

    public JPACollectionFilterQuery(OData odata, JPAServiceDocument sd, EntityManager em, JPAAbstractQuery parent, JPAAssociationPath associationPath, VisitableExpression expression, From<?, ?> from, List<String> groups) throws ODataApplicationException {
        super(odata, sd, JPACollectionFilterQuery.determineEntityType(parent, associationPath), em, parent, from, associationPath);
        this.subQuery = parent.getQuery().subquery(this.jpaEntity.getKeyType());
        this.filterComplier = new JPAFilterElementComplier(odata, sd, em, this.jpaEntity, new JPAOperationConverter(this.cb, this.getContext().getOperationConverter()), null, this, expression, this.association, groups);
        this.aggregationType = this.getAggregationType(this.filterComplier.getExpressionMember());
        this.createRoots(this.association);
    }

    private static JPAEntityType determineEntityType(JPAAbstractQuery parent, JPAAssociationPath associationPath) {
        if (associationPath.getLeaf().isComplex()) {
            return associationPath.getJoinTable().getEntityType();
        }
        return parent.jpaEntity;
    }

    private static JPAAssociationPath determineAssoziation(JPAEntityType jpaEntity, List<UriResource> uriResourceParts) throws ODataJPAQueryException {
        StringBuilder pathName = new StringBuilder();
        int i = 0;
        while (!(uriResourceParts.get(i) == null || uriResourceParts.get(i) instanceof UriResourceLambdaAny || uriResourceParts.get(i) instanceof UriResourceLambdaAll || uriResourceParts.get(i) instanceof UriResourceCount)) {
            pathName.append(uriResourceParts.get(i).toString());
            pathName.append("/");
            ++i;
        }
        pathName.deleteCharAt(pathName.lastIndexOf("/"));
        try {
            return jpaEntity.getCollectionAttribute(pathName.toString()).asAssociation();
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public <T> Subquery<T> getSubQueryExists(Subquery<?> childQuery) throws ODataApplicationException {
        if (this.queryJoinTable != null) {
            if (this.aggregationType != null) {
                try {
                    List right = this.association.getJoinTable().getInversJoinColumns();
                    this.createSelectClause(this.subQuery, this.queryJoinTable, right);
                    Expression<Boolean> whereCondition = this.createWhereByAssociation(this.from, this.queryJoinTable, this.jpaEntity);
                    this.subQuery.where(this.applyAdditionalFilter(whereCondition));
                    this.handleAggregation(this.subQuery, this.queryJoinTable, right);
                }
                catch (ODataJPAModelException e) {
                    throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
                }
            } else {
                this.createSubQueryJoinTable();
            }
        }
        return this.subQuery;
    }

    @Override
    public From<?, ?> getRoot() {
        assert (this.queryRoot != null);
        return this.queryRoot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void createRoots(JPAAssociationPath association) throws ODataJPAQueryException {
        if (association.getJoinTable() == null) throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_NOT_IMPLEMENTED, HttpStatusCode.NOT_IMPLEMENTED, association.getAlias());
        if (association.getJoinTable().getEntityType() == null) throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_NOT_IMPLEMENTED, HttpStatusCode.NOT_IMPLEMENTED, association.getAlias());
        if (this.aggregationType != null) {
            From p = this.queryJoinTable = this.subQuery.from(this.from.getJavaType());
            for (int i = 0; i < association.getPath().size() - 1; ++i) {
                p = p.join(((JPAElement)association.getPath().get(i)).getInternalName());
            }
            this.queryRoot = p.join(association.getLeaf().getInternalName(), JoinType.LEFT);
            return;
        } else {
            this.queryRoot = this.queryJoinTable = this.subQuery.from(association.getJoinTable().getEntityType().getTypeClass());
        }
    }

    @Override
    protected void createSubQueryJoinTable() throws ODataApplicationException {
        try {
            List left = this.association.getJoinTable().getJoinColumns();
            this.createSelectClause(this.subQuery, this.queryRoot, left);
            Expression<Boolean> whereCondition = this.createWhereByAssociation(this.from, this.queryJoinTable, left);
            this.subQuery.where(this.applyAdditionalFilter(whereCondition));
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }
}

