/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.query.ExpressionUtil;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractJoinQuery;
import com.sap.olingo.jpa.processor.core.query.JPACollectionItemInfo;
import com.sap.olingo.jpa.processor.core.query.JPACollectionQueryResult;
import com.sap.olingo.jpa.processor.core.query.JPAKeyBoundary;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import com.sap.olingo.jpa.processor.core.query.JPANoSelectionException;
import com.sap.olingo.jpa.processor.core.query.JPAOrderByBuilder;
import com.sap.olingo.jpa.processor.core.query.SelectOptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Selection;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;

public class JPACollectionJoinQuery
extends JPAAbstractJoinQuery {
    private final JPAAssociationPath assoziation;
    private final Optional<JPAKeyBoundary> keyBoundary;

    public JPACollectionJoinQuery(OData odata, JPAODataCRUDContextAccess context, EntityManager em, JPACollectionItemInfo item, Map<String, List<String>> requestHeaders, JPAODataRequestContextAccess requestContext, Optional<JPAKeyBoundary> keyBoundary) throws ODataException {
        super(odata, context, item.getEntityType(), requestContext, requestHeaders, new ArrayList<JPANavigationProptertyInfo>(item.getHops().subList(0, item.getHops().size() - 1)));
        this.assoziation = item.getExpandAssociation();
        this.keyBoundary = keyBoundary;
    }

    @Override
    public JPACollectionQueryResult execute() throws ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "executeStandradQuery");
        try {
            TypedQuery<Tuple> tupleQuery = this.createTupleQuery();
            int resultHandle = this.debugger.startRuntimeMeasurement(tupleQuery, "getResultList");
            List intermediateResult = tupleQuery.getResultList();
            this.debugger.stopRuntimeMeasurement(resultHandle);
            Map<String, List<Tuple>> result = this.convertResult(intermediateResult, this.assoziation, 0L, Long.MAX_VALUE);
            try {
                HashSet<JPAPath> requestedSelection = new HashSet<JPAPath>();
                this.buildSelectionAddNavigationAndSelect(this.uriResource, requestedSelection, this.uriResource.getSelectOption());
                this.debugger.stopRuntimeMeasurement(handle);
                return new JPACollectionQueryResult(result, new HashMap<String, Long>(1), this.jpaEntity, this.assoziation, requestedSelection);
            }
            catch (ODataJPAModelException e) {
                throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), (Locale)ODataJPAModelException.getLocales().nextElement(), (Throwable)e);
            }
        }
        catch (JPANoSelectionException e) {
            return new JPACollectionQueryResult(this.jpaEntity, this.assoziation, Collections.emptyList());
        }
    }

    @Override
    protected Set<JPAPath> buildSelectionPathList(UriInfoResource uriResource) throws ODataApplicationException {
        HashSet<JPAPath> jpaPathList = new HashSet<JPAPath>();
        String pathPrefix = "";
        SelectOption select = uriResource.getSelectOption();
        try {
            if (SelectOptionUtil.selectAll(select)) {
                this.expandPath(this.jpaEntity, jpaPathList, (String)("".isEmpty() ? this.assoziation.getAlias() : "/" + this.assoziation.getAlias()), true);
            } else {
                for (SelectItem sItem : select.getSelectItems()) {
                    JPAPath selectItemPath = this.selectItemAsPath("", sItem);
                    if (this.pathContainsCollection(selectItemPath)) {
                        if (selectItemPath.getLeaf().isComplex()) {
                            JPAAttribute attribute = selectItemPath.getLeaf();
                            this.expandPath(this.jpaEntity, jpaPathList, (String)("".isEmpty() ? attribute.getExternalName() : "/" + attribute.getExternalName()), true);
                            continue;
                        }
                        jpaPathList.add(selectItemPath);
                        continue;
                    }
                    if (!selectItemPath.getLeaf().isComplex()) continue;
                    this.expandPath(this.jpaEntity, jpaPathList, (String)("".isEmpty() ? this.assoziation.getAlias() : "/" + this.assoziation.getAlias()), true);
                }
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_INVALID_SELECTION_PATH, HttpStatusCode.BAD_REQUEST);
        }
        return jpaPathList;
    }

    private JPAPath selectItemAsPath(String pathPrefix, SelectItem sItem) throws ODataJPAModelException, ODataJPAQueryException {
        Object pathItem = sItem.getResourcePath().getUriResourceParts().stream().map(path -> path.getSegmentValue()).collect(Collectors.joining("/"));
        pathItem = pathPrefix == null || pathPrefix.isEmpty() ? pathItem : pathPrefix + "/" + (String)pathItem;
        JPAPath selectItemPath = this.jpaEntity.getPath((String)pathItem);
        if (selectItemPath == null) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_INVALID_SELECTION_PATH, HttpStatusCode.BAD_REQUEST);
        }
        return selectItemPath;
    }

    @Override
    protected void expandPath(JPAEntityType jpaEntity, Collection<JPAPath> jpaPathList, String selectItem, boolean targetIsCollection) throws ODataJPAModelException, ODataJPAQueryException {
        JPAPath selectItemPath = jpaEntity.getPath(selectItem);
        if (selectItemPath == null) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_INVALID_SELECTION_PATH, HttpStatusCode.BAD_REQUEST);
        }
        if (selectItemPath.getLeaf().isComplex()) {
            List p = jpaEntity.searchChildPath(selectItemPath);
            jpaPathList.addAll(p);
        } else {
            jpaPathList.add(selectItemPath);
        }
    }

    @Override
    protected List<Selection<?>> createSelectClause(Map<String, From<?, ?>> joinTables, Collection<JPAPath> jpaPathList, From<?, ?> target, List<String> groups) throws ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "createSelectClause");
        ArrayList selections = new ArrayList();
        this.createAdditionSelctionForJoinTable(selections);
        for (JPAPath jpaPath : jpaPathList) {
            if (!jpaPath.isPartOfGroups(groups)) continue;
            Path<?> p = ExpressionUtil.convertToCriteriaPath(joinTables, target, jpaPath.getPath());
            p.alias(jpaPath.getAlias());
            selections.add((Selection<?>)p);
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return selections;
    }

    Map<String, List<Tuple>> convertResult(List<Tuple> intermediateResult, JPAAssociationPath associationPath, long skip, long top) throws ODataApplicationException {
        String joinKey = "";
        long skiped = 0L;
        long taken = 0L;
        ArrayList<Tuple> subResult = null;
        HashMap<String, List<Tuple>> convertedResult = new HashMap<String, List<Tuple>>();
        for (Tuple row : intermediateResult) {
            String actuallKey;
            try {
                actuallKey = this.buildConcatenatedKey(row, associationPath);
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
            }
            if (!actuallKey.equals(joinKey)) {
                subResult = new ArrayList<Tuple>();
                convertedResult.put(actuallKey, subResult);
                joinKey = actuallKey;
                taken = 0L;
                skiped = 0L;
            }
            if (skiped >= skip && taken < top) {
                ++taken;
                subResult.add(row);
                continue;
            }
            ++skiped;
        }
        return convertedResult;
    }

    private String buildConcatenatedKey(Tuple row, JPAAssociationPath associationPath) throws ODataJPAModelException {
        if (associationPath.getJoinTable() == null) {
            List joinColumns = associationPath.getRightColumnsList();
            return joinColumns.stream().map(c -> row.get(c.getAlias()).toString()).collect(Collectors.joining("/"));
        }
        List joinColumns = associationPath.getLeftColumnsList();
        return joinColumns.stream().map(c -> row.get(this.assoziation.getAlias() + "." + c.getAlias()).toString()).collect(Collectors.joining("/"));
    }

    private List<Order> createOrderByJoinCondition(JPAAssociationPath associationPath) throws ODataApplicationException {
        ArrayList<Order> orders = new ArrayList<Order>();
        try {
            List joinColumns = associationPath.getJoinTable() == null ? associationPath.getRightColumnsList() : associationPath.getLeftColumnsList();
            Path from = associationPath.getJoinTable() == null ? this.target : this.determineParentFrom();
            for (JPAPath j : joinColumns) {
                Path jpaProperty = from;
                for (JPAElement pathElement : j.getPath()) {
                    jpaProperty = jpaProperty.get(pathElement.getInternalName());
                }
                orders.add(this.cb.asc(jpaProperty));
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
        }
        return orders;
    }

    private TypedQuery<Tuple> createTupleQuery() throws ODataApplicationException, JPANoSelectionException {
        int handle = this.debugger.startRuntimeMeasurement(this, "createTupleQuery");
        Set<JPAPath> selectionPath = this.buildSelectionPathList(this.uriResource);
        Map<String, From<?, ?>> joinTables = this.createFromClause(new ArrayList<JPAAssociationPath>(1), selectionPath, this.cq, this.lastInfo);
        this.cq.multiselect(this.createSelectClause(joinTables, selectionPath, this.target, this.groups));
        this.cq.distinct(true);
        Expression<Boolean> whereClause = this.createWhere();
        if (whereClause != null) {
            this.cq.where(whereClause);
        }
        List<Order> orderBy = this.createOrderByJoinCondition(this.assoziation);
        orderBy.addAll(new JPAOrderByBuilder(this.jpaEntity, this.target, this.cb, this.groups).createOrderByList(joinTables));
        this.cq.orderBy(orderBy);
        TypedQuery query = this.em.createQuery(this.cq);
        this.debugger.stopRuntimeMeasurement(handle);
        return query;
    }

    private Expression<Boolean> createWhere() throws ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "createWhere");
        Expression<Boolean> whereCondition = null;
        try {
            whereCondition = this.createKeyWhere(this.navigationInfo);
            whereCondition = this.addWhereClause(whereCondition, this.createBoundary(this.navigationInfo, this.keyBoundary));
        }
        catch (ODataApplicationException e) {
            this.debugger.stopRuntimeMeasurement(handle);
            throw e;
        }
        for (JPANavigationProptertyInfo info : this.navigationInfo) {
            if (info.getFilterCompiler() == null) continue;
            try {
                whereCondition = this.addWhereClause(whereCondition, info.getFilterCompiler().compile());
            }
            catch (ExpressionVisitException e) {
                this.debugger.stopRuntimeMeasurement(handle);
                throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_FILTER_ERROR, HttpStatusCode.BAD_REQUEST, (Throwable)e);
            }
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return whereCondition;
    }

    private From<?, ?> determineParentFrom() throws ODataJPAQueryException {
        for (JPANavigationProptertyInfo item : this.navigationInfo) {
            if (item.getAssociationPath() != this.assoziation) continue;
            return item.getFromClause();
        }
        throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_FILTER_ERROR, HttpStatusCode.BAD_REQUEST);
    }

    private void createAdditionSelctionForJoinTable(List<Selection<?>> selections) throws ODataJPAQueryException {
        From<?, ?> parent = this.determineParentFrom();
        try {
            for (JPAPath p : this.assoziation.getLeftColumnsList()) {
                Path<?> selection = ExpressionUtil.convertToCriteriaPath(parent, p.getPath());
                selection.alias(this.assoziation.getAlias() + "." + p.getAlias());
                selections.add((Selection<?>)selection);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean pathContainsCollection(JPAPath p) {
        for (JPAElement pathElement : p.getPath()) {
            if (!(pathElement instanceof JPAAttribute) || !((JPAAttribute)pathElement).isCollection()) continue;
            return true;
        }
        return false;
    }
}

