/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.processor.core.converter.JPACollectionResult;
import com.sap.olingo.jpa.processor.core.converter.JPAExpandResult;
import com.sap.olingo.jpa.processor.core.converter.JPATupleChildConverter;
import com.sap.olingo.jpa.processor.core.query.JPAConvertableResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Tuple;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.server.api.ODataApplicationException;

public class JPACollectionQueryResult
implements JPACollectionResult,
JPAConvertableResult {
    private static final Map<String, List<Tuple>> EMPTY_RESULT = new HashMap<String, List<Tuple>>(1);
    private final Map<JPAAssociationPath, JPAExpandResult> childrenResult = new HashMap<JPAAssociationPath, JPAExpandResult>(1);
    private final Map<String, List<Tuple>> jpaResult;
    private Map<String, List<Object>> collectionResult;
    private final Map<String, Long> counts;
    private final JPAEntityType jpaEntityType;
    private final JPAAssociationPath assoziation;
    private final Collection<JPAPath> requestedSelection;

    private static Map<String, List<Tuple>> putEmptyResult() {
        EMPTY_RESULT.put("root", Collections.emptyList());
        return EMPTY_RESULT;
    }

    public JPACollectionQueryResult(JPAEntityType jpaEntityType, JPAAssociationPath assoziation, Collection<JPAPath> selectionPath) {
        this(JPACollectionQueryResult.putEmptyResult(), Collections.emptyMap(), jpaEntityType, assoziation, selectionPath);
    }

    public JPACollectionQueryResult(Map<String, List<Tuple>> result, Map<String, Long> counts, JPAEntityType jpaEntityType, JPAAssociationPath assoziation, Collection<JPAPath> selectionPath) {
        this.jpaResult = result;
        this.counts = counts;
        this.jpaEntityType = jpaEntityType;
        this.assoziation = assoziation;
        this.requestedSelection = selectionPath;
    }

    @Override
    public Map<String, EntityCollection> asEntityCollection(JPATupleChildConverter converter) throws ODataApplicationException {
        this.collectionResult = converter.getCollectionResult(this, this.requestedSelection);
        HashMap<String, EntityCollection> result = new HashMap<String, EntityCollection>(1);
        EntityCollection collection = new EntityCollection();
        Entity odataEntity = new Entity();
        JPAAttribute leaf = (JPAAttribute)this.assoziation.getPath().get(this.assoziation.getPath().size() - 1);
        odataEntity.getProperties().add(new Property(null, leaf.getExternalName(), leaf.isComplex() ? ValueType.COLLECTION_COMPLEX : ValueType.COLLECTION_PRIMITIVE, this.collectionResult.get("root") != null ? this.collectionResult.get("root") : Collections.emptyList()));
        collection.getEntities().add(odataEntity);
        result.put("root", collection);
        return result;
    }

    @Override
    public void convert(JPATupleChildConverter converter) throws ODataApplicationException {
        this.collectionResult = converter.getCollectionResult(this, this.requestedSelection);
    }

    @Override
    public JPAAssociationPath getAssoziation() {
        return this.assoziation;
    }

    @Override
    public JPAExpandResult getChild(JPAAssociationPath associationPath) {
        return null;
    }

    @Override
    public Map<JPAAssociationPath, JPAExpandResult> getChildren() {
        return this.childrenResult;
    }

    @Override
    public Long getCount(String key) {
        return this.counts != null ? this.counts.get(key) : null;
    }

    @Override
    public EntityCollection getEntityCollection(String key) {
        return new EntityCollection();
    }

    @Override
    public JPAEntityType getEntityType() {
        return this.jpaEntityType;
    }

    public List<Object> getPropertyCollection(String key) {
        return this.collectionResult.containsKey(key) ? this.collectionResult.get(key) : Collections.emptyList();
    }

    @Override
    public List<Tuple> getResult(String key) {
        return this.jpaResult.get(key);
    }

    @Override
    public Map<String, List<Tuple>> getResults() {
        return this.jpaResult;
    }

    @Override
    public boolean hasCount() {
        return this.counts != null;
    }

    @Override
    public void putChildren(Map<JPAAssociationPath, JPAExpandResult> childResults) throws ODataApplicationException {
    }

    static {
        JPACollectionQueryResult.putEmptyResult();
    }
}

