/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPACollectionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataGroupProvider;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.query.JPACollectionExpandWrapper;
import com.sap.olingo.jpa.processor.core.query.JPACollectionItemInfo;
import com.sap.olingo.jpa.processor.core.query.JPAExpandItem;
import com.sap.olingo.jpa.processor.core.query.JPAExpandItemInfo;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import com.sap.olingo.jpa.processor.core.query.SelectOptionUtil;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;

public final class JPAExpandItemInfoFactory {
    private static final int ST_INDEX = 0;
    private static final int ET_INDEX = 1;
    private static final int PROPERTY_INDEX = 2;

    public List<JPAExpandItemInfo> buildExpandItemInfo(JPAServiceDocument sd, UriInfoResource uriResourceInfo, List<JPANavigationProptertyInfo> grandParentHops) throws ODataApplicationException {
        ArrayList<JPAExpandItemInfo> itemList = new ArrayList<JPAExpandItemInfo>();
        List startResourceList = uriResourceInfo.getUriResourceParts();
        ExpandOption expandOption = uriResourceInfo.getExpandOption();
        if (startResourceList != null && expandOption != null) {
            List<JPANavigationProptertyInfo> parentHops = grandParentHops;
            Map<JPAExpandItem, JPAAssociationPath> expandPath = Util.determineAssoziations(sd, startResourceList, expandOption);
            for (Map.Entry<JPAExpandItem, JPAAssociationPath> item : expandPath.entrySet()) {
                itemList.add(new JPAExpandItemInfo(sd, item.getKey(), item.getValue(), parentHops));
            }
        }
        return itemList;
    }

    public List<JPACollectionItemInfo> buildCollectionItemInfo(JPAServiceDocument sd, UriInfoResource uriResourceInfo, List<JPANavigationProptertyInfo> grandParentHops, Optional<JPAODataGroupProvider> groups) throws ODataApplicationException {
        ArrayList<JPACollectionItemInfo> itemList = new ArrayList<JPACollectionItemInfo>();
        List startResourceList = uriResourceInfo.getUriResourceParts();
        SelectOption select = uriResourceInfo.getSelectOption();
        JPAEntityType et = uriResourceInfo instanceof JPAExpandItem ? ((JPAExpandItem)uriResourceInfo).getEntityType() : null;
        Object[] pathInfo = this.determineNavigationElements(sd, startResourceList, et);
        try {
            if (pathInfo[2] != null) {
                if (((JPAPath)pathInfo[2]).getLeaf().isCollection()) {
                    // empty if block
                }
            } else if (SelectOptionUtil.selectAll(select)) {
                JPAStructuredType st = (JPAStructuredType)pathInfo[0];
                HashSet<JPAElement> collectionProperties = new HashSet<JPAElement>();
                block2: for (JPAPath path : st.getPathList()) {
                    for (JPAElement pathElement : path.getPath()) {
                        if (!(pathElement instanceof JPAAttribute) || !((JPAAttribute)pathElement).isCollection()) continue;
                        if (!path.isPartOfGroups(groups.isPresent() ? groups.get().getGroups() : new ArrayList(0))) continue block2;
                        collectionProperties.add(pathElement);
                        continue block2;
                    }
                }
                for (JPAElement pathElement : collectionProperties) {
                    JPACollectionExpandWrapper item = new JPACollectionExpandWrapper((JPAEntityType)pathInfo[1], uriResourceInfo);
                    itemList.add(new JPACollectionItemInfo(sd, item, ((JPACollectionAttribute)pathElement).asAssociation(), grandParentHops));
                }
            } else {
                JPAStructuredType st = (JPAStructuredType)pathInfo[0];
                Set<JPAPath> selectOptions = this.getCollectionAttributesFromSelection(st, uriResourceInfo.getSelectOption());
                for (JPAPath path : selectOptions) {
                    JPACollectionExpandWrapper item = new JPACollectionExpandWrapper((JPAEntityType)pathInfo[1], uriResourceInfo);
                    itemList.add(new JPACollectionItemInfo(sd, item, ((JPACollectionAttribute)path.getLeaf()).asAssociation(), grandParentHops));
                }
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        return itemList;
    }

    private Object[] determineNavigationElements(JPAServiceDocument sd, List<UriResource> startResourceList, JPAEntityType et) throws ODataJPAQueryException {
        Object[] result = new Object[3];
        if (startResourceList.isEmpty() && et != null) {
            result[0] = result[1] = et;
        } else {
            for (UriResource uriElement : startResourceList) {
                try {
                    if (uriElement instanceof UriResourceEntitySet || uriElement instanceof UriResourceNavigation) {
                        result[0] = result[1] = sd.getEntity(((UriResourcePartTyped)uriElement).getType());
                        continue;
                    }
                    if (uriElement instanceof UriResourceComplexProperty && !((UriResourceProperty)uriElement).isCollection()) {
                        result[0] = sd.getComplexType(((UriResourceComplexProperty)uriElement).getComplexType());
                        continue;
                    }
                    if (!(uriElement instanceof UriResourceProperty) || result[0] == null) continue;
                    result[2] = ((JPAStructuredType)result[0]).getPath(((UriResourceProperty)uriElement).getProperty().getName());
                }
                catch (ODataJPAModelException e) {
                    throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
                }
            }
        }
        return result;
    }

    protected Set<JPAPath> getCollectionAttributesFromSelection(JPAStructuredType jpaEntity, SelectOption select) throws ODataApplicationException, ODataJPAModelException {
        HashSet<JPAPath> collectionAttributes = new HashSet<JPAPath>();
        if (SelectOptionUtil.selectAll(select)) {
            collectionAttributes.addAll(jpaEntity.getCollectionAttributesPath());
        } else {
            String pathPrefix = "";
            for (SelectItem sItem : select.getSelectItems()) {
                JPAPath selectItemPath = SelectOptionUtil.selectItemAsPath(jpaEntity, "", sItem);
                if (selectItemPath.getLeaf().isComplex() && !selectItemPath.getLeaf().isCollection()) {
                    for (JPAPath selectSubItemPath : selectItemPath.getLeaf().getStructuredType().getPathList()) {
                        if (!this.pathContainsCollection(selectSubItemPath)) continue;
                        collectionAttributes.add(this.getCollection(jpaEntity, selectSubItemPath, ((JPAElement)selectItemPath.getPath().get(0)).getExternalName()));
                    }
                    continue;
                }
                if (!this.pathContainsCollection(selectItemPath)) continue;
                collectionAttributes.add(selectItemPath);
            }
        }
        return collectionAttributes;
    }

    private JPAPath getCollection(JPAStructuredType jpaEntity, JPAPath p, String prefix) throws ODataJPAModelException {
        StringBuilder pathAliase = new StringBuilder(prefix);
        for (JPAElement pathElement : p.getPath()) {
            pathAliase.append("/");
            pathAliase.append(pathElement.getExternalName());
            if (!(pathElement instanceof JPAAttribute) || !((JPAAttribute)pathElement).isCollection()) continue;
            return jpaEntity.getPath(pathAliase.toString());
        }
        return null;
    }

    private boolean pathContainsCollection(JPAPath p) {
        for (JPAElement pathElement : p.getPath()) {
            if (!(pathElement instanceof JPAAttribute) || !((JPAAttribute)pathElement).isCollection()) continue;
            return true;
        }
        return false;
    }
}

