/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.query.JPAExpandItem;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.CustomQueryOption;
import org.apache.olingo.server.api.uri.queryoption.DeltaTokenOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.api.uri.queryoption.IdOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;

public class JPAExpandItemWrapper
implements JPAExpandItem {
    private final ExpandItem item;
    private final JPAEntityType jpaEntityType;

    public JPAExpandItemWrapper(JPAServiceDocument sd, ExpandItem item) throws ODataApplicationException {
        this.item = item;
        try {
            this.jpaEntityType = sd.getEntity((EdmType)Util.determineTargetEntityType(this.getUriResourceParts()));
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_ENTITY_UNKNOWN, HttpStatusCode.BAD_REQUEST, (Throwable)e, Util.determineTargetEntityType(this.getUriResourceParts()).getName());
        }
    }

    public JPAExpandItemWrapper(ExpandItem item, JPAEntityType jpaEntityType) {
        this.item = item;
        this.jpaEntityType = jpaEntityType;
    }

    public List<CustomQueryOption> getCustomQueryOptions() {
        return null;
    }

    public ExpandOption getExpandOption() {
        return this.item.getExpandOption();
    }

    public FilterOption getFilterOption() {
        return this.item.getFilterOption();
    }

    public FormatOption getFormatOption() {
        return null;
    }

    public IdOption getIdOption() {
        return null;
    }

    public CountOption getCountOption() {
        return this.item.getCountOption();
    }

    public OrderByOption getOrderByOption() {
        return this.item.getOrderByOption();
    }

    public SearchOption getSearchOption() {
        return this.item.getSearchOption();
    }

    public SelectOption getSelectOption() {
        return this.item.getSelectOption();
    }

    public SkipOption getSkipOption() {
        return this.item.getSkipOption();
    }

    public SkipTokenOption getSkipTokenOption() {
        return null;
    }

    public TopOption getTopOption() {
        return this.item.getTopOption();
    }

    public List<UriResource> getUriResourceParts() {
        return this.item.getResourcePath() != null ? this.item.getResourcePath().getUriResourceParts() : Collections.emptyList();
    }

    public String getValueForAlias(String alias) {
        return null;
    }

    @Override
    public JPAEntityType getEntityType() {
        return this.jpaEntityType;
    }

    public ApplyOption getApplyOption() {
        return null;
    }

    public DeltaTokenOption getDeltaTokenOption() {
        return null;
    }
}

