/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAOnConditionItem;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.query.ExpressionUtil;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractJoinQuery;
import com.sap.olingo.jpa.processor.core.query.JPAExpandQueryResult;
import com.sap.olingo.jpa.processor.core.query.JPAInlineItemInfo;
import com.sap.olingo.jpa.processor.core.query.JPAKeyBoundary;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import com.sap.olingo.jpa.processor.core.query.JPANoSelectionException;
import com.sap.olingo.jpa.processor.core.query.JPAOrderByBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Selection;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;

public final class JPAExpandJoinQuery
extends JPAAbstractJoinQuery {
    private final JPAAssociationPath assoziation;
    private final Optional<JPAKeyBoundary> keyBoundary;
    private TypedQuery<Tuple> tupleQuery;

    public JPAExpandJoinQuery(OData odata, JPAODataCRUDContextAccess sessionContext, JPAInlineItemInfo item, Map<String, List<String>> requestHeaders, JPAODataRequestContextAccess requestContext, Optional<JPAKeyBoundary> keyBoundary) throws ODataException {
        super(odata, sessionContext, item.getEntityType(), item.getUriInfo(), requestContext, requestHeaders, item.getHops());
        this.assoziation = item.getExpandAssociation();
        this.keyBoundary = keyBoundary;
    }

    public JPAExpandJoinQuery(OData odata, JPAODataCRUDContextAccess context, JPAAssociationPath assoziation, JPAEntityType entityType, Map<String, List<String>> requestHeaders, JPAODataRequestContextAccess requestContext) throws ODataException {
        super(odata, context, entityType, requestContext, requestHeaders, Collections.emptyList());
        this.assoziation = assoziation;
        this.keyBoundary = Optional.empty();
    }

    @Override
    public JPAExpandQueryResult execute() throws ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "execute");
        long skip = 0L;
        long top = Long.MAX_VALUE;
        try {
            this.tupleQuery = this.createTupleQuery();
            int resultHandle = this.debugger.startRuntimeMeasurement(this.tupleQuery, "getResultList");
            List intermediateResult = this.tupleQuery.getResultList();
            this.debugger.stopRuntimeMeasurement(resultHandle);
            if (this.uriResource.getTopOption() != null || this.uriResource.getSkipOption() != null) {
                if (this.uriResource.getSkipOption() != null) {
                    skip = this.uriResource.getSkipOption().getValue();
                }
                if (this.uriResource.getTopOption() != null) {
                    top = this.uriResource.getTopOption().getValue();
                }
            }
            Map<String, List<Tuple>> result = this.convertResult(intermediateResult, this.assoziation, skip, top);
            HashSet<JPAPath> requestedSelection = new HashSet<JPAPath>();
            this.buildSelectionAddNavigationAndSelect(this.uriResource, requestedSelection, this.uriResource.getSelectOption());
            this.debugger.stopRuntimeMeasurement(handle);
            return new JPAExpandQueryResult(result, this.count(), this.jpaEntity, requestedSelection);
        }
        catch (JPANoSelectionException e) {
            return new JPAExpandQueryResult(Collections.emptyMap(), Collections.emptyMap(), this.jpaEntity, Collections.emptyList());
        }
        catch (ODataJPAModelException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), (Locale)ODataJPAModelException.getLocales().nextElement(), (Throwable)e);
        }
    }

    String getSQLString() throws ODataJPAQueryException {
        if (this.tupleQuery != null && this.tupleQuery.getClass().getCanonicalName().equals("org.eclipse.persistence.internal.jpa.EJBQueryImpl")) {
            try {
                Object dbQuery = this.tupleQuery.getClass().getMethod("getDatabaseQuery", new Class[0]).invoke(this.tupleQuery, new Object[0]);
                return (String)dbQuery.getClass().getMethod("getSQLString", new Class[0]).invoke(dbQuery, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        }
        return "";
    }

    @Override
    protected List<Selection<?>> createSelectClause(Map<String, From<?, ?>> joinTables, Collection<JPAPath> jpaPathList, From<?, ?> target, List<String> groups) throws ODataApplicationException {
        ArrayList selections = new ArrayList(super.createSelectClause(joinTables, jpaPathList, target, groups));
        if (this.assoziation.getJoinTable() != null) {
            this.createAdditionSelctionForJoinTable(selections);
        }
        return selections;
    }

    private void createAdditionSelctionForJoinTable(List<Selection<?>> selections) throws ODataJPAQueryException {
        From<?, ?> parent = this.determineParentFrom();
        try {
            for (JPAPath p : this.assoziation.getLeftColumnsList()) {
                Path<?> selection = ExpressionUtil.convertToCriteriaPath(parent, p.getPath());
                selection.alias(this.assoziation.getAlias() + "." + p.getAlias());
                selections.add((Selection<?>)selection);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    Map<String, List<Tuple>> convertResult(List<Tuple> intermediateResult, JPAAssociationPath associationPath, long skip, long top) throws ODataApplicationException {
        String joinKey = "";
        long skiped = 0L;
        long taken = 0L;
        ArrayList<Tuple> subResult = null;
        HashMap<String, List<Tuple>> convertedResult = new HashMap<String, List<Tuple>>();
        for (Tuple row : intermediateResult) {
            String actuallKey;
            try {
                actuallKey = this.buildConcatenatedKey(row, associationPath);
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
            }
            if (!actuallKey.equals(joinKey)) {
                subResult = new ArrayList<Tuple>();
                convertedResult.put(actuallKey, subResult);
                joinKey = actuallKey;
                taken = 0L;
                skiped = 0L;
            }
            if (skiped >= skip && taken < top) {
                ++taken;
                subResult.add(row);
                continue;
            }
            ++skiped;
        }
        return convertedResult;
    }

    private String buildConcatenatedKey(Tuple row, JPAAssociationPath associationPath) throws ODataJPAModelException {
        if (associationPath.getJoinTable() == null) {
            List joinColumns = associationPath.getRightColumnsList();
            return joinColumns.stream().map(c -> row.get(c.getAlias()).toString()).collect(Collectors.joining("/"));
        }
        List joinColumns = associationPath.getLeftColumnsList();
        return joinColumns.stream().map(c -> row.get(this.assoziation.getAlias() + "." + c.getAlias()).toString()).collect(Collectors.joining("/"));
    }

    private List<Expression<?>> buildExpandCountGroupBy() throws ODataJPAQueryException {
        ArrayList groupBy = new ArrayList();
        try {
            List associationPathList = this.assoziation.getJoinColumnsList();
            for (JPAOnConditionItem onCondition : associationPathList) {
                groupBy.add((Expression<?>)ExpressionUtil.convertToCriteriaPath(this.target, onCondition.getRightPath().getPath()));
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
        }
        return groupBy;
    }

    private List<Selection<?>> buildExpandJoinPath() throws ODataApplicationException {
        ArrayList selections = new ArrayList();
        try {
            List associationPathList = this.assoziation.getJoinColumnsList();
            for (JPAOnConditionItem onCondition : associationPathList) {
                Path<?> p = ExpressionUtil.convertToCriteriaPath(this.target, onCondition.getRightPath().getPath());
                p.alias(onCondition.getRightPath().getAlias());
                selections.add((Selection<?>)p);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
        }
        return selections;
    }

    private Map<String, Long> convertCountResult(List<Tuple> intermediateResult) throws ODataJPAQueryException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Tuple row : intermediateResult) {
            try {
                String actuallKey = this.buildConcatenatedKey(row, this.assoziation);
                Long count = (Long)row.get("$count");
                result.put(actuallKey, count);
            }
            catch (ODataJPAModelException e) {
                throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
            }
        }
        return result;
    }

    private Map<String, Long> count() throws ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "count");
        List uriResourceParts = this.uriResource.getUriResourceParts();
        if (this.uriResource.getCountOption() != null || uriResourceParts != null && !uriResourceParts.isEmpty() && uriResourceParts.get(uriResourceParts.size() - 1) instanceof UriResourceCount) {
            CriteriaQuery countQuery = this.cb.createTupleQuery();
            List<Selection<?>> selectionPath = this.buildExpandJoinPath();
            Expression count = this.cb.count((Expression)this.target);
            count.alias("$count");
            selectionPath.add((Selection<?>)count);
            countQuery.multiselect(selectionPath);
            Expression<Boolean> whereClause = this.createWhere();
            if (whereClause != null) {
                this.cq.where(whereClause);
            }
            countQuery.groupBy(this.buildExpandCountGroupBy());
            TypedQuery query = this.em.createQuery(countQuery);
            List intermediateResult = query.getResultList();
            return this.convertCountResult(intermediateResult);
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return null;
    }

    private List<Order> createOrderByJoinCondition(JPAAssociationPath associationPath) throws ODataApplicationException {
        ArrayList<Order> orders = new ArrayList<Order>();
        try {
            List joinColumns = associationPath.getJoinTable() == null ? associationPath.getRightColumnsList() : associationPath.getLeftColumnsList();
            Path from = associationPath.getJoinTable() == null ? this.target : this.determineParentFrom();
            for (JPAPath j : joinColumns) {
                Path jpaProperty = from;
                for (JPAElement pathElement : j.getPath()) {
                    jpaProperty = jpaProperty.get(pathElement.getInternalName());
                }
                orders.add(this.cb.asc(jpaProperty));
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
        }
        return orders;
    }

    private TypedQuery<Tuple> createTupleQuery() throws ODataApplicationException, JPANoSelectionException {
        int handle = this.debugger.startRuntimeMeasurement(this, "createTupleQuery");
        Set<JPAPath> selectionPath = this.buildSelectionPathList(this.uriResource);
        Map<String, From<?, ?>> joinTables = this.createFromClause(new ArrayList<JPAAssociationPath>(1), selectionPath, this.cq, this.lastInfo);
        this.cq.multiselect(this.createSelectClause(joinTables, selectionPath, this.target, this.groups));
        this.cq.distinct(true);
        Expression<Boolean> whereClause = this.createWhere();
        if (whereClause != null) {
            this.cq.where(whereClause);
        }
        List<Order> orderBy = this.createOrderByJoinCondition(this.assoziation);
        orderBy.addAll(new JPAOrderByBuilder(this.jpaEntity, this.target, this.cb, this.groups).createOrderByList(joinTables, this.uriResource));
        this.cq.orderBy(orderBy);
        TypedQuery query = this.em.createQuery(this.cq);
        this.debugger.stopRuntimeMeasurement(handle);
        return query;
    }

    private Expression<Boolean> createWhere() throws ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "createWhere");
        Expression<Boolean> whereCondition = null;
        try {
            whereCondition = this.createKeyWhere(this.navigationInfo);
            whereCondition = this.addWhereClause(whereCondition, this.createBoundary(this.navigationInfo, this.keyBoundary));
            whereCondition = this.addWhereClause(whereCondition, this.createExpandWhere());
            whereCondition = this.addWhereClause(whereCondition, this.createProtectionWhere(this.claimsProvider));
        }
        catch (ODataApplicationException e) {
            this.debugger.stopRuntimeMeasurement(handle);
            throw e;
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return whereCondition;
    }

    private Expression<Boolean> createExpandWhere() throws ODataApplicationException {
        Expression<Boolean> whereCondition = null;
        for (JPANavigationProptertyInfo info : this.navigationInfo) {
            if (info.getFilterCompiler() == null) continue;
            try {
                whereCondition = this.addWhereClause(whereCondition, info.getFilterCompiler().compile());
            }
            catch (ExpressionVisitException e) {
                throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_FILTER_ERROR, HttpStatusCode.BAD_REQUEST, (Throwable)e);
            }
        }
        return whereCondition;
    }

    private From<?, ?> determineParentFrom() throws ODataJPAQueryException {
        for (JPANavigationProptertyInfo item : this.navigationInfo) {
            if (item.getAssociationPath() != this.assoziation) continue;
            return item.getFromClause();
        }
        throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_FILTER_ERROR, HttpStatusCode.BAD_REQUEST);
    }

    @Override
    protected Set<JPAPath> buildSelectionPathList(UriInfoResource uriResource) throws ODataApplicationException {
        try {
            Set<JPAPath> jpaPathList = super.buildSelectionPathList(uriResource);
            jpaPathList.addAll(this.assoziation.getRightColumnsList());
            return jpaPathList;
        }
        catch (ODataJPAModelException e) {
            throw new ODataApplicationException(e.getLocalizedMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), (Locale)ODataJPAModelException.getLocales().nextElement(), (Throwable)e);
        }
    }
}

