/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.query.JPAExpandItem;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.CustomQueryOption;
import org.apache.olingo.server.api.uri.queryoption.DeltaTokenOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.api.uri.queryoption.IdOption;
import org.apache.olingo.server.api.uri.queryoption.LevelsExpandOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.api.uri.queryoption.TopOption;

public final class JPAExpandLevelWrapper
implements JPAExpandItem {
    private final ExpandOption option;
    private final ExpandItem item;
    private final JPAEntityType jpaEntityType;
    private final LevelsExpandOption levelOptions;

    public JPAExpandLevelWrapper(JPAServiceDocument sd, ExpandOption option) throws ODataApplicationException {
        this.option = option;
        this.item = (ExpandItem)option.getExpandItems().get(0);
        this.levelOptions = this.determineLevel(this.item);
        try {
            this.jpaEntityType = sd.getEntity((EdmType)Util.determineTargetEntityType(this.getUriResourceParts()));
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_ENTITY_UNKNOWN, HttpStatusCode.BAD_REQUEST, (Throwable)e, Util.determineTargetEntityType(this.getUriResourceParts()).getName());
        }
    }

    public JPAExpandLevelWrapper(ExpandOption option, JPAEntityType jpaEntityType) {
        this.option = option;
        this.item = (ExpandItem)option.getExpandItems().get(0);
        this.levelOptions = this.determineLevel(this.item);
        this.jpaEntityType = jpaEntityType;
    }

    public List<CustomQueryOption> getCustomQueryOptions() {
        return null;
    }

    public ExpandOption getExpandOption() {
        if (this.levelOptions.getValue() > 1 || this.levelOptions.isMax()) {
            return new ExpandOptionWrapper(this.option);
        }
        return null;
    }

    public FilterOption getFilterOption() {
        return this.item.getFilterOption();
    }

    public FormatOption getFormatOption() {
        return null;
    }

    public IdOption getIdOption() {
        return null;
    }

    public CountOption getCountOption() {
        return this.item.getCountOption();
    }

    public OrderByOption getOrderByOption() {
        return this.item.getOrderByOption();
    }

    public SearchOption getSearchOption() {
        return this.item.getSearchOption();
    }

    public SelectOption getSelectOption() {
        return this.item.getSelectOption();
    }

    public SkipOption getSkipOption() {
        return this.item.getSkipOption();
    }

    public SkipTokenOption getSkipTokenOption() {
        return null;
    }

    public TopOption getTopOption() {
        return this.item.getTopOption();
    }

    public List<UriResource> getUriResourceParts() {
        return this.item.getResourcePath() != null ? this.item.getResourcePath().getUriResourceParts() : Collections.emptyList();
    }

    public String getValueForAlias(String alias) {
        return null;
    }

    @Override
    public JPAEntityType getEntityType() {
        return this.jpaEntityType;
    }

    public ApplyOption getApplyOption() {
        return null;
    }

    private LevelsExpandOption determineLevel(ExpandItem item2) {
        return this.item.getLevelsOption();
    }

    public DeltaTokenOption getDeltaTokenOption() {
        return null;
    }

    private class ExpandOptionWrapper
    implements ExpandOption {
        private final List<ExpandItem> items = new ArrayList<ExpandItem>();
        private final ExpandOption parentOptions;

        private ExpandOptionWrapper(ExpandOption expandOption) {
            this.items.add(new ExpandItemWrapper((ExpandItem)expandOption.getExpandItems().get(0)));
            this.parentOptions = expandOption;
            ((ExpandItem)expandOption.getExpandItems().get(0)).getLevelsOption();
        }

        public SystemQueryOptionKind getKind() {
            return this.parentOptions.getKind();
        }

        public String getName() {
            return this.parentOptions.getName();
        }

        public String getText() {
            return this.parentOptions.getText();
        }

        public List<ExpandItem> getExpandItems() {
            return this.items;
        }
    }

    private class LevelsExpandOptionWrapper
    implements LevelsExpandOption {
        private final boolean isMax;
        private final int level;

        private LevelsExpandOptionWrapper(boolean isMax, int parentLevel) {
            this.isMax = isMax;
            this.level = parentLevel != 0 ? parentLevel - 1 : 0;
        }

        public boolean isMax() {
            return this.isMax;
        }

        public int getValue() {
            return this.level;
        }
    }

    private class ExpandItemWrapper
    implements ExpandItem {
        private final ExpandItem parentItem;
        private ExpandOption expandOption;
        private final LevelsExpandOption levelOption;

        private ExpandItemWrapper(ExpandItem parentItem) {
            this.parentItem = parentItem;
            this.levelOption = new LevelsExpandOptionWrapper(parentItem.getLevelsOption().isMax(), parentItem.getLevelsOption().getValue());
        }

        public LevelsExpandOption getLevelsOption() {
            return this.levelOption;
        }

        public FilterOption getFilterOption() {
            return this.parentItem.getFilterOption();
        }

        public SearchOption getSearchOption() {
            return null;
        }

        public OrderByOption getOrderByOption() {
            return this.parentItem.getOrderByOption();
        }

        public SkipOption getSkipOption() {
            return this.parentItem.getSkipOption();
        }

        public TopOption getTopOption() {
            return this.parentItem.getTopOption();
        }

        public CountOption getCountOption() {
            return this.parentItem.getCountOption();
        }

        public SelectOption getSelectOption() {
            return this.parentItem.getSelectOption();
        }

        public ExpandOption getExpandOption() {
            if (this.expandOption == null) {
                this.expandOption = new ExpandOptionWrapper(this.parentItem.getExpandOption());
            }
            return this.expandOption;
        }

        public UriInfoResource getResourcePath() {
            return this.parentItem.getResourcePath();
        }

        public boolean isStar() {
            return false;
        }

        public boolean isRef() {
            return false;
        }

        public boolean hasCountPath() {
            return false;
        }

        public EdmType getStartTypeFilter() {
            return this.parentItem.getStartTypeFilter();
        }

        public ApplyOption getApplyOption() {
            return null;
        }
    }
}

