/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.converter.JPAExpandResult;
import com.sap.olingo.jpa.processor.core.converter.JPATupleChildConverter;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.query.JPAConvertableResult;
import com.sap.olingo.jpa.processor.core.query.JPAKeyBoundary;
import com.sap.olingo.jpa.processor.core.query.JPAKeyPair;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import com.sap.olingo.jpa.processor.core.query.SelectOptionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.persistence.Tuple;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;

public final class JPAExpandQueryResult
implements JPAExpandResult,
JPAConvertableResult {
    private static final Map<String, List<Tuple>> EMPTY_RESULT = new HashMap<String, List<Tuple>>(1);
    private final Map<JPAAssociationPath, JPAExpandResult> childrenResult;
    private final Map<String, List<Tuple>> jpaResult;
    private Map<String, EntityCollection> odataResult;
    private final Map<String, Long> counts;
    private final JPAEntityType jpaEntityType;
    private final Collection<JPAPath> requestedSelection;

    private static Map<String, List<Tuple>> putEmptyResult() {
        EMPTY_RESULT.put("root", Collections.emptyList());
        return EMPTY_RESULT;
    }

    public JPAExpandQueryResult(JPAEntityType jpaEntityType, Collection<JPAPath> selectionPath) {
        this(JPAExpandQueryResult.putEmptyResult(), Collections.emptyMap(), jpaEntityType, selectionPath);
    }

    public JPAExpandQueryResult(Map<String, List<Tuple>> result, Map<String, Long> counts, @Nonnull JPAEntityType jpaEntityType, Collection<JPAPath> selectionPath) {
        Objects.requireNonNull(jpaEntityType);
        this.childrenResult = new HashMap<JPAAssociationPath, JPAExpandResult>();
        this.jpaResult = result;
        this.counts = counts;
        this.jpaEntityType = jpaEntityType;
        this.requestedSelection = selectionPath;
    }

    @Override
    public Map<String, EntityCollection> asEntityCollection(JPATupleChildConverter converter) throws ODataApplicationException {
        this.convert(new JPATupleChildConverter(converter));
        return this.odataResult;
    }

    @Override
    public void convert(JPATupleChildConverter converter) throws ODataApplicationException {
        if (this.odataResult == null) {
            for (Map.Entry<JPAAssociationPath, JPAExpandResult> childResult : this.childrenResult.entrySet()) {
                childResult.getValue().convert(converter);
            }
            this.odataResult = converter.getResult((JPAExpandResult)this, (Collection)this.requestedSelection);
        }
    }

    @Override
    public JPAExpandResult getChild(JPAAssociationPath associationPath) {
        return this.childrenResult.get(associationPath);
    }

    @Override
    public Map<JPAAssociationPath, JPAExpandResult> getChildren() {
        return this.childrenResult;
    }

    @Override
    public Long getCount(String key) {
        return this.counts != null ? this.counts.get(key) : null;
    }

    @Override
    public JPAEntityType getEntityType() {
        return this.jpaEntityType;
    }

    public long getNoResults() {
        return this.jpaResult.size();
    }

    public long getNoResultsDeep() {
        long count = 0L;
        for (Map.Entry<String, List<Tuple>> result : this.jpaResult.entrySet()) {
            count += (long)result.getValue().size();
        }
        return count;
    }

    @Override
    public List<Tuple> getResult(String key) {
        return this.jpaResult.get(key);
    }

    @Override
    public boolean hasCount() {
        return this.counts != null;
    }

    @Override
    public void putChildren(Map<JPAAssociationPath, JPAExpandResult> childResults) throws ODataApplicationException {
        for (JPAAssociationPath child : childResults.keySet()) {
            if (this.childrenResult.get(child) == null) continue;
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_EXPAND_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        this.childrenResult.putAll(childResults);
    }

    @Override
    public Map<String, List<Tuple>> getResults() {
        return this.jpaResult;
    }

    @Override
    public EntityCollection getEntityCollection(String key) {
        return this.odataResult.containsKey(key) ? this.odataResult.get(key) : new EntityCollection();
    }

    @Override
    public Optional<JPAKeyBoundary> getKeyBoundary(JPAODataRequestContextAccess requestContext, List<JPANavigationProptertyInfo> hops) throws ODataJPAQueryException {
        try {
            if (!(this.jpaResult.get("root").isEmpty() || requestContext.getUriInfo().getExpandOption() == null && !this.collectionPropertyRequested(requestContext) || requestContext.getUriInfo().getTopOption() == null && requestContext.getUriInfo().getSkipOption() == null)) {
                JPAKeyPair boundary = new JPAKeyPair(this.jpaEntityType.getKey());
                for (Tuple tuple : this.jpaResult.get("root")) {
                    Map<JPAAttribute, Comparable> key = this.createKey(tuple);
                    boundary.setValue(key);
                }
                return Optional.of(new JPAKeyBoundary(hops.size(), boundary));
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        return JPAConvertableResult.super.getKeyBoundary(requestContext, hops);
    }

    private boolean collectionPropertyRequested(JPAODataRequestContextAccess requestContext) throws ODataJPAModelException {
        if (!this.jpaEntityType.getCollectionAttributesPath().isEmpty()) {
            SelectOption selectOptions = requestContext.getUriInfo().getSelectOption();
            if (SelectOptionUtil.selectAll(selectOptions)) {
                return true;
            }
            for (SelectItem item : selectOptions.getSelectItems()) {
                String pathItem = item.getResourcePath().getUriResourceParts().stream().map(path -> path.getSegmentValue()).collect(Collectors.joining("/"));
                if (this.jpaEntityType.getCollectionAttribute(pathItem) == null) continue;
                return true;
            }
        }
        return false;
    }

    private Map<JPAAttribute, Comparable> createKey(Tuple tuple) throws ODataJPAModelException {
        HashMap<JPAAttribute, Comparable> keyMap = new HashMap<JPAAttribute, Comparable>(this.jpaEntityType.getKey().size());
        for (JPAAttribute key : this.jpaEntityType.getKey()) {
            keyMap.put(key, (Comparable)tuple.get(key.getExternalName()));
        }
        return keyMap;
    }

    static {
        JPAExpandQueryResult.putEmptyResult();
    }
}

