/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPACollectionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataRequestContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.query.ExpressionUtil;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractJoinQuery;
import com.sap.olingo.jpa.processor.core.query.JPACollectionQueryResult;
import com.sap.olingo.jpa.processor.core.query.JPAConvertableResult;
import com.sap.olingo.jpa.processor.core.query.JPACountQuery;
import com.sap.olingo.jpa.processor.core.query.JPAExpandQueryResult;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import com.sap.olingo.jpa.processor.core.query.JPANoSelectionException;
import com.sap.olingo.jpa.processor.core.query.JPAOrderByBuilder;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Selection;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;

public class JPAJoinQuery
extends JPAAbstractJoinQuery
implements JPACountQuery {
    private static List<JPANavigationProptertyInfo> determineNavigationInfo(JPAODataCRUDContextAccess sessionContext, UriInfoResource uriResource) throws ODataException {
        return Util.determineNavigationPath(sessionContext.getEdmProvider().getServiceDocument(), uriResource.getUriResourceParts(), uriResource);
    }

    private static JPAEntityType determineTargetEntityType(JPAODataCRUDContextAccess sessionContext, JPAODataRequestContextAccess requestContext) throws ODataException {
        return sessionContext.getEdmProvider().getServiceDocument().getEntity(Util.determineTargetEntitySet(requestContext.getUriInfo().getUriResourceParts()).getName());
    }

    public JPAJoinQuery(OData odata, JPAODataCRUDContextAccess sessionContext, Map<String, List<String>> requestHeaders, JPAODataRequestContextAccess requestContext) throws ODataException {
        super(odata, sessionContext, JPAJoinQuery.determineTargetEntityType(sessionContext, requestContext), requestContext, requestHeaders, JPAJoinQuery.determineNavigationInfo(sessionContext, requestContext.getUriInfo()));
    }

    @Override
    public Long countResults() throws ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "countResults");
        CriteriaQuery countQuery = this.cb.createQuery(Long.class);
        try {
            this.createFromClause(Collections.emptyList(), Collections.emptyList(), countQuery, this.lastInfo);
            Expression<Boolean> whereClause = this.createWhere();
            if (whereClause != null) {
                countQuery.where(whereClause);
            }
            countQuery.select((Selection)this.cb.countDistinct((Expression)this.target));
            this.debugger.stopRuntimeMeasurement(handle);
            return (Long)this.em.createQuery(countQuery).getSingleResult();
        }
        catch (JPANoSelectionException e) {
            return 0L;
        }
    }

    @Override
    public JPAConvertableResult execute() throws ODataApplicationException {
        int handle = this.debugger.startRuntimeMeasurement(this, "execute");
        List<JPAAssociationPath> orderByNaviAttributes = this.extractOrderByNaviAttributes();
        Set<JPAPath> selectionPath = this.buildSelectionPathList(this.uriResource);
        try {
            Map<String, From<?, ?>> joinTables = this.createFromClause(orderByNaviAttributes, selectionPath, this.cq, this.lastInfo);
            this.cq.multiselect(this.createSelectClause(joinTables, selectionPath, this.target, this.groups)).distinct(this.determineDistinct());
            Expression<Boolean> whereClause = this.createWhere();
            if (whereClause != null) {
                this.cq.where(whereClause);
            }
            this.cq.orderBy(new JPAOrderByBuilder(this.jpaEntity, this.target, this.cb, this.groups).createOrderByList(joinTables, this.uriResource));
            if (!orderByNaviAttributes.isEmpty()) {
                this.cq.groupBy(this.createGroupBy(joinTables, selectionPath));
            }
            TypedQuery tq = this.em.createQuery(this.cq);
            this.addTopSkip((TypedQuery<Tuple>)tq);
            HashMap<String, List<Tuple>> result = new HashMap<String, List<Tuple>>(1);
            int resultHandle = this.debugger.startRuntimeMeasurement(tq, "getResultList");
            List intermediateResult = tq.getResultList();
            this.debugger.stopRuntimeMeasurement(resultHandle);
            result.put("root", intermediateResult);
            this.debugger.stopRuntimeMeasurement(handle);
            return this.returnResult(selectionPath, result);
        }
        catch (JPANoSelectionException e) {
            this.debugger.stopRuntimeMeasurement(handle);
            return this.returnEmptyResult(selectionPath);
        }
    }

    public List<JPANavigationProptertyInfo> getNavigationInfo() {
        return this.navigationInfo;
    }

    @Override
    public AbstractQuery<?> getQuery() {
        return this.cq;
    }

    private List<Expression<?>> createGroupBy(Map<String, From<?, ?>> joinTables, Collection<JPAPath> selectionPathList) {
        int handle = this.debugger.startRuntimeMeasurement(this, "createGroupBy");
        ArrayList groupBy = new ArrayList();
        for (JPAPath jpaPath : selectionPathList) {
            groupBy.add((Expression<?>)ExpressionUtil.convertToCriteriaPath(joinTables, this.root, jpaPath.getPath()));
        }
        this.debugger.stopRuntimeMeasurement(handle);
        return groupBy;
    }

    private Expression<Boolean> createWhere() throws ODataApplicationException {
        return this.addWhereClause(super.createWhere(this.uriResource, this.navigationInfo), this.createProtectionWhere(this.claimsProvider));
    }

    private boolean determineDistinct() {
        return this.claimsProvider.isPresent();
    }

    private List<JPAAssociationPath> extractOrderByNaviAttributes() throws ODataApplicationException {
        ArrayList<JPAAssociationPath> naviAttributes = new ArrayList<JPAAssociationPath>();
        OrderByOption orderBy = this.uriResource.getOrderByOption();
        if (orderBy != null) {
            for (OrderByItem orderByItem : orderBy.getOrders()) {
                org.apache.olingo.server.api.uri.queryoption.expression.Expression expression = orderByItem.getExpression();
                if (!(expression instanceof Member)) continue;
                UriInfoResource resourcePath = ((Member)expression).getResourcePath();
                StringBuilder pathString = new StringBuilder();
                for (UriResource uriResource : resourcePath.getUriResourceParts()) {
                    try {
                        if (uriResource instanceof UriResourceNavigation) {
                            EdmNavigationProperty edmNaviProperty = ((UriResourceNavigation)uriResource).getProperty();
                            naviAttributes.add(this.jpaEntity.getAssociationPath(edmNaviProperty.getName()));
                            continue;
                        }
                        if (uriResource instanceof UriResourceProperty && ((UriResourceProperty)uriResource).isCollection()) {
                            pathString.append(((UriResourceProperty)uriResource).getProperty().getName());
                            naviAttributes.add(((JPACollectionAttribute)this.jpaEntity.getPath(pathString.toString()).getLeaf()).asAssociation());
                            continue;
                        }
                        if (!(uriResource instanceof UriResourceProperty)) continue;
                        pathString.append(((UriResourceProperty)uriResource).getProperty().getName());
                        pathString.append("/");
                    }
                    catch (ODataJPAModelException e) {
                        throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_CONV_ERROR, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e);
                    }
                }
            }
        }
        return naviAttributes;
    }

    private JPAConvertableResult returnEmptyResult(Collection<JPAPath> selectionPath) {
        if (this.lastInfo.getAssociationPath() != null && this.lastInfo.getAssociationPath().getLeaf() instanceof JPACollectionAttribute) {
            return new JPACollectionQueryResult(this.jpaEntity, this.lastInfo.getAssociationPath(), selectionPath);
        }
        return new JPAExpandQueryResult(this.jpaEntity, selectionPath);
    }

    private JPAConvertableResult returnResult(Collection<JPAPath> selectionPath, HashMap<String, List<Tuple>> result) {
        if (this.lastInfo.getAssociationPath() != null && this.lastInfo.getAssociationPath().getLeaf() instanceof JPACollectionAttribute) {
            return new JPACollectionQueryResult(result, null, this.jpaEntity, this.lastInfo.getAssociationPath(), selectionPath);
        }
        return new JPAExpandQueryResult(result, null, this.jpaEntity, selectionPath);
    }
}

