/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import java.util.List;
import java.util.Map;

public class JPAKeyPair {
    private Map<JPAAttribute, Comparable> min;
    private Map<JPAAttribute, Comparable> max;
    private final List<JPAAttribute> keyDefinition;

    public JPAKeyPair(List<JPAAttribute> keyDef) {
        this.keyDefinition = keyDef;
    }

    public Map<JPAAttribute, Comparable> getMin() {
        return this.min;
    }

    public <Y extends Comparable<? super Y>> Y getMinElement(JPAAttribute keyElement) {
        return (Y)this.min.get(keyElement);
    }

    public Map<JPAAttribute, Comparable> getMax() {
        return this.max;
    }

    public <Y extends Comparable<? super Y>> Y getMaxElement(JPAAttribute keyElement) {
        return (Y)this.max.get(keyElement);
    }

    public boolean hasUpperBoundary() {
        return this.max != null && !this.min.equals(this.max);
    }

    public void setValue(Map<JPAAttribute, Comparable> value) {
        for (JPAAttribute keyElement : this.keyDefinition) {
            if (this.min == null || this.min.get(keyElement) == null || value.get(keyElement) != null && value.get(keyElement).compareTo(this.min.get(keyElement)) < 0) {
                if (this.max == null) {
                    this.max = this.min;
                }
                this.min = value;
                return;
            }
            if (this.max == null || value.get(keyElement).compareTo(this.max.get(keyElement)) > 0) {
                this.max = value;
                return;
            }
            if (value.get(keyElement).compareTo(this.max.get(keyElement)) == 0) continue;
            return;
        }
    }

    public String toString() {
        return "JPAKeyPair [min=" + this.min + ", max=" + this.max + ", hasUpperBoundary=" + this.hasUpperBoundary() + "]";
    }
}

