/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPADescriptionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAOnConditionItem;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterElementComplier;
import com.sap.olingo.jpa.processor.core.filter.JPAOperationConverter;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractQuery;
import com.sap.olingo.jpa.processor.core.query.JPANavigationQuery;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Subquery;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.expression.VisitableExpression;

public final class JPANavigationFilterQuery
extends JPANavigationQuery {
    private final List<UriParameter> keyPredicates;

    public JPANavigationFilterQuery(OData odata, JPAServiceDocument sd, UriResource uriResourceItem, JPAAbstractQuery parent, EntityManager em, JPAAssociationPath association, From<?, ?> from, Optional<JPAODataClaimProvider> claimsProvider) throws ODataApplicationException {
        super(odata, sd, (EdmEntityType)((UriResourcePartTyped)uriResourceItem).getType(), em, parent, from, association, claimsProvider);
        this.keyPredicates = Util.determineKeyPredicates(uriResourceItem);
        this.subQuery = parent.getQuery().subquery(this.jpaEntity.getKeyType());
        this.locale = parent.getLocale();
        this.filterComplier = null;
        this.aggregationType = null;
        this.createRoots(association);
    }

    public JPANavigationFilterQuery(OData odata, JPAServiceDocument sd, UriResource uriResourceItem, JPAAbstractQuery parent, EntityManager em, JPAAssociationPath association, VisitableExpression expression, From<?, ?> from, Optional<JPAODataClaimProvider> claimsProvider, List<String> groups) throws ODataApplicationException {
        super(odata, sd, (EdmEntityType)((UriResourcePartTyped)uriResourceItem).getType(), em, parent, from, association, claimsProvider);
        this.keyPredicates = Util.determineKeyPredicates(uriResourceItem);
        this.subQuery = parent.getQuery().subquery(this.jpaEntity.getKeyType());
        this.locale = parent.getLocale();
        this.filterComplier = new JPAFilterElementComplier(odata, sd, em, this.jpaEntity, new JPAOperationConverter(this.cb, this.getContext().getOperationConverter()), null, this, expression, null, groups);
        this.aggregationType = this.getAggregationType(this.filterComplier.getExpressionMember());
        this.createRoots(association);
        this.createDescriptionJoin();
    }

    @Override
    public From<?, ?> getRoot() {
        assert (this.queryRoot != null);
        return this.queryRoot;
    }

    @Override
    public <T> Subquery<T> getSubQueryExists(Subquery<?> childQuery) throws ODataApplicationException {
        Subquery query = this.subQuery;
        if (this.queryJoinTable != null) {
            if (this.aggregationType != null) {
                this.createSubQueryJoinTableAggregation();
            } else {
                this.createSubQueryJoinTable();
            }
        } else {
            this.createSubQueryAggregation(childQuery, query);
        }
        return query;
    }

    private void createDescriptionJoin() throws ODataApplicationException {
        HashMap joinTables = new HashMap();
        this.generateDesciptionJoin(joinTables, this.determineAllDescriptionPath(), this.getRoot());
    }

    private <T> void createSubQueryAggregation(Subquery<?> childQuery, Subquery<T> query) throws ODataApplicationException {
        List<JPAOnConditionItem> conditionItems = this.determineJoinColumns();
        this.createSelectClause(query, this.queryRoot, conditionItems);
        Expression<Boolean> whereCondition = null;
        whereCondition = this.addWhereClause(this.createWhereByAssociation(this.from, this.queryRoot, conditionItems), this.createWhereByKey(this.queryRoot, null, this.keyPredicates, this.jpaEntity));
        if (childQuery != null) {
            whereCondition = this.cb.and(whereCondition, (Expression)this.cb.exists(childQuery));
        }
        whereCondition = this.addWhereClause(whereCondition, this.createProtectionWhereForEntityType(this.claimsProvider, this.jpaEntity, this.queryRoot));
        query.where(this.applyAdditionalFilter(whereCondition));
        this.handleAggregation(query, this.queryRoot, conditionItems);
    }

    private Set<JPAPath> determineAllDescriptionPath() throws ODataApplicationException {
        HashSet<JPAPath> allPath = new HashSet<JPAPath>();
        if (this.filterComplier != null) {
            for (JPAPath path : this.filterComplier.getMember()) {
                if (!(path.getLeaf() instanceof JPADescriptionAttribute)) continue;
                allPath.add(path);
            }
        }
        return allPath;
    }

    private List<JPAOnConditionItem> determineJoinColumns() throws ODataJPAQueryException {
        try {
            List conditionItems = this.association.getJoinColumnsList();
            if (conditionItems.isEmpty()) {
                throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_JOIN_NOT_DEFINED, HttpStatusCode.INTERNAL_SERVER_ERROR, this.association.getTargetType().getExternalName(), this.association.getSourceType().getExternalName());
            }
            return conditionItems;
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_RESULT_NAVI_PROPERTY_UNKNOWN, HttpStatusCode.INTERNAL_SERVER_ERROR, (Throwable)e, this.association.getAlias());
        }
    }
}

