/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterComplier;
import com.sap.olingo.jpa.processor.core.query.JPAExpandItem;
import com.sap.olingo.jpa.processor.core.query.Util;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.From;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;

public final class JPANavigationProptertyInfo {
    private final JPAServiceDocument sd;
    private final UriResourcePartTyped navigationTarget;
    private JPAAssociationPath associationPath;
    private final List<UriParameter> keyPredicates;
    private From<?, ?> fromClause = null;
    private final UriInfoResource uriInfo;
    private JPAEntityType et = null;
    private JPAFilterComplier filterCompiler = null;

    public JPANavigationProptertyInfo(JPANavigationProptertyInfo original) {
        this.navigationTarget = original.getUriResiource();
        this.associationPath = original.getAssociationPath();
        this.keyPredicates = original.getKeyPredicates();
        this.uriInfo = original.getUriInfo();
        this.sd = original.getServiceDocument();
        this.et = this.uriInfo instanceof JPAExpandItem ? ((JPAExpandItem)this.uriInfo).getEntityType() : null;
    }

    public JPANavigationProptertyInfo(JPAServiceDocument sd, JPAAssociationPath associationPath, UriInfoResource uriInfo, JPAEntityType et) {
        this.navigationTarget = null;
        this.associationPath = associationPath;
        this.keyPredicates = Collections.emptyList();
        this.uriInfo = uriInfo;
        this.sd = sd;
        this.et = et;
    }

    public JPANavigationProptertyInfo(JPAServiceDocument sd, UriResourcePartTyped uriResource, JPAAssociationPath associationPath, UriInfoResource uriInfo) throws ODataApplicationException {
        this.navigationTarget = uriResource;
        this.associationPath = associationPath;
        this.keyPredicates = uriResource.isCollection() ? Collections.emptyList() : Util.determineKeyPredicates((UriResource)uriResource);
        this.uriInfo = uriInfo;
        this.sd = sd;
    }

    public JPAAssociationPath getAssociationPath() {
        return this.associationPath;
    }

    public UriResourcePartTyped getUriResiource() {
        return this.navigationTarget;
    }

    public void setAssociationPath(JPAAssociationPath associationPath) {
        assert (this.associationPath == null);
        this.associationPath = associationPath;
    }

    JPAEntityType getEntityType() throws ODataJPAModelException {
        if (this.et != null) {
            return this.et;
        }
        return this.sd.getEntity(this.getUriResiource().getType());
    }

    JPAFilterComplier getFilterCompiler() {
        return this.filterCompiler;
    }

    From<?, ?> getFromClause() {
        return this.fromClause;
    }

    List<UriParameter> getKeyPredicates() {
        return this.keyPredicates;
    }

    UriInfoResource getUriInfo() {
        return this.uriInfo;
    }

    void setFilterCompiler(JPAFilterComplier filterCompiler) {
        assert (this.filterCompiler == null);
        this.filterCompiler = filterCompiler;
    }

    void setFromClause(From<?, ?> from) {
        assert (this.fromClause == null);
        this.fromClause = from;
    }

    private JPAServiceDocument getServiceDocument() {
        return this.sd;
    }
}

