/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAOnConditionItem;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.api.JPAODataClaimProvider;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterElementComplier;
import com.sap.olingo.jpa.processor.core.filter.JPAFilterExpression;
import com.sap.olingo.jpa.processor.core.filter.JPAMemberOperator;
import com.sap.olingo.jpa.processor.core.query.JPAAbstractQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Subquery;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Binary;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.VisitableExpression;

public abstract class JPANavigationQuery
extends JPAAbstractQuery {
    protected From<?, ?> queryJoinTable = null;
    protected Subquery<?> subQuery;
    protected final JPAAbstractQuery parentQuery;
    protected UriResourceKind aggregationType;
    protected From<?, ?> queryRoot = null;
    protected final From<?, ?> from;
    protected final JPAAssociationPath association;
    protected JPAFilterElementComplier filterComplier;

    public JPANavigationQuery(OData odata, JPAServiceDocument sd, EdmEntityType edmEntityType, EntityManager em, JPAAbstractQuery parent, From<?, ?> from, JPAAssociationPath association, Optional<JPAODataClaimProvider> claimsProvider) throws ODataApplicationException {
        super(odata, sd, edmEntityType, em, claimsProvider);
        this.parentQuery = parent;
        this.from = from;
        this.association = association;
    }

    public JPANavigationQuery(OData odata, JPAServiceDocument sd, JPAEntityType jpaEntity, EntityManager em, JPAAbstractQuery parent, From<?, ?> from, JPAAssociationPath association) {
        super(odata, sd, jpaEntity, em, Optional.empty());
        this.parentQuery = parent;
        this.from = from;
        this.association = association;
    }

    public abstract <T> Subquery<T> getSubQueryExists(Subquery<?> var1) throws ODataApplicationException;

    @Override
    public AbstractQuery<?> getQuery() {
        return this.subQuery;
    }

    @Override
    protected Locale getLocale() {
        return this.locale;
    }

    @Override
    JPAODataCRUDContextAccess getContext() {
        return this.parentQuery.getContext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createRoots(JPAAssociationPath association) throws ODataJPAQueryException {
        if (association.getJoinTable() != null) {
            if (association.getJoinTable().getEntityType() == null) throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_NOT_IMPLEMENTED, HttpStatusCode.NOT_IMPLEMENTED, association.getAlias());
            if (this.aggregationType != null) {
                this.queryJoinTable = this.subQuery.from(this.from.getJavaType());
                Join p = this.queryJoinTable;
                for (int i = 0; i < association.getPath().size() - 1; ++i) {
                    p = p.join(((JPAElement)association.getPath().get(i)).getInternalName());
                }
                this.queryRoot = p.join(association.getLeaf().getInternalName(), JoinType.LEFT);
                return;
            } else {
                this.queryRoot = this.subQuery.from(this.jpaEntity.getTypeClass());
                this.queryJoinTable = this.subQuery.from(association.getJoinTable().getEntityType().getTypeClass());
            }
            return;
        } else {
            this.queryRoot = this.subQuery.from(this.jpaEntity.getTypeClass());
        }
    }

    protected <T> void createSelectClause(Subquery<T> subQuery, From<?, ?> from, List<JPAOnConditionItem> conditionItems) {
        Path p = from;
        for (JPAElement jpaPathElement : conditionItems.get(0).getRightPath().getPath()) {
            p = p.get(jpaPathElement.getInternalName());
        }
        subQuery.select(p);
    }

    protected Expression<Boolean> createWhereByAssociation(From<?, ?> subRoot, From<?, ?> parentFrom, List<JPAOnConditionItem> conditionItems) {
        Predicate whereCondition = null;
        for (JPAOnConditionItem onItem : conditionItems) {
            Path paretPath = parentFrom;
            Path subPath = subRoot;
            for (JPAElement jpaPathElement : onItem.getRightPath().getPath()) {
                paretPath = paretPath.get(jpaPathElement.getInternalName());
            }
            for (JPAElement jpaPathElement : onItem.getLeftPath().getPath()) {
                subPath = subPath.get(jpaPathElement.getInternalName());
            }
            Predicate equalCondition = this.cb.equal((Expression)paretPath, subPath);
            if (whereCondition == null) {
                whereCondition = equalCondition;
                continue;
            }
            whereCondition = this.cb.and((Expression)whereCondition, (Expression)equalCondition);
        }
        return whereCondition;
    }

    protected Expression<Boolean> applyAdditionalFilter(Expression<Boolean> where) throws ODataApplicationException {
        Expression<Boolean> whereCondition = where;
        if (this.filterComplier != null && this.aggregationType == null) {
            try {
                if (this.filterComplier.getExpressionMember() != null) {
                    whereCondition = this.addWhereClause(whereCondition, this.filterComplier.compile());
                }
            }
            catch (ExpressionVisitException e) {
                throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        }
        return whereCondition;
    }

    protected void createSubQueryJoinTable() throws ODataApplicationException {
        try {
            List left = this.association.getJoinTable().getJoinColumns();
            List right = this.association.getJoinTable().getInversJoinColumns();
            this.createSelectClause(this.subQuery, this.queryRoot, right);
            Predicate whereCondition = this.createWhereByAssociation(this.from, this.queryJoinTable, left);
            whereCondition = this.cb.and(whereCondition, this.createWhereByAssociation(this.queryJoinTable, this.queryRoot, right));
            this.subQuery.where(this.applyAdditionalFilter((Expression<Boolean>)whereCondition));
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    protected Expression<Boolean> createWhereByAssociation(From<?, ?> subRoot, From<?, ?> parentFrom, JPAEntityType jpaEntity) throws ODataJPAModelException {
        Expression<Boolean> whereCondition = null;
        for (JPAPath onItem : jpaEntity.getKeyPath()) {
            Path paretPath = parentFrom;
            Path subPath = subRoot;
            for (JPAElement jpaPathElement : onItem.getPath()) {
                paretPath = paretPath.get(jpaPathElement.getInternalName());
                subPath = subPath.get(jpaPathElement.getInternalName());
            }
            Predicate equalCondition = this.cb.equal(paretPath, subPath);
            whereCondition = this.addWhereClause(whereCondition, (Expression<Boolean>)equalCondition);
        }
        return whereCondition;
    }

    protected <T> void createSelectClauseAggregation(Subquery<T> subQuery, From<?, ?> from, List<JPAOnConditionItem> conditionItems) {
        Path p = from;
        for (JPAElement jpaPathElement : conditionItems.get(0).getLeftPath().getPath()) {
            p = p.get(jpaPathElement.getInternalName());
        }
        subQuery.select(p);
    }

    protected void handleAggregation(Subquery<?> subQuery, From<?, ?> subRoot, List<JPAOnConditionItem> conditionItems) throws ODataApplicationException {
        ArrayList<Path> groupByLIst = new ArrayList<Path>();
        if (this.filterComplier != null && this.aggregationType != null) {
            for (JPAOnConditionItem onItem : conditionItems) {
                Path subPath = subRoot;
                for (JPAElement jpaPathElement : onItem.getRightPath().getPath()) {
                    subPath = subPath.get(jpaPathElement.getInternalName());
                }
                groupByLIst.add(subPath);
            }
            subQuery.groupBy(groupByLIst);
            try {
                subQuery.having(this.filterComplier.compile());
            }
            catch (ExpressionVisitException e) {
                throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
        }
    }

    protected void createSubQueryJoinTableAggregation() throws ODataApplicationException {
        try {
            List left = this.association.getJoinTable().getJoinColumns();
            List right = this.association.getJoinTable().getInversJoinColumns();
            this.createSelectClauseAggregation(this.subQuery, this.queryJoinTable, left);
            Expression<Boolean> whereCondition = this.createWhereByAssociation(this.from, this.queryJoinTable, this.parentQuery.jpaEntity);
            this.subQuery.where(this.applyAdditionalFilter(whereCondition));
            this.handleAggregation(this.subQuery, this.queryJoinTable, right);
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    protected UriResourceKind getAggregationType(VisitableExpression expression) {
        UriInfoResource member = null;
        if (expression instanceof Binary) {
            if (((Binary)expression).getLeftOperand() instanceof JPAMemberOperator) {
                member = ((JPAMemberOperator)((Binary)expression).getLeftOperand()).getMember().getResourcePath();
            } else if (((Binary)expression).getRightOperand() instanceof JPAMemberOperator) {
                member = ((JPAMemberOperator)((Binary)expression).getRightOperand()).getMember().getResourcePath();
            }
        } else if (expression instanceof JPAFilterExpression) {
            member = ((JPAFilterExpression)expression).getMember();
        }
        if (member != null) {
            for (UriResource r : member.getUriResourceParts()) {
                if (r.getKind() != UriResourceKind.count) continue;
                return r.getKind();
            }
        }
        return null;
    }
}

