/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAElement;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPANotImplementedException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAProcessorException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;

class JPAOrderByBuilder {
    private final JPAEntityType jpaEntity;
    private final From<?, ?> target;
    private final CriteriaBuilder cb;
    private final List<String> groups;

    JPAOrderByBuilder(JPAEntityType jpaEntity, From<?, ?> target, CriteriaBuilder cb, List<String> groups) {
        this.jpaEntity = jpaEntity;
        this.target = target;
        this.cb = cb;
        this.groups = groups;
    }

    @Nonnull
    List<Order> createOrderByList(@Nonnull Map<String, From<?, ?>> joinTables, @Nonnull UriInfoResource uriResource) throws ODataApplicationException {
        ArrayList<Order> result = new ArrayList<Order>();
        try {
            if (uriResource.getOrderByOption() != null) {
                this.addOrderByFromUriResource(joinTables, result, uriResource.getOrderByOption());
            }
            if (uriResource.getTopOption() != null || uriResource.getSkipOption() != null) {
                this.addOrderByPrimaryKey(result);
            }
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.BAD_REQUEST);
        }
        return result;
    }

    @Nonnull
    List<Order> createOrderByList(Map<String, From<?, ?>> joinTables) {
        return Collections.emptyList();
    }

    private void addOrderByExpression(List<Order> orders, OrderByItem orderByItem, Expression<?> expression) {
        if (orderByItem.isDescending()) {
            orders.add(this.cb.desc(expression));
        } else {
            orders.add(this.cb.asc(expression));
        }
    }

    private void addOrderByFromUriResource(Map<String, From<?, ?>> joinTables, List<Order> orders, OrderByOption orderByOption) throws ODataJPAProcessException, ODataJPAModelException {
        for (OrderByItem orderByItem : orderByOption.getOrders()) {
            org.apache.olingo.server.api.uri.queryoption.expression.Expression expression = orderByItem.getExpression();
            if (!(expression instanceof Member)) continue;
            UriInfoResource resourcePath = ((Member)expression).getResourcePath();
            JPAEntityType type = this.jpaEntity;
            Path p = this.target;
            StringBuilder externalPath = new StringBuilder();
            for (UriResource uriResourceItem : resourcePath.getUriResourceParts()) {
                if (this.isPrimitiveSimpleProperty(uriResourceItem)) {
                    p = this.convertPropertyPath((JPAStructuredType)type, uriResourceItem, p);
                    this.addOrderByExpression(orders, orderByItem, (Expression<?>)p);
                    continue;
                }
                if (this.isComplexSimpleProperty(uriResourceItem)) {
                    JPAAttribute attribute = this.getAttribute((JPAStructuredType)type, uriResourceItem);
                    this.addPathByAttribute(externalPath, attribute);
                    p = p.get(attribute.getInternalName());
                    type = attribute.getStructuredType();
                    continue;
                }
                if (uriResourceItem instanceof UriResourceNavigation || uriResourceItem instanceof UriResourceProperty && ((UriResourceProperty)uriResourceItem).isCollection()) {
                    this.appendPathByCollection(externalPath, uriResourceItem);
                    From<?, ?> join = joinTables.get(externalPath.toString());
                    this.addOrderByExpression(orders, orderByItem, this.cb.count(join));
                    continue;
                }
                if (uriResourceItem instanceof UriResourceCount) continue;
                throw new ODataJPANotImplementedException("orderby using " + uriResourceItem.getKind().name());
            }
        }
    }

    private Path<?> convertPropertyPath(JPAStructuredType type, UriResource uriResourceItem, Path<?> p) throws ODataJPAQueryException, ODataJPAProcessorException, ODataJPAModelException {
        JPAPath attributePath = type.getPath(((UriResourceProperty)uriResourceItem).getProperty().getName());
        if (attributePath == null) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.ATTRIBUTE_NOT_FOUND, HttpStatusCode.INTERNAL_SERVER_ERROR, uriResourceItem.getSegmentValue());
        }
        if (!attributePath.isPartOfGroups(this.groups)) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_NOT_ALLOWED_MEMBER, HttpStatusCode.FORBIDDEN, attributePath.getAlias());
        }
        Path path = p;
        for (JPAElement pathElement : attributePath.getPath()) {
            path = path.get(pathElement.getInternalName());
        }
        return path;
    }

    private void addOrderByPrimaryKey(List<Order> orders) throws ODataJPAModelException {
        for (JPAPath keyPath : this.jpaEntity.getKeyPath()) {
            From<?, ?> p = this.target;
            for (JPAElement pathElement : keyPath.getPath()) {
                p.get(pathElement.getInternalName());
            }
            orders.add(this.cb.asc(p));
        }
    }

    private void addPathByAttribute(StringBuilder externalPath, JPAAttribute attribute) {
        externalPath.append(attribute.getExternalName());
        externalPath.append("/");
    }

    private void appendPathByCollection(StringBuilder externalPath, UriResource uriResourceItem) {
        if (uriResourceItem instanceof UriResourceNavigation) {
            externalPath.append(((UriResourceNavigation)uriResourceItem).getProperty().getName());
        } else {
            externalPath.append(((UriResourceProperty)uriResourceItem).getProperty().getName());
        }
    }

    private JPAAttribute getAttribute(JPAStructuredType type, UriResource uriResourceItem) throws ODataJPAProcessorException, ODataJPAModelException, ODataJPAQueryException {
        JPAAttribute attribute = type.getAttribute((UriResourceProperty)uriResourceItem);
        if (attribute == null) {
            throw new ODataJPAProcessorException(ODataJPAProcessorException.MessageKeys.ATTRIBUTE_NOT_FOUND, HttpStatusCode.INTERNAL_SERVER_ERROR, uriResourceItem.getSegmentValue());
        }
        return attribute;
    }

    private boolean isComplexSimpleProperty(UriResource uriResourceItem) {
        return uriResourceItem instanceof UriResourceComplexProperty && !((UriResourceProperty)uriResourceItem).isCollection();
    }

    private boolean isPrimitiveSimpleProperty(UriResource uriResourceItem) {
        return uriResourceItem instanceof UriResourcePrimitiveProperty && !((UriResourceProperty)uriResourceItem).isCollection();
    }
}

