/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAStructuredType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;

class SelectOptionUtil {
    private SelectOptionUtil() {
    }

    public static JPAPath selectItemAsPath(JPAStructuredType jpaEntity, String pathPrefix, SelectItem sItem) throws ODataJPAQueryException {
        try {
            String pathItem = sItem.getResourcePath().getUriResourceParts().stream().map(path -> path.getSegmentValue()).collect(Collectors.joining("/"));
            JPAPath selectItemPath = jpaEntity.getPath((String)(pathPrefix.isEmpty() ? pathItem : pathPrefix + "/" + pathItem));
            if (selectItemPath == null) {
                throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.QUERY_PREPARATION_INVALID_SELECTION_PATH, HttpStatusCode.BAD_REQUEST);
            }
            return selectItemPath;
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAQueryException(e, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    public static boolean selectAll(SelectOption select) {
        return select == null || select.getSelectItems() == null || select.getSelectItems().isEmpty() || ((SelectItem)select.getSelectItems().get(0)).isStar();
    }
}

