/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.query;

import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAAssociationPath;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPACollectionAttribute;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAEntityType;
import com.sap.olingo.jpa.metadata.core.edm.mapper.api.JPAServiceDocument;
import com.sap.olingo.jpa.metadata.core.edm.mapper.exception.ODataJPAModelException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAQueryException;
import com.sap.olingo.jpa.processor.core.exception.ODataJPAUtilException;
import com.sap.olingo.jpa.processor.core.query.EdmEntitySetInfo;
import com.sap.olingo.jpa.processor.core.query.EdmEntitySetResult;
import com.sap.olingo.jpa.processor.core.query.JPAExpandItem;
import com.sap.olingo.jpa.processor.core.query.JPAExpandItemWrapper;
import com.sap.olingo.jpa.processor.core.query.JPAExpandLevelWrapper;
import com.sap.olingo.jpa.processor.core.query.JPANavigationProptertyInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceLambdaVariable;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.UriResourceValue;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;

public final class Util {
    public static final String VALUE_RESOURCE = "$VALUE";

    private Util() {
    }

    public static EdmEntitySet determineTargetEntitySet(List<UriResource> resources) {
        return Util.determineTargetEntitySetAndKeys(resources).getEdmEntitySet();
    }

    public static EdmEntitySetInfo determineTargetEntitySetAndKeys(List<UriResource> resources) {
        EdmEntitySet targetEdmEntitySet = null;
        List<Object> targteKeyPredicates = new ArrayList<UriParameter>();
        StringBuilder naviPropertyName = new StringBuilder();
        for (UriResource resourceItem : resources) {
            if (resourceItem.getKind() == UriResourceKind.entitySet) {
                targetEdmEntitySet = ((UriResourceEntitySet)resourceItem).getEntitySet();
                targteKeyPredicates = ((UriResourceEntitySet)resourceItem).getKeyPredicates();
            }
            if (resourceItem.getKind() == UriResourceKind.complexProperty) {
                naviPropertyName.append(((UriResourceComplexProperty)resourceItem).getProperty().getName());
                naviPropertyName.append("/");
            }
            if (resourceItem.getKind() != UriResourceKind.navigationProperty) continue;
            naviPropertyName.append(((UriResourceNavigation)resourceItem).getProperty().getName());
            targteKeyPredicates = ((UriResourceNavigation)resourceItem).getKeyPredicates();
            EdmBindingTarget edmBindingTarget = targetEdmEntitySet.getRelatedBindingTarget(naviPropertyName.toString());
            if (edmBindingTarget instanceof EdmEntitySet) {
                targetEdmEntitySet = (EdmEntitySet)edmBindingTarget;
            }
            naviPropertyName = new StringBuilder();
        }
        return new EdmEntitySetResult(targetEdmEntitySet, targteKeyPredicates, naviPropertyName.toString());
    }

    public static EdmEntitySetInfo determineModifyEntitySetAndKeys(List<UriResource> resources) {
        EdmEntitySet targetEdmEntitySet = null;
        List<Object> targteKeyPredicates = new ArrayList<UriParameter>();
        StringBuilder naviPropertyName = new StringBuilder();
        for (UriResource resourceItem : resources) {
            if (resourceItem.getKind() == UriResourceKind.entitySet) {
                targetEdmEntitySet = ((UriResourceEntitySet)resourceItem).getEntitySet();
                targteKeyPredicates = ((UriResourceEntitySet)resourceItem).getKeyPredicates();
            }
            if (resourceItem.getKind() == UriResourceKind.complexProperty) {
                naviPropertyName.append(((UriResourceComplexProperty)resourceItem).getProperty().getName());
                naviPropertyName.append("/");
            }
            if (resourceItem.getKind() != UriResourceKind.navigationProperty) continue;
            naviPropertyName.append(((UriResourceNavigation)resourceItem).getProperty().getName());
            List keyPredicates = ((UriResourceNavigation)resourceItem).getKeyPredicates();
            if (keyPredicates.isEmpty()) continue;
            targteKeyPredicates = keyPredicates;
            EdmBindingTarget edmBindingTarget = targetEdmEntitySet.getRelatedBindingTarget(naviPropertyName.toString());
            if (edmBindingTarget instanceof EdmEntitySet) {
                targetEdmEntitySet = (EdmEntitySet)edmBindingTarget;
            }
            naviPropertyName = new StringBuilder();
        }
        return new EdmEntitySetResult(targetEdmEntitySet, targteKeyPredicates, naviPropertyName.toString());
    }

    public static EdmEntityType determineTargetEntityType(List<UriResource> resources) {
        EdmEntityType targetEdmEntity = null;
        for (UriResource resourceItem : resources) {
            if (resourceItem.getKind() != UriResourceKind.navigationProperty) continue;
            targetEdmEntity = (EdmEntityType)((UriResourceNavigation)resourceItem).getType();
        }
        return targetEdmEntity;
    }

    public static UriResourceProperty determineStartNavigationPath(List<UriResource> resources) {
        int index = Util.determineStartNavigationIndex(resources);
        if (index >= 0 && resources != null) {
            return (UriResourceProperty)resources.get(index);
        }
        return null;
    }

    public static int determineStartNavigationIndex(List<UriResource> resources) {
        if (resources != null) {
            for (int i = resources.size() - 1; i >= 0; --i) {
                UriResource resourceItem = resources.get(i);
                if (!(resourceItem instanceof UriResourceEntitySet) && !(resourceItem instanceof UriResourceNavigation)) continue;
                return i == resources.size() ? -1 : i + 1;
            }
        }
        return -1;
    }

    public static String determineProptertyNavigationPath(List<UriResource> resources) {
        StringBuilder pathName = new StringBuilder();
        if (resources != null) {
            UriResource resourceItem;
            for (int i = resources.size() - 1; !(i < 0 || (resourceItem = resources.get(i)) instanceof UriResourceEntitySet || resourceItem instanceof UriResourceNavigation || resourceItem instanceof UriResourceLambdaVariable); --i) {
                if (resourceItem instanceof UriResourceValue) {
                    pathName.insert(0, VALUE_RESOURCE);
                    pathName.insert(0, "/");
                    continue;
                }
                if (!(resourceItem instanceof UriResourceProperty)) continue;
                UriResourceProperty property = (UriResourceProperty)resourceItem;
                pathName.insert(0, property.getProperty().getName());
                pathName.insert(0, "/");
            }
            if (pathName.length() > 0) {
                pathName.deleteCharAt(0);
            }
        }
        return pathName.toString();
    }

    public static String determineProptertyNavigationPrefix(List<UriResource> resources) {
        return Util.determineProptertyNavigationPath(resources).split("/\\$VALUE")[0];
    }

    public static JPAAssociationPath determineAssoziation(JPAServiceDocument sd, EdmType naviStart, StringBuilder associationName) throws ODataApplicationException {
        try {
            JPAEntityType naviStartType = sd.getEntity(naviStart);
            return naviStartType.getAssociationPath(associationName.toString());
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAUtilException(ODataJPAUtilException.MessageKeys.UNKNOWN_NAVI_PROPERTY, HttpStatusCode.BAD_REQUEST);
        }
    }

    public static Map<JPAExpandItem, JPAAssociationPath> determineAssoziations(JPAServiceDocument sd, List<UriResource> startResourceList, ExpandOption expandOption) throws ODataApplicationException {
        HashMap<JPAExpandItem, JPAAssociationPath> pathList = new HashMap<JPAExpandItem, JPAAssociationPath>();
        StringBuilder associationNamePrefix = new StringBuilder();
        UriResource startResourceItem = null;
        if (startResourceList != null && expandOption != null) {
            for (int i = startResourceList.size() - 1; i >= 0 && !((startResourceItem = startResourceList.get(i)) instanceof UriResourceEntitySet) && !(startResourceItem instanceof UriResourceNavigation); --i) {
                associationNamePrefix.insert(0, "/");
                associationNamePrefix.insert(0, ((UriResourceProperty)startResourceItem).getProperty().getName());
            }
            for (ExpandItem item : expandOption.getExpandItems()) {
                if (item.isStar()) {
                    EdmEntitySet edmEntitySet = Util.determineTargetEntitySet(startResourceList);
                    try {
                        JPAEntityType jpaEntityType = sd.getEntity(edmEntitySet.getName());
                        List associationPaths = jpaEntityType.getAssociationPathList();
                        for (JPAAssociationPath path : associationPaths) {
                            pathList.put(new JPAExpandItemWrapper(item, (JPAEntityType)path.getTargetType()), path);
                        }
                        continue;
                    }
                    catch (ODataJPAModelException e) {
                        throw new ODataJPAUtilException(ODataJPAUtilException.MessageKeys.UNKNOWN_ENTITY_TYPE, HttpStatusCode.BAD_REQUEST);
                    }
                }
                List targetResourceList = item.getResourcePath().getUriResourceParts();
                StringBuilder associationName = new StringBuilder();
                associationName.append((CharSequence)associationNamePrefix);
                UriResource targetResourceItem = null;
                for (int i = 0; i < targetResourceList.size(); ++i) {
                    targetResourceItem = (UriResource)targetResourceList.get(i);
                    if (targetResourceItem.getKind() == UriResourceKind.navigationProperty) {
                        associationName.append(((UriResourceNavigation)targetResourceItem).getProperty().getName());
                        break;
                    }
                    associationName.append(((UriResourceProperty)targetResourceItem).getProperty().getName());
                    associationName.append("/");
                }
                if (item.getLevelsOption() != null) {
                    pathList.put(new JPAExpandLevelWrapper(sd, expandOption), Util.determineAssoziation(sd, ((UriResourcePartTyped)startResourceItem).getType(), associationName));
                    continue;
                }
                pathList.put(new JPAExpandItemWrapper(sd, item), Util.determineAssoziation(sd, ((UriResourcePartTyped)startResourceItem).getType(), associationName));
            }
        }
        return pathList;
    }

    public static List<JPANavigationProptertyInfo> determineNavigationPath(JPAServiceDocument sd, List<UriResource> resourceParts, UriInfoResource uriInfo) throws ODataApplicationException {
        ArrayList<JPANavigationProptertyInfo> pathList = new ArrayList<JPANavigationProptertyInfo>();
        StringBuilder associationName = null;
        UriResourcePartTyped source = null;
        for (UriResource resourcePart : resourceParts) {
            if (resourcePart instanceof UriResourceNavigation || resourcePart instanceof UriResourceEntitySet) {
                if (source != null) {
                    if (resourcePart instanceof UriResourceProperty) {
                        Util.extendNavigationPath(associationName, ((UriResourceProperty)resourcePart).getProperty().getName());
                    } else {
                        Util.extendNavigationPath(associationName, ((UriResourceNavigation)resourcePart).getProperty().getName());
                    }
                    pathList.add(new JPANavigationProptertyInfo(sd, source, Util.determineAssoziationPath(sd, source, associationName), null));
                }
                source = (UriResourcePartTyped)resourcePart;
                associationName = new StringBuilder();
                continue;
            }
            if (!(resourcePart instanceof UriResourceComplexProperty) && (!(resourcePart instanceof UriResourceProperty) || !((UriResourceProperty)resourcePart).isCollection()) || associationName == null) continue;
            Util.extendNavigationPath(associationName, ((UriResourceProperty)resourcePart).getProperty().getName());
        }
        if (source != null) {
            pathList.add(new JPANavigationProptertyInfo(sd, source, Util.determineAssoziationPath(sd, source, associationName), uriInfo));
        }
        return pathList;
    }

    private static void extendNavigationPath(StringBuilder associationName, String pathSegment) throws ODataJPAQueryException {
        if (associationName == null) {
            throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.NOT_SUPPORTED_RESOURCE_TYPE, HttpStatusCode.NOT_IMPLEMENTED, "");
        }
        if (associationName.length() > 0) {
            associationName.append("/");
        }
        associationName.append(pathSegment);
    }

    public static boolean hasNavigation(List<UriResource> uriResourceParts) {
        if (uriResourceParts != null) {
            for (int i = uriResourceParts.size() - 1; i >= 0; --i) {
                if (!(uriResourceParts.get(i) instanceof UriResourceNavigation)) continue;
                return true;
            }
        }
        return false;
    }

    public static JPAAssociationPath determineAssoziationPath(JPAServiceDocument sd, UriResourcePartTyped naviStart, StringBuilder associationName) throws ODataApplicationException {
        JPAEntityType naviStartType = null;
        try {
            JPACollectionAttribute collcetion;
            JPAAssociationPath path;
            if (naviStart instanceof UriResourceEntitySet) {
                naviStartType = ((UriResourceEntitySet)naviStart).getTypeFilterOnEntry() != null ? sd.getEntity(((UriResourceEntitySet)naviStart).getTypeFilterOnEntry()) : sd.getEntity(((UriResourceEntitySet)naviStart).getType());
            } else if (naviStart instanceof UriResourceNavigation) {
                naviStartType = ((UriResourceNavigation)naviStart).getTypeFilterOnEntry() != null ? sd.getEntity(((UriResourceNavigation)naviStart).getTypeFilterOnEntry()) : sd.getEntity((EdmType)((UriResourceNavigation)naviStart).getProperty().getType());
            }
            JPAAssociationPath jPAAssociationPath = path = naviStartType == null ? null : naviStartType.getAssociationPath(associationName.toString());
            if (path == null && naviStartType != null && (collcetion = naviStartType.getCollectionAttribute(associationName.toString())) != null) {
                path = collcetion.asAssociation();
            }
            return path;
        }
        catch (ODataJPAModelException e) {
            throw new ODataJPAUtilException(ODataJPAUtilException.MessageKeys.UNKNOWN_NAVI_PROPERTY, HttpStatusCode.BAD_REQUEST);
        }
    }

    public static List<UriParameter> determineKeyPredicates(UriResource uriResourceItem) throws ODataApplicationException {
        if (uriResourceItem instanceof UriResourceEntitySet) {
            return ((UriResourceEntitySet)uriResourceItem).getKeyPredicates();
        }
        if (uriResourceItem instanceof UriResourceNavigation) {
            return ((UriResourceNavigation)uriResourceItem).getKeyPredicates();
        }
        throw new ODataJPAQueryException(ODataJPAQueryException.MessageKeys.NOT_SUPPORTED_RESOURCE_TYPE, HttpStatusCode.BAD_REQUEST, uriResourceItem.getKind().name());
    }
}

