/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.query.Util;
import com.sap.olingo.jpa.processor.core.serializer.JPAOperationSerializer;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourceProperty;

public final class JPASerializeComplex
implements JPAOperationSerializer {
    private final ServiceMetadata serviceMetadata;
    private final UriInfo uriInfo;
    private final UriHelper uriHelper;
    private final ODataSerializer serializer;
    private final ContentType responseFormat;
    private final JPAODataCRUDContextAccess serviceContext;

    JPASerializeComplex(ServiceMetadata serviceMetadata, ODataSerializer serializer, UriHelper uriHelper, UriInfo uriInfo, ContentType responseFormat, JPAODataCRUDContextAccess serviceContext) {
        this.uriInfo = uriInfo;
        this.serializer = serializer;
        this.serviceMetadata = serviceMetadata;
        this.uriHelper = uriHelper;
        this.responseFormat = responseFormat;
        this.serviceContext = serviceContext;
    }

    @Override
    public ContentType getContentType() {
        return this.responseFormat;
    }

    @Override
    public SerializerResult serialize(Annotatable result, EdmType complexType, ODataRequest request) throws SerializerException, ODataJPASerializerException {
        try {
            ContextURL contextUrl = ContextURL.with().serviceRoot(this.buildServiceRoot(request, this.serviceContext)).build();
            ComplexSerializerOptions options = ComplexSerializerOptions.with().contextURL(contextUrl).build();
            return this.serializer.complex(this.serviceMetadata, (EdmComplexType)complexType, (Property)result, options);
        }
        catch (URISyntaxException e) {
            throw new ODataJPASerializerException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    @Override
    public SerializerResult serialize(ODataRequest request, EntityCollection result) throws SerializerException, ODataJPASerializerException {
        EdmEntitySet targetEdmEntitySet = Util.determineTargetEntitySet(this.uriInfo.getUriResourceParts());
        List resourceParts = this.uriInfo.getUriResourceParts();
        UriResourceProperty uriProperty = (UriResourceProperty)resourceParts.get(resourceParts.size() - 1);
        EdmComplexType edmPropertyType = ((UriResourceComplexProperty)uriProperty).getComplexType();
        String selectList = this.uriHelper.buildContextURLSelectList((EdmStructuredType)targetEdmEntitySet.getEntityType(), this.uriInfo.getExpandOption(), this.uriInfo.getSelectOption());
        try {
            ContextURL contextUrl = ContextURL.with().serviceRoot(this.buildServiceRoot(request, this.serviceContext)).entitySet(targetEdmEntitySet).navOrPropertyPath(Util.determineProptertyNavigationPath(this.uriInfo.getUriResourceParts())).selectList(selectList).build();
            ComplexSerializerOptions options = ComplexSerializerOptions.with().contextURL(contextUrl).select(this.uriInfo.getSelectOption()).expand(this.uriInfo.getExpandOption()).build();
            if (uriProperty.getProperty().isCollection()) {
                return this.serializer.complexCollection(this.serviceMetadata, edmPropertyType, this.determineProperty(targetEdmEntitySet, result), options);
            }
            return this.serializer.complex(this.serviceMetadata, edmPropertyType, this.determineProperty(targetEdmEntitySet, result), options);
        }
        catch (URISyntaxException e) {
            throw new ODataJPASerializerException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    private Property determineProperty(EdmEntitySet targetEdmEntitySet, EntityCollection result) {
        UriResourceProperty uriProperty = null;
        Property property = null;
        boolean found = false;
        List properties = ((Entity)result.getEntities().get(0)).getProperties();
        for (UriResource hop : this.uriInfo.getUriResourceParts()) {
            if (hop.getKind().equals((Object)UriResourceKind.entitySet) && ((UriResourceEntitySet)hop).getEntitySet() == targetEdmEntitySet || hop.getKind().equals((Object)UriResourceKind.navigationProperty) && ((UriResourceNavigation)hop).getType() == targetEdmEntitySet.getEntityType()) {
                found = true;
            }
            if (!found || !hop.getKind().equals((Object)UriResourceKind.complexProperty)) continue;
            uriProperty = (UriResourceProperty)hop;
            property = this.getProperty(uriProperty.getProperty().getName(), properties);
            if (uriProperty.isCollection() || property == null) continue;
            properties = ((ComplexValue)property.getValue()).getValue();
        }
        return property;
    }

    private Property getProperty(String name, List<Property> properties) {
        for (Property p : properties) {
            if (!p.getName().equals(name) || !p.isComplex()) continue;
            return p;
        }
        return null;
    }
}

