/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.serializer.JPAOperationSerializer;
import java.net.URISyntaxException;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;

public class JPASerializeComplexCollection
implements JPAOperationSerializer {
    private final ServiceMetadata serviceMetadata;
    private final ODataSerializer serializer;
    private final ContentType responseFormat;
    private final JPAODataCRUDContextAccess serviceContext;

    JPASerializeComplexCollection(ServiceMetadata serviceMetadata, ODataSerializer serializer, ContentType responseFormat, JPAODataCRUDContextAccess context) {
        this.serializer = serializer;
        this.serviceMetadata = serviceMetadata;
        this.responseFormat = responseFormat;
        this.serviceContext = context;
    }

    @Override
    public ContentType getContentType() {
        return this.responseFormat;
    }

    @Override
    public SerializerResult serialize(Annotatable result, EdmType complexType, ODataRequest request) throws SerializerException, ODataJPASerializerException {
        try {
            ContextURL contextUrl = ContextURL.with().serviceRoot(this.buildServiceRoot(request, this.serviceContext)).asCollection().build();
            ComplexSerializerOptions options = ComplexSerializerOptions.with().contextURL(contextUrl).build();
            return this.serializer.complexCollection(this.serviceMetadata, (EdmComplexType)complexType, (Property)result, options);
        }
        catch (URISyntaxException e) {
            throw new ODataJPASerializerException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    @Override
    public SerializerResult serialize(ODataRequest request, EntityCollection result) throws SerializerException, ODataJPASerializerException {
        return null;
    }
}

