/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.query.Util;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.LevelsExpandOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.api.uri.queryoption.TopOption;

final class JPASerializeCreate
implements JPASerializer {
    private final ServiceMetadata serviceMetadata;
    private final UriInfo uriInfo;
    private final ODataSerializer serializer;
    private final JPAODataCRUDContextAccess serviceContext;

    public JPASerializeCreate(ServiceMetadata serviceMetadata, ODataSerializer serializer, UriInfo uriInfo, JPAODataCRUDContextAccess serviceContext) {
        this.uriInfo = uriInfo;
        this.serializer = serializer;
        this.serviceMetadata = serviceMetadata;
        this.serviceContext = serviceContext;
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public SerializerResult serialize(ODataRequest request, EntityCollection result) throws SerializerException, ODataJPASerializerException {
        ExpandOptionWrapper expandOption = new ExpandOptionWrapper(new ExpandItemWrapper());
        EdmEntitySet targetEdmEntitySet = Util.determineTargetEntitySet(this.uriInfo.getUriResourceParts());
        EdmEntityType entityType = targetEdmEntitySet.getEntityType();
        try {
            ContextURL contextUrl = ContextURL.with().serviceRoot(this.buildServiceRoot(request, this.serviceContext)).entitySet(targetEdmEntitySet).build();
            EntitySerializerOptions options = EntitySerializerOptions.with().contextURL(contextUrl).expand((ExpandOption)expandOption).build();
            return this.serializer.entity(this.serviceMetadata, entityType, (Entity)result.getEntities().get(0), options);
        }
        catch (URISyntaxException e) {
            throw new ODataJPASerializerException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    private class ExpandOptionWrapper
    implements ExpandOption {
        private final List<ExpandItem> items = new ArrayList<ExpandItem>(1);

        public ExpandOptionWrapper(ExpandItemWrapper expandItemWrapper) {
            this.items.add(expandItemWrapper);
        }

        public List<ExpandItem> getExpandItems() {
            return this.items;
        }

        public SystemQueryOptionKind getKind() {
            return SystemQueryOptionKind.EXPAND;
        }

        public String getName() {
            return null;
        }

        public String getText() {
            return null;
        }
    }

    private class ExpandItemWrapper
    implements ExpandItem {
        private ExpandItemWrapper() {
        }

        public ApplyOption getApplyOption() {
            return null;
        }

        public CountOption getCountOption() {
            return null;
        }

        public ExpandOption getExpandOption() {
            return null;
        }

        public FilterOption getFilterOption() {
            return null;
        }

        public LevelsExpandOption getLevelsOption() {
            return null;
        }

        public OrderByOption getOrderByOption() {
            return null;
        }

        public UriInfoResource getResourcePath() {
            return null;
        }

        public SearchOption getSearchOption() {
            return null;
        }

        public SelectOption getSelectOption() {
            return null;
        }

        public SkipOption getSkipOption() {
            return null;
        }

        public EdmType getStartTypeFilter() {
            return null;
        }

        public TopOption getTopOption() {
            return null;
        }

        public boolean hasCountPath() {
            return false;
        }

        public boolean isRef() {
            return false;
        }

        public boolean isStar() {
            return true;
        }
    }
}

