/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.query.Util;
import com.sap.olingo.jpa.processor.core.serializer.JPAOperationSerializer;
import java.net.URISyntaxException;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.api.uri.UriInfo;

final class JPASerializeEntity
implements JPAOperationSerializer {
    private final ServiceMetadata serviceMetadata;
    private final UriInfo uriInfo;
    private final UriHelper uriHelper;
    private final ODataSerializer serializer;
    private final ContentType responseFormat;
    private final JPAODataCRUDContextAccess serviceContext;

    JPASerializeEntity(ServiceMetadata serviceMetadata, ODataSerializer serializer, UriHelper uriHelper, UriInfo uriInfo, ContentType responseFormat, JPAODataCRUDContextAccess context) {
        this.uriInfo = uriInfo;
        this.serializer = serializer;
        this.serviceMetadata = serviceMetadata;
        this.uriHelper = uriHelper;
        this.responseFormat = responseFormat;
        this.serviceContext = context;
    }

    @Override
    public ContentType getContentType() {
        return this.responseFormat;
    }

    @Override
    public SerializerResult serialize(Annotatable annotatable, EdmType entityType, ODataRequest request) throws SerializerException, ODataJPASerializerException {
        EntityCollection result = (EntityCollection)annotatable;
        String selectList = this.uriHelper.buildContextURLSelectList((EdmStructuredType)((EdmEntityType)entityType), this.uriInfo.getExpandOption(), this.uriInfo.getSelectOption());
        try {
            ContextURL contextUrl = ContextURL.with().serviceRoot(this.buildServiceRoot(request, this.serviceContext)).type(entityType).selectList(selectList).build();
            EntitySerializerOptions options = EntitySerializerOptions.with().contextURL(contextUrl).select(this.uriInfo.getSelectOption()).expand(this.uriInfo.getExpandOption()).build();
            return this.serializer.entity(this.serviceMetadata, (EdmEntityType)entityType, (Entity)result.getEntities().get(0), options);
        }
        catch (URISyntaxException e) {
            throw new ODataJPASerializerException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    @Override
    public SerializerResult serialize(ODataRequest request, EntityCollection result) throws SerializerException, ODataJPASerializerException {
        EdmEntitySet targetEdmEntitySet = Util.determineTargetEntitySet(this.uriInfo.getUriResourceParts());
        EdmEntityType entityType = targetEdmEntitySet.getEntityType();
        return this.serialize((Annotatable)result, (EdmType)entityType, request);
    }
}

