/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.serializer.JPAOperationSerializer;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializer;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializerFactory;
import java.util.List;
import java.util.Optional;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;

final class JPASerializeFunction
implements JPAOperationSerializer {
    private final JPAOperationSerializer serializer;

    public JPASerializeFunction(UriInfo uriInfo, ContentType responseFormat, JPASerializerFactory jpaSerializerFactory, Optional<List<String>> responseVersion) throws ODataJPASerializerException, SerializerException {
        this.serializer = (JPAOperationSerializer)this.createSerializer(jpaSerializerFactory, responseFormat, uriInfo, responseVersion);
    }

    @Override
    public SerializerResult serialize(ODataRequest request, EntityCollection result) throws SerializerException, ODataJPASerializerException {
        return this.serializer.serialize(request, result);
    }

    @Override
    public SerializerResult serialize(Annotatable annotatable, EdmType entityType, ODataRequest request) throws SerializerException, ODataJPASerializerException {
        return this.serializer.serialize(annotatable, entityType, request);
    }

    JPASerializer getSerializer() {
        return this.serializer;
    }

    private JPASerializer createSerializer(JPASerializerFactory jpaSerializerFactory, ContentType responseFormat, UriInfo uriInfo, Optional<List<String>> responseVersion) throws ODataJPASerializerException, SerializerException {
        List resourceParts = uriInfo.getUriResourceParts();
        UriResourcePartTyped operation = (UriResourcePartTyped)resourceParts.get(resourceParts.size() - 1);
        EdmTypeKind edmTypeKind = this.determineReturnEdmTypeKind(operation);
        return jpaSerializerFactory.createSerializer(responseFormat, uriInfo, edmTypeKind, operation.isCollection(), responseVersion);
    }

    private EdmTypeKind determineReturnEdmTypeKind(UriResourcePartTyped operation) {
        if (operation instanceof UriResourceFunction) {
            return ((UriResourceFunction)operation).getFunction().getReturnType().getType().getKind();
        }
        return ((UriResourceAction)operation).getAction().getReturnType().getType().getKind();
    }

    @Override
    public ContentType getContentType() {
        return this.serializer.getContentType();
    }
}

