/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.query.Util;
import com.sap.olingo.jpa.processor.core.serializer.JPAPrimitivePropertyInfo;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializePrimitiveAbstract;
import java.net.URISyntaxException;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResourceProperty;

final class JPASerializePrimitive
extends JPASerializePrimitiveAbstract {
    private final ODataSerializer serializer;
    private final ContentType responseFormat;
    private final JPAODataCRUDContextAccess serviceContext;

    JPASerializePrimitive(ServiceMetadata serviceMetadata, ODataSerializer serializer, UriInfo uriInfo, ContentType responseFormat, JPAODataCRUDContextAccess context) {
        super(serviceMetadata, uriInfo);
        this.serializer = serializer;
        this.responseFormat = responseFormat;
        this.serviceContext = context;
    }

    @Override
    public ContentType getContentType() {
        return this.responseFormat;
    }

    @Override
    public SerializerResult serialize(Annotatable result, EdmType primitiveType, ODataRequest request) throws SerializerException, ODataJPASerializerException {
        try {
            ContextURL contextUrl = ContextURL.with().serviceRoot(this.buildServiceRoot(request, this.serviceContext)).build();
            PrimitiveSerializerOptions options = PrimitiveSerializerOptions.with().contextURL(contextUrl).build();
            return this.serializer.primitive(this.serviceMetadata, (EdmPrimitiveType)primitiveType, (Property)result, options);
        }
        catch (URISyntaxException e) {
            throw new ODataJPASerializerException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    @Override
    public SerializerResult serialize(ODataRequest request, EntityCollection result) throws SerializerException, ODataJPASerializerException {
        EdmEntitySet targetEdmEntitySet = Util.determineTargetEntitySet(this.uriInfo.getUriResourceParts());
        UriResourceProperty uriProperty = (UriResourceProperty)this.uriInfo.getUriResourceParts().get(this.uriInfo.getUriResourceParts().size() - 1);
        JPAPrimitivePropertyInfo property = this.determinePrimitiveProperty(result, this.uriInfo.getUriResourceParts());
        EdmPrimitiveType edmPropertyType = (EdmPrimitiveType)uriProperty.getProperty().getType();
        try {
            ContextURL contextUrl = ContextURL.with().serviceRoot(this.buildServiceRoot(request, this.serviceContext)).entitySet(targetEdmEntitySet).navOrPropertyPath(property.getPath()).build();
            PrimitiveSerializerOptions options = PrimitiveSerializerOptions.with().contextURL(contextUrl).build();
            if (uriProperty.getProperty().isCollection()) {
                return this.serializer.primitiveCollection(this.serviceMetadata, edmPropertyType, property.getProperty(), options);
            }
            return this.serializer.primitive(this.serviceMetadata, edmPropertyType, property.getProperty(), options);
        }
        catch (URISyntaxException e) {
            throw new ODataJPASerializerException(e, HttpStatusCode.BAD_REQUEST);
        }
    }
}

