/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.serializer.JPAOperationSerializer;
import com.sap.olingo.jpa.processor.core.serializer.JPAPrimitivePropertyInfo;
import java.util.List;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceProperty;

public abstract class JPASerializePrimitiveAbstract
implements JPAOperationSerializer {
    protected static final char PATH_SEPERATOR = '/';
    protected final ServiceMetadata serviceMetadata;
    protected final UriInfo uriInfo;

    public JPASerializePrimitiveAbstract(ServiceMetadata serviceMetadata, UriInfo uriInfo) {
        this.serviceMetadata = serviceMetadata;
        this.uriInfo = uriInfo;
    }

    protected final JPAPrimitivePropertyInfo determinePrimitiveProperty(EntityCollection result, List<UriResource> uriResources) {
        Property property = null;
        Object value = null;
        StringBuilder path = new StringBuilder();
        for (Property item : ((Entity)result.getEntities().get(0)).getProperties()) {
            if (!this.partOfPath(item, uriResources)) continue;
            property = item;
            boolean found = false;
            while (!found) {
                path.append(property.getName());
                if (property.getValue() instanceof ComplexValue) {
                    value = property.getValue();
                    property = (Property)((ComplexValue)value).getValue().get(0);
                    path.append('/');
                    continue;
                }
                found = true;
            }
            break block0;
        }
        return new JPAPrimitivePropertyInfo(path.toString(), property);
    }

    private boolean partOfPath(Property item, List<UriResource> uriResources) {
        for (UriResource resource : uriResources) {
            if (!(resource instanceof UriResourceProperty) || !((UriResourceProperty)resource).getProperty().getName().equals(item.getName())) continue;
            return true;
        }
        return false;
    }
}

