/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.serializer.JPAOperationSerializer;
import java.net.URISyntaxException;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;

final class JPASerializePrimitiveCollection
implements JPAOperationSerializer {
    private final ServiceMetadata serviceMetadata;
    private final ODataSerializer serializer;
    private final ContentType responseFormat;
    private final JPAODataCRUDContextAccess serviceContext;

    JPASerializePrimitiveCollection(ServiceMetadata serviceMetadata, ODataSerializer serializer, ContentType responseFormat, JPAODataCRUDContextAccess context) {
        this.serializer = serializer;
        this.serviceMetadata = serviceMetadata;
        this.responseFormat = responseFormat;
        this.serviceContext = context;
    }

    @Override
    public ContentType getContentType() {
        return this.responseFormat;
    }

    @Override
    public SerializerResult serialize(Annotatable result, EdmType primitiveType, ODataRequest request) throws SerializerException, ODataJPASerializerException {
        try {
            ContextURL contextUrl = ContextURL.with().serviceRoot(this.buildServiceRoot(request, this.serviceContext)).asCollection().build();
            PrimitiveSerializerOptions options = PrimitiveSerializerOptions.with().contextURL(contextUrl).build();
            return this.serializer.primitiveCollection(this.serviceMetadata, (EdmPrimitiveType)primitiveType, (Property)result, options);
        }
        catch (URISyntaxException e) {
            throw new ODataJPASerializerException(e, HttpStatusCode.BAD_REQUEST);
        }
    }

    @Override
    public SerializerResult serialize(ODataRequest request, EntityCollection result) throws SerializerException, ODataJPASerializerException {
        return null;
    }
}

