/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.serializer.JPAPrimitivePropertyInfo;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializePrimitiveAbstract;
import com.sap.olingo.jpa.processor.core.serializer.JPAValueSerializerResult;
import java.io.InputStream;
import java.util.List;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.FixedFormatSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveValueSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourceProperty;

final class JPASerializeValue
extends JPASerializePrimitiveAbstract {
    private final FixedFormatSerializer serializer;

    JPASerializeValue(ServiceMetadata serviceMetadata, FixedFormatSerializer serializer, UriInfo uriInfo) {
        super(serviceMetadata, uriInfo);
        this.serializer = serializer;
    }

    @Override
    public SerializerResult serialize(ODataRequest request, EntityCollection result) throws SerializerException, ODataJPASerializerException {
        if (result.getEntities().get(0) == null || ((Entity)result.getEntities().get(0)).getProperties() == null || ((Entity)result.getEntities().get(0)).getProperties().isEmpty()) {
            throw new ODataJPASerializerException(ODataJPASerializerException.MessageKeys.RESULT_NOT_FOUND, HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        InputStream serializerResult = null;
        if (this.isStream()) {
            Entity et = (Entity)result.getEntities().get(0);
            EdmEntityType edmEt = this.serviceMetadata.getEdm().getEntityType(new FullQualifiedName(et.getType()));
            List p = edmEt.getKeyPropertyRefs();
            Property property = null;
            for (Property item : ((Entity)result.getEntities().get(0)).getProperties()) {
                if (this.isKey(p, item)) continue;
                property = item;
                break;
            }
            if (property == null) {
                throw new ODataJPASerializerException(ODataJPASerializerException.MessageKeys.RESULT_NOT_FOUND, HttpStatusCode.INTERNAL_SERVER_ERROR);
            }
            serializerResult = this.serializer.binary((byte[])property.getValue());
        } else {
            UriResourceProperty uriProperty = (UriResourceProperty)this.uriInfo.getUriResourceParts().get(this.uriInfo.getUriResourceParts().size() - 2);
            EdmPrimitiveType edmPropertyType = (EdmPrimitiveType)uriProperty.getType();
            JPAPrimitivePropertyInfo info = this.determinePrimitiveProperty(result, this.uriInfo.getUriResourceParts());
            PrimitiveValueSerializerOptions options = PrimitiveValueSerializerOptions.with().build();
            if (!info.getProperty().isNull()) {
                serializerResult = this.serializer.primitiveValue(edmPropertyType, info.getProperty().getValue(), options);
            }
        }
        return new JPAValueSerializerResult(serializerResult);
    }

    @Override
    public SerializerResult serialize(Annotatable result, EdmType entityType, ODataRequest request) throws SerializerException, ODataJPASerializerException {
        PrimitiveValueSerializerOptions options = PrimitiveValueSerializerOptions.with().build();
        return new JPAValueSerializerResult(this.serializer.primitiveValue((EdmPrimitiveType)entityType, ((Property)result).getValue(), options));
    }

    private boolean isStream() {
        UriResource successor = (UriResource)this.uriInfo.getUriResourceParts().get(this.uriInfo.getUriResourceParts().size() - 2);
        return successor instanceof UriResourceEntitySet || successor instanceof UriResourceNavigation && ((UriResourceNavigation)successor).getType() instanceof EdmEntityType;
    }

    private boolean isKey(List<EdmKeyPropertyRef> keyist, Property item) {
        for (EdmKeyPropertyRef key : keyist) {
            if (!key.getName().equals(item.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.TEXT_PLAIN;
    }
}

