/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;

public interface JPASerializer {
    public SerializerResult serialize(ODataRequest var1, EntityCollection var2) throws SerializerException, ODataJPASerializerException;

    public ContentType getContentType();

    default public URI buildServiceRoot(ODataRequest request, JPAODataCRUDContextAccess serviceContext) throws URISyntaxException {
        if (serviceContext.useAbsoluteContextURL()) {
            String serviceRoot = request.getRawBaseUri();
            if (serviceRoot == null) {
                return null;
            }
            return new URI((String)(serviceRoot.endsWith("/") ? serviceRoot : serviceRoot + "/"));
        }
        return null;
    }
}

