/*
 * Decompiled with CFR 0.152.
 */
package com.sap.olingo.jpa.processor.core.serializer;

import com.sap.olingo.jpa.processor.core.api.JPAODataCRUDContextAccess;
import com.sap.olingo.jpa.processor.core.exception.ODataJPASerializerException;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializeComplex;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializeComplexCollection;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializeCount;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializeCreate;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializeEntity;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializeEntityCollection;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializeFunction;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializePrimitive;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializePrimitiveCollection;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializeValue;
import com.sap.olingo.jpa.processor.core.serializer.JPASerializer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;

public final class JPASerializerFactory {
    private final ServiceMetadata serviceMetadata;
    private final OData odata;
    private final UriHelper uriHelper;
    private final JPAODataCRUDContextAccess serviceContext;

    public JPASerializerFactory(OData odata, ServiceMetadata serviceMetadata, JPAODataCRUDContextAccess serviceContext) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
        this.uriHelper = odata.createUriHelper();
        this.serviceContext = serviceContext;
    }

    public JPASerializer createCUDSerializer(ContentType responseFormat, UriInfo uriInfo, Optional<List<String>> responseVersion) throws SerializerException {
        ODataSerializer serializer = this.odata.createSerializer(responseFormat, responseVersion.orElse(Collections.emptyList()));
        return new JPASerializeCreate(this.serviceMetadata, serializer, uriInfo, this.serviceContext);
    }

    public JPASerializer createSerializer(ContentType responseFormat, UriInfo uriInfo, Optional<List<String>> responseVersion) throws ODataApplicationException, SerializerException {
        List resourceParts = uriInfo.getUriResourceParts();
        UriResource lastItem = (UriResource)resourceParts.get(resourceParts.size() - 1);
        boolean isColletion = this.determineIsCollection(lastItem);
        return this.createSerializer(responseFormat, uriInfo, lastItem.getKind(), isColletion, responseVersion);
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    JPASerializer createSerializer(ContentType responseFormat, UriInfo uriInfo, EdmTypeKind edmTypeKind, boolean isColletion, Optional<List<String>> responseVersion) throws SerializerException, ODataJPASerializerException {
        ODataSerializer serializer = this.odata.createSerializer(responseFormat, responseVersion.orElse(Collections.emptyList()));
        switch (edmTypeKind) {
            case ENTITY: {
                if (isColletion) {
                    return new JPASerializeEntityCollection(this.serviceMetadata, serializer, this.uriHelper, uriInfo, responseFormat, this.serviceContext);
                }
                return new JPASerializeEntity(this.serviceMetadata, serializer, this.uriHelper, uriInfo, responseFormat, this.serviceContext);
            }
            case COMPLEX: {
                if (isColletion) {
                    return new JPASerializeComplexCollection(this.serviceMetadata, serializer, responseFormat, this.serviceContext);
                }
                return new JPASerializeComplex(this.serviceMetadata, serializer, this.uriHelper, uriInfo, responseFormat, this.serviceContext);
            }
            case PRIMITIVE: {
                if (isColletion) {
                    return new JPASerializePrimitiveCollection(this.serviceMetadata, serializer, responseFormat, this.serviceContext);
                }
                return new JPASerializePrimitive(this.serviceMetadata, serializer, uriInfo, responseFormat, this.serviceContext);
            }
        }
        throw new ODataJPASerializerException(ODataJPASerializerException.MessageKeys.NOT_SUPPORTED_RESOURCE_TYPE, HttpStatusCode.NOT_IMPLEMENTED, edmTypeKind.toString());
    }

    JPASerializer createSerializer(ContentType responseFormat, UriInfo uriInfo, UriResourceKind uriResourceKind, boolean isColletion, Optional<List<String>> responseVersion) throws SerializerException, ODataJPASerializerException {
        switch (uriResourceKind) {
            case entitySet: 
            case navigationProperty: {
                return this.createSerializerCollectionRequest(responseFormat, uriInfo, isColletion, responseVersion);
            }
            case complexProperty: {
                return this.createSerializerComplexPropertyRequest(responseFormat, uriInfo, responseVersion);
            }
            case primitiveProperty: {
                return this.createSerializerPrimitivePropertyRequest(responseFormat, uriInfo, responseVersion);
            }
            case action: 
            case function: {
                return new JPASerializeFunction(uriInfo, responseFormat, this, responseVersion);
            }
            case count: {
                return new JPASerializeCount(this.odata.createFixedFormatSerializer());
            }
            case value: {
                return new JPASerializeValue(this.serviceMetadata, this.odata.createFixedFormatSerializer(), uriInfo);
            }
        }
        throw new ODataJPASerializerException(ODataJPASerializerException.MessageKeys.NOT_SUPPORTED_RESOURCE_TYPE, HttpStatusCode.NOT_IMPLEMENTED, uriResourceKind.toString());
    }

    private JPASerializer createSerializerCollectionRequest(ContentType responseFormat, UriInfo uriInfo, boolean isColletion, Optional<List<String>> responseVersion) throws SerializerException {
        ODataSerializer serializer = this.odata.createSerializer(responseFormat, responseVersion.orElse(Collections.emptyList()));
        if (isColletion) {
            return new JPASerializeEntityCollection(this.serviceMetadata, serializer, this.uriHelper, uriInfo, responseFormat, this.serviceContext);
        }
        return new JPASerializeEntity(this.serviceMetadata, serializer, this.uriHelper, uriInfo, responseFormat, this.serviceContext);
    }

    private JPASerializer createSerializerComplexPropertyRequest(ContentType responseFormat, UriInfo uriInfo, Optional<List<String>> responseVersion) throws SerializerException {
        ODataSerializer serializer = this.odata.createSerializer(responseFormat, responseVersion.orElse(Collections.emptyList()));
        return new JPASerializeComplex(this.serviceMetadata, serializer, this.uriHelper, uriInfo, responseFormat, this.serviceContext);
    }

    private JPASerializer createSerializerPrimitivePropertyRequest(ContentType responseFormat, UriInfo uriInfo, Optional<List<String>> responseVersion) throws SerializerException {
        ODataSerializer serializer = this.odata.createSerializer(responseFormat, responseVersion.orElse(Collections.emptyList()));
        return new JPASerializePrimitive(this.serviceMetadata, serializer, uriInfo, responseFormat, this.serviceContext);
    }

    private boolean determineIsCollection(UriResource lastItem) {
        if (lastItem instanceof UriResourcePartTyped) {
            return ((UriResourcePartTyped)lastItem).isCollection();
        }
        return false;
    }
}

