/*
 * Decompiled with CFR 0.152.
 */
package net.flexmojos.oss.coverage;

import apparat.tools.coverage.Coverage;
import apparat.tools.coverage.CoverageConfiguration;
import apparat.tools.coverage.CoverageObserver;
import java.io.File;
import net.flexmojos.oss.coverage.CoverageConfigurationImpl;
import net.flexmojos.oss.coverage.CoverageReporter;
import net.flexmojos.oss.coverage.util.ApparatUtil;
import net.flexmojos.oss.util.PathUtil;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.SelectorUtils;

public abstract class AbstractCoverageReporter
extends AbstractLogEnabled
implements CoverageReporter {
    protected String[] excludes;

    @Override
    public void instrument(File swf, File ... sourcePaths) {
        this.getLogger().debug("Instrumenting code to test coverage mode " + System.getProperty("apparat.threads"));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().info("Instrumenting: " + PathUtil.path((File)swf) + "\n source paths: \n" + PathUtil.pathString((File[])sourcePaths));
        } else {
            this.getLogger().info("Instrumenting: " + PathUtil.path((File)swf));
        }
        Coverage.CoverageTool c = new Coverage.CoverageTool();
        c.configure((CoverageConfiguration)new CoverageConfigurationImpl(swf, swf, sourcePaths));
        c.addObserver(this.getInstrumentationObserver());
        if (this.getLogger().isDebugEnabled()) {
            c.addObserver(new CoverageObserver(){

                public void instrument(String file, int line) {
                    AbstractCoverageReporter.this.getLogger().debug("Instrumenting " + ApparatUtil.toClassname(file) + ":" + line);
                }
            });
        }
        c.run();
    }

    @Override
    public void setExcludes(String[] value) {
        this.excludes = null;
        if (value != null) {
            this.excludes = new String[value.length];
            for (int i = 0; i < this.excludes.length; ++i) {
                this.excludes[i] = this.normalizePattern(value[i]);
                this.getLogger().debug("exclusion added " + this.excludes[i]);
            }
        }
    }

    protected boolean isExcluded(String file) {
        this.getLogger().debug("isExcluded " + file + "?");
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!SelectorUtils.matchPath((String)exclude, (String)file.replace(';', File.separatorChar))) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract CoverageObserver getInstrumentationObserver();

    private String normalizePattern(String p) {
        String pattern = p.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (pattern.endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }
}

