/*
 * Decompiled with CFR 0.152.
 */
package net.flexmojos.oss.coverage.cobertura;

import apparat.tools.coverage.CoverageObserver;
import java.io.File;
import java.util.List;
import net.flexmojos.oss.coverage.AbstractCoverageReporter;
import net.flexmojos.oss.coverage.CoverageReportException;
import net.flexmojos.oss.coverage.CoverageReportRequest;
import net.flexmojos.oss.coverage.CoverageReporter;
import net.flexmojos.oss.coverage.cobertura.ZeroComplexityCalculator;
import net.flexmojos.oss.coverage.util.ApparatUtil;
import net.flexmojos.oss.util.PathUtil;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.reporting.html.HTMLReport;
import net.sourceforge.cobertura.reporting.xml.SummaryXMLReport;
import net.sourceforge.cobertura.reporting.xml.XMLReport;
import net.sourceforge.cobertura.util.FileFinder;
import net.sourceforge.cobertura.util.Source;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;

@Component(role=CoverageReporter.class, hint="cobertura", instantiationStrategy="per-lookup")
public class CoberturaCoverageReport
extends AbstractCoverageReporter
implements CoverageReporter,
Initializable {
    private ProjectData coverageProjectData;

    public void initialize() throws InitializationException {
        this.coverageProjectData = new ProjectData();
    }

    @Override
    protected CoverageObserver getInstrumentationObserver() {
        return new CoverageObserver(){

            public void instrument(String file, int line) {
                if (CoberturaCoverageReport.this.isExcluded(file)) {
                    CoberturaCoverageReport.this.getLogger().debug("ignoring " + file);
                } else {
                    ClassData classData = CoberturaCoverageReport.this.coverageProjectData.getOrCreateClassData(ApparatUtil.toClassname(file));
                    classData.setSourceFileName(CoberturaCoverageReport.this.getSourceFilePath(file));
                    classData.addLine(line, null, null);
                }
            }
        };
    }

    private String getSourceFilePath(String apparatClassname) {
        String cn = apparatClassname;
        cn = cn.substring(cn.lastIndexOf(59) + 1);
        cn = cn.replace(';', '/');
        return cn;
    }

    @Override
    public void generateReport(CoverageReportRequest request) throws CoverageReportException {
        File dataDirectory = request.getDataDirectory();
        FileFinder finder = new FileFinder(){

            public Source getSource(String fileName) {
                Source source = super.getSource(fileName.replace(".java", ".as"));
                if (source == null) {
                    source = super.getSource(fileName.replace(".java", ".mxml"));
                }
                return source;
            }
        };
        List<File> sp = request.getSourcePaths();
        for (File dir : sp) {
            finder.addSourceDirectory(PathUtil.path((File)dir));
        }
        ZeroComplexityCalculator complexity = new ZeroComplexityCalculator(finder);
        try {
            File coverageReportDestinationDir = request.getReportDestinationDir();
            coverageReportDestinationDir.mkdirs();
            List<String> format = request.getFormats();
            if (format.contains("html")) {
                String coverageReportEncoding = request.getReportEncoding();
                if (StringUtils.isEmpty((String)coverageReportEncoding)) {
                    coverageReportEncoding = "UTF-8";
                }
                new HTMLReport(this.coverageProjectData, coverageReportDestinationDir, finder, (ComplexityCalculator)complexity, coverageReportEncoding);
            }
            if (format.contains("xml")) {
                new XMLReport(this.coverageProjectData, coverageReportDestinationDir, finder, (ComplexityCalculator)complexity);
            }
            if (format.contains("summaryXml")) {
                new SummaryXMLReport(this.coverageProjectData, coverageReportDestinationDir, finder, (ComplexityCalculator)complexity);
            }
        }
        catch (Exception e) {
            throw new CoverageReportException("Unable to write coverage report", e);
        }
        CoverageDataFileHandler.saveCoverageData((ProjectData)this.coverageProjectData, (File)new File(dataDirectory, "cobertura.ser"));
    }

    @Override
    public void addResult(String file, Integer[] touchs) {
        this.getLogger().debug("addresult " + file);
        if (this.isExcluded(file)) {
            this.getLogger().debug("ignoring " + file + " from touch");
        } else {
            ClassData classData = this.coverageProjectData.getOrCreateClassData(ApparatUtil.toClassname(file));
            for (Integer touch : touchs) {
                classData.touch(touch.intValue(), 1);
            }
        }
    }
}

