/*
 * Decompiled with CFR 0.152.
 */
package net.flexmojos.oss.coverage.emma;

import apparat.tools.coverage.CoverageObserver;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.report.ReportProcessor;
import com.vladium.util.XProperties;
import java.io.File;
import java.util.Properties;
import net.flexmojos.oss.coverage.AbstractCoverageReporter;
import net.flexmojos.oss.coverage.CoverageReportException;
import net.flexmojos.oss.coverage.CoverageReportRequest;
import net.flexmojos.oss.coverage.CoverageReporter;
import net.flexmojos.oss.coverage.util.ApparatUtil;
import net.flexmojos.oss.util.PathUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

@Component(role=CoverageReporter.class, hint="emma", instantiationStrategy="per-lookup")
public class EmmaCoverageReport
extends AbstractCoverageReporter
implements CoverageReporter,
Initializable {
    private ICoverageData cdata;

    public void initialize() throws InitializationException {
        this.cdata = DataFactory.newCoverageData();
    }

    @Override
    protected CoverageObserver getInstrumentationObserver() {
        return new CoverageObserver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void instrument(String file, int line) {
                if (!EmmaCoverageReport.this.isExcluded(file)) {
                    String classname = ApparatUtil.toClassname(file);
                    Object object = EmmaCoverageReport.this.cdata.lock();
                    synchronized (object) {
                        boolean[][] cover = new boolean[0][0];
                        EmmaCoverageReport.this.cdata.addClass(cover, classname, (long)line);
                    }
                }
            }
        };
    }

    @Override
    public void generateReport(CoverageReportRequest request) throws CoverageReportException {
        File dataDirectory = request.getDataDirectory();
        File reportDirectory = request.getReportDestinationDir();
        File coverageFile = new File(dataDirectory, "coverage.ec");
        XProperties properties = new XProperties();
        properties.setProperty("report.html.out.file", PathUtil.path((File)new File(reportDirectory, "index.html")));
        properties.setProperty("report.xml.out.file", PathUtil.path((File)new File(reportDirectory, "coverage.xml")));
        properties.setProperty("report.txt.out.file", PathUtil.path((File)new File(reportDirectory, "coverage.txt")));
        properties.setProperty("report.sort", "+name,+block,+method,+class");
        properties.setProperty("report.out.encoding", "UTF-8");
        properties.setProperty("report.xml.out.encoding", "UTF-8");
        properties.setProperty("report.html.out.encoding", "UTF-8");
        ReportProcessor reporter = ReportProcessor.create();
        reporter.setAppName("EMMA");
        reporter.setDataPath(PathUtil.paths((File[])new File[]{coverageFile}));
        reporter.setSourcePath(PathUtil.paths(request.getSourcePaths()));
        try {
            reporter.setReportTypes(request.getFormats().toArray(new String[0]));
        }
        catch (RuntimeException e) {
            throw new CoverageReportException("Unsupported report format: " + request.getFormats(), e);
        }
        reporter.setPropertyOverrides((Properties)properties);
        reporter.run();
    }

    @Override
    public void addResult(String file, Integer[] touchs) {
    }
}

