/*
 * Decompiled with CFR 0.152.
 */
package net.flexmojos.oss.generator.granitedsv3d1d0;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.flexmojos.oss.generator.GenerationException;
import net.flexmojos.oss.generator.GenerationRequest;
import net.flexmojos.oss.generator.Generator;
import net.flexmojos.oss.generator.granitedsv3d1d0.Gas3Listener;
import org.codehaus.plexus.component.annotations.Component;
import org.granite.generator.Configuration;
import org.granite.generator.Input;
import org.granite.generator.Listener;
import org.granite.generator.Output;
import org.granite.generator.TemplateUri;
import org.granite.generator.Transformer;
import org.granite.generator.as3.As3TypeFactory;
import org.granite.generator.as3.DefaultAs3TypeFactory;
import org.granite.generator.as3.DefaultEntityFactory;
import org.granite.generator.as3.DefaultRemoteDestinationFactory;
import org.granite.generator.as3.EntityFactory;
import org.granite.generator.as3.JavaAs3GroovyConfiguration;
import org.granite.generator.as3.JavaAs3GroovyTransformer;
import org.granite.generator.as3.JavaAs3Input;
import org.granite.generator.as3.PackageTranslator;
import org.granite.generator.as3.RemoteDestinationFactory;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.gsp.GroovyTemplateFactory;

@Component(role=Generator.class, hint="graniteds310")
public final class GraniteDsGenerator
implements Generator {
    private static final String PREFIX_TO_REPLACE = "class:";
    private static final String SHADED_PREFIX = "class:";
    private String uid = "uid";
    private String as3typefactory = null;
    private boolean tide = false;
    private boolean externalizeBigDecimal = false;
    private boolean externalizeBigInteger = false;
    private boolean externalizeLong = false;
    private boolean generateEnumToTransientStorage = false;
    private boolean generateInterfaceToTransientStorage = false;
    private String transformer = null;
    private List<PackageTranslator> translators = new ArrayList<PackageTranslator>();
    private As3TypeFactory as3TypeFactoryImpl = null;
    private GroovyTemplateFactory groovyTemplateFactory = null;
    private PackageTranslator packageTranslator = null;
    private EntityFactory entityFactoryImpl = null;
    private RemoteDestinationFactory remoteDestinationFactoryImpl = null;
    private TemplateUri[] entityTemplateUris;
    private TemplateUri[] interfaceTemplateUris;
    private TemplateUri[] beanTemplateUris;
    private TemplateUri[] enumTemplateUris;
    private TemplateUri[] remoteTemplateUris;
    private Map<String, File> classes;
    private File outputDirectory;
    private File baseOutputDirectory;

    private TemplateUri[] initializeEnumTemplateURIs(String[] enumTemplate) {
        String templateUri = this.getStringIndex0(enumTemplate);
        if (templateUri == null) {
            templateUri = "class:org/granite/generator/template/enum.gsp".replaceFirst("class:", "class:");
        }
        return this.createTemplateUris(null, templateUri);
    }

    private TemplateUri[] initializeInterfaceTemplateURIs(String[] interfaceTemplate) {
        String baseTemplateUri = null;
        String templateUri = "class:org/granite/generator/template/interface.gsp".replaceFirst("class:", "class:");
        if (this.getStringIndex1(interfaceTemplate) != null) {
            templateUri = this.getStringIndex1(interfaceTemplate);
        }
        if (this.getStringIndex0(interfaceTemplate) != null) {
            baseTemplateUri = this.getStringIndex0(interfaceTemplate);
        }
        return this.createTemplateUris(baseTemplateUri, templateUri);
    }

    private TemplateUri[] initializeEntityTemplateURIs(String[] entityTemplate) {
        String baseTemplateUri = "class:org/granite/generator/template/entityBase.gsp".replaceFirst("class:", "class:");
        String templateUri = "class:org/granite/generator/template/entity.gsp".replaceFirst("class:", "class:");
        if (this.getStringIndex1(entityTemplate) != null) {
            templateUri = this.getStringIndex1(entityTemplate);
        }
        if (this.getStringIndex0(entityTemplate) != null) {
            baseTemplateUri = this.getStringIndex0(entityTemplate);
        } else if (this.tide) {
            baseTemplateUri = "class:org/granite/generator/template/tideEntityBase.gsp".replaceFirst("class:", "class:");
        }
        return this.createTemplateUris(baseTemplateUri, templateUri);
    }

    private TemplateUri[] initializeBeanTemplateURIs(String[] beanTemplate) {
        String baseTemplateUri = "class:org/granite/generator/template/beanBase.gsp".replaceFirst("class:", "class:");
        String templateUri = "class:org/granite/generator/template/bean.gsp".replaceFirst("class:", "class:");
        if (this.getStringIndex1(beanTemplate) != null) {
            templateUri = this.getStringIndex1(beanTemplate);
        }
        if (this.getStringIndex0(beanTemplate) != null) {
            baseTemplateUri = this.getStringIndex0(beanTemplate);
        }
        return this.createTemplateUris(baseTemplateUri, templateUri);
    }

    private TemplateUri[] initializeRemoteTemplateURIs(String[] remoteTemplate) {
        String baseTemplateUri = "class:org/granite/generator/template/remoteBase.gsp".replaceFirst("class:", "class:");
        String templateUri = "class:org/granite/generator/template/remote.gsp".replaceFirst("class:", "class:");
        if (this.getStringIndex1(remoteTemplate) != null) {
            templateUri = this.getStringIndex1(remoteTemplate);
        }
        if (this.getStringIndex0(remoteTemplate) != null) {
            baseTemplateUri = this.getStringIndex0(remoteTemplate);
        } else if (this.tide) {
            baseTemplateUri = "class:org/granite/generator/template/tideRemoteBase.gsp".replaceFirst("class:", "class:");
        }
        return this.createTemplateUris(baseTemplateUri, templateUri);
    }

    private String getStringIndex0(String[] a) {
        return this.getStringByIndex(a, 0);
    }

    private String getStringIndex1(String[] a) {
        return this.getStringByIndex(a, 1);
    }

    private String getStringByIndex(String[] a, int index) {
        String s;
        String string = a == null ? null : (s = a.length < index + 1 ? null : a[index]);
        return s == null ? null : (s.startsWith("class:") ? s : new File(s).toURI().toString());
    }

    private TemplateUri[] createTemplateUris(String baseUri, String uri) {
        TemplateUri[] templateUris = new TemplateUri[baseUri == null ? 1 : 2];
        int i = 0;
        if (baseUri != null) {
            templateUris[i++] = new TemplateUri(baseUri, true);
        }
        templateUris[i] = new TemplateUri(uri, false);
        return templateUris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generate(GenerationRequest request) throws GenerationException {
        String useGenerateInterfaceToTransientStorage;
        String useGenerateEnumToTransientStorage;
        String useExternalizeBigInteger;
        String useExternalizeBigDecimal;
        String useExternalizeLong;
        for (String currentTranslator : request.getTranslators()) {
            String[] splitTranslator = currentTranslator.split("=");
            if (splitTranslator.length != 2) {
                throw new GenerationException("Invalid format: translators must be in format 'java.package=as3.package'");
            }
            String java = splitTranslator[0];
            String as3 = splitTranslator[1];
            request.getLogger().info("Adding translator: [" + java + ", " + as3 + "]");
            this.translators.add(new PackageTranslator(java, as3));
        }
        String useTide = (String)request.getExtraOptions().get("tide");
        if (useTide != null) {
            this.tide = Boolean.valueOf(useTide.trim());
        }
        if ((useExternalizeLong = (String)request.getExtraOptions().get("externalizeLong")) != null) {
            this.externalizeLong = Boolean.valueOf(useExternalizeLong.trim());
        }
        if ((useExternalizeBigDecimal = (String)request.getExtraOptions().get("externalizeBigDecimal")) != null) {
            this.externalizeBigDecimal = Boolean.valueOf(useExternalizeBigDecimal.trim());
        }
        if ((useExternalizeBigInteger = (String)request.getExtraOptions().get("externalizeBigInteger")) != null) {
            this.externalizeBigInteger = Boolean.valueOf(useExternalizeBigInteger.trim());
        }
        if ((useGenerateEnumToTransientStorage = (String)request.getExtraOptions().get("generateEnumToTransientStorage")) != null) {
            this.generateEnumToTransientStorage = Boolean.valueOf(useGenerateEnumToTransientStorage.trim());
        }
        if ((useGenerateInterfaceToTransientStorage = (String)request.getExtraOptions().get("generateInterfaceToTransientStorage")) != null) {
            this.generateInterfaceToTransientStorage = Boolean.valueOf(useGenerateInterfaceToTransientStorage.trim());
        }
        this.uid = (String)request.getExtraOptions().get("uid");
        this.transformer = (String)request.getExtraOptions().get("transformer");
        this.outputDirectory = request.getPersistentOutputFolder();
        this.baseOutputDirectory = request.getTransientOutputFolder();
        String[] enumTemplate = this.getTemplate(request, "enum-template");
        this.enumTemplateUris = this.initializeEnumTemplateURIs(new String[]{enumTemplate[1]});
        String[] interfaceTemplate = this.getTemplate(request, "interface-template");
        this.interfaceTemplateUris = this.initializeInterfaceTemplateURIs(interfaceTemplate);
        String[] entityTemplate = this.getTemplate(request, "entity-template");
        this.entityTemplateUris = this.initializeEntityTemplateURIs(entityTemplate);
        String[] beanTemplate = this.getTemplate(request, "bean-template");
        this.beanTemplateUris = this.initializeBeanTemplateURIs(beanTemplate);
        String[] remoteTemplate = this.getTemplate(request, "remote-template");
        this.remoteTemplateUris = this.initializeRemoteTemplateURIs(remoteTemplate);
        this.classes = request.getClasses();
        if (this.classes.isEmpty()) {
            request.getLogger().warn("No classes to generate.");
            return;
        }
        ClassLoader classLoader = request.getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.as3typefactory = (String)request.getExtraOptions().get("as3typefactory");
            if (this.as3typefactory == null) {
                this.as3TypeFactoryImpl = new DefaultAs3TypeFactory();
                this.as3TypeFactoryImpl.configure(this.externalizeLong, this.externalizeBigInteger, this.externalizeBigDecimal);
            } else {
                request.getLogger().info("Instantiating custom As3TypeFactory class: [" + this.as3typefactory + "]");
                this.as3TypeFactoryImpl = (As3TypeFactory)this.newInstance(classLoader, this.as3typefactory);
            }
            String entityfactory = (String)request.getExtraOptions().get("entityFactory");
            if (entityfactory == null) {
                this.entityFactoryImpl = new DefaultEntityFactory();
            } else {
                request.getLogger().info("Instantiating custom EntityFactory class: [" + entityfactory + "]");
                this.entityFactoryImpl = (EntityFactory)this.newInstance(classLoader, entityfactory);
            }
            String remotedestinationfactory = (String)request.getExtraOptions().get("remoteDestinationFactory");
            if (remotedestinationfactory == null) {
                this.remoteDestinationFactoryImpl = new DefaultRemoteDestinationFactory();
            } else {
                request.getLogger().info("Instantiating custom RemoteDestinationFactory class: [" + remotedestinationfactory + "]");
                this.remoteDestinationFactoryImpl = (RemoteDestinationFactory)this.newInstance(classLoader, remotedestinationfactory);
            }
            GeneratorConfiguration configuration = new GeneratorConfiguration();
            Transformer<?, ?, ?> transformerImpl = this.createTransformer(request, configuration);
            org.granite.generator.Generator generator = new org.granite.generator.Generator((Configuration)configuration);
            generator.add(transformerImpl);
            request.getLogger().info("Calling the generator for each Java class.");
            int count = this.generateClass(request, generator);
            request.getLogger().info("Files affected: " + count + (count == 0 ? " (nothing to do)." : "."));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private String[] getTemplate(GenerationRequest configuration, String name) {
        String baseTemplate = (String)configuration.getTemplates().get("base-" + name);
        String template = (String)configuration.getTemplates().get(name);
        return new String[]{baseTemplate, template};
    }

    private Transformer<?, ?, ?> createTransformer(GenerationRequest request, GeneratorConfiguration configuration) throws GenerationException {
        JavaAs3GroovyTransformer transformerImpl;
        if (this.transformer != null) {
            request.getLogger().info("Instantiating custom Transformer class: [" + this.transformer + "]");
            transformerImpl = (Transformer)this.newInstance(request.getClassLoader(), this.transformer);
        } else {
            transformerImpl = new JavaAs3GroovyTransformer();
        }
        transformerImpl.setListener((Listener)new Gas3Listener(request.getLogger()));
        return transformerImpl;
    }

    private int generateClass(GenerationRequest request, org.granite.generator.Generator generator) throws GenerationException {
        int count = 0;
        for (Map.Entry<String, File> classFile : this.classes.entrySet()) {
            String className = classFile.getKey();
            try {
                Class<?> classToGenerate = request.getClassLoader().loadClass(className);
                if (classToGenerate.isMemberClass() && !classToGenerate.isEnum()) continue;
                JavaAs3Input input = new JavaAs3Input(classToGenerate, classFile.getValue());
                for (Output output : generator.generate((Input)input)) {
                    if (!output.isOutdated()) continue;
                    ++count;
                }
            }
            catch (Exception e) {
                request.getLogger().error(GraniteDsGenerator.getStackTrace(e));
                throw new GenerationException("Fail to generate class [" + className + "]", (Throwable)e);
            }
        }
        return count;
    }

    private <T> T newInstance(ClassLoader loader, String className) throws GenerationException {
        try {
            return (T)loader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new GenerationException("Instantiate [" + className + "] failed.");
        }
    }

    private static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private class GeneratorConfiguration
    implements JavaAs3GroovyConfiguration {
        private GeneratorConfiguration() {
        }

        public String getUid() {
            return GraniteDsGenerator.this.uid;
        }

        public boolean isGenerated(Class<?> clazz) {
            return (!clazz.isMemberClass() || clazz.isEnum()) && GraniteDsGenerator.this.classes.containsKey(clazz.getName());
        }

        public As3TypeFactory getAs3TypeFactory() {
            return GraniteDsGenerator.this.as3TypeFactoryImpl;
        }

        public List<PackageTranslator> getTranslators() {
            return GraniteDsGenerator.this.translators;
        }

        public EntityFactory getEntityFactory() {
            return GraniteDsGenerator.this.entityFactoryImpl;
        }

        public RemoteDestinationFactory getRemoteDestinationFactory() {
            return GraniteDsGenerator.this.remoteDestinationFactoryImpl;
        }

        public TemplateUri[] getTemplateUris(JavaType.Kind kind, Class<?> clazz) {
            switch (kind) {
                case ENTITY: {
                    return GraniteDsGenerator.this.entityTemplateUris;
                }
                case INTERFACE: {
                    return GraniteDsGenerator.this.interfaceTemplateUris;
                }
                case ENUM: {
                    return GraniteDsGenerator.this.enumTemplateUris;
                }
                case BEAN: {
                    return GraniteDsGenerator.this.beanTemplateUris;
                }
                case REMOTE_DESTINATION: {
                    return GraniteDsGenerator.this.remoteTemplateUris;
                }
            }
            throw new IllegalArgumentException("Unknown template kind: " + kind + " / " + clazz);
        }

        public File getOutputDir(JavaAs3Input input) {
            switch (input.getJavaType().getKind()) {
                case INTERFACE: {
                    if (GraniteDsGenerator.this.generateInterfaceToTransientStorage) {
                        return GraniteDsGenerator.this.baseOutputDirectory;
                    }
                    return GraniteDsGenerator.this.outputDirectory;
                }
                case ENUM: {
                    if (GraniteDsGenerator.this.generateEnumToTransientStorage) {
                        return GraniteDsGenerator.this.baseOutputDirectory;
                    }
                    return GraniteDsGenerator.this.outputDirectory;
                }
            }
            return GraniteDsGenerator.this.outputDirectory;
        }

        public File getBaseOutputDir(JavaAs3Input input) {
            return GraniteDsGenerator.this.baseOutputDirectory;
        }

        public GroovyTemplateFactory getGroovyTemplateFactory() {
            if (GraniteDsGenerator.this.groovyTemplateFactory == null) {
                GraniteDsGenerator.this.groovyTemplateFactory = new GroovyTemplateFactory();
            }
            return GraniteDsGenerator.this.groovyTemplateFactory;
        }

        public ClassLoader getClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }

        public File getWorkingDirectory() {
            return GraniteDsGenerator.this.baseOutputDirectory;
        }
    }
}

