/*
 * Decompiled with CFR 0.152.
 */
package net.flexmojos.oss.util;

public class OSUtils {
    private static final String WINDOWS_CMD = "FlashPlayer.exe";
    private static final String MAC_CMD = "Flash Player";
    private static final String UNIX_CMD = "flashplayer";

    public static OS getOSType() {
        String osName = System.getProperty("os.name").toLowerCase();
        for (OS os : OS.values()) {
            if (!osName.contains(os.toString())) continue;
            return os;
        }
        return OS.other;
    }

    public static String[] getPlatformDefaultFlashPlayer() {
        switch (OSUtils.getOSType()) {
            case windows: {
                return new String[]{WINDOWS_CMD};
            }
            case mac: {
                return new String[]{MAC_CMD};
            }
        }
        return new String[]{UNIX_CMD};
    }

    public static String[] getPlatformDefaultAdl() {
        switch (OSUtils.getOSType()) {
            case windows: {
                return new String[]{"adl.exe"};
            }
        }
        return new String[]{"adl"};
    }

    public static boolean isLinux() {
        switch (OSUtils.getOSType()) {
            case windows: 
            case mac: {
                return false;
            }
        }
        return true;
    }

    public static boolean isWindows() {
        return OSUtils.getOSType().equals((Object)OS.windows);
    }

    public static boolean isMacOS() {
        return OSUtils.getOSType().equals((Object)OS.mac);
    }

    public static enum OS {
        windows,
        linux,
        solaris,
        mac,
        unix,
        other;

    }
}

