/*
 * Decompiled with CFR 0.152.
 */
package net.flexmojos.oss.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PathUtil {
    public static boolean existAll(File ... files) {
        if (files == null) {
            return false;
        }
        if (files.length == 0) {
            return false;
        }
        for (File file : files) {
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    public static boolean existAll(List<String> paths) {
        if (paths == null) {
            return false;
        }
        return PathUtil.existAll(PathUtil.files(paths));
    }

    public static boolean existAny(File ... files) {
        if (files == null) {
            return false;
        }
        if (files.length == 0) {
            return false;
        }
        for (File file : files) {
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public static File[] existingFiles(Collection<String> paths) {
        if (paths == null) {
            return null;
        }
        return PathUtil.existingFilesList(paths).toArray(new File[0]);
    }

    public static File[] existingFiles(File ... files) {
        if (files == null) {
            return null;
        }
        return PathUtil.existingFilesList(Arrays.asList(files)).toArray(new File[0]);
    }

    public static List<File> existingFilesList(Collection<String> paths) {
        if (paths == null) {
            return null;
        }
        return PathUtil.existingFilesList(PathUtil.filesList(paths));
    }

    public static List<File> existingFilesList(List<File> files) {
        if (files == null) {
            return null;
        }
        files = new ArrayList<File>(files);
        Iterator<File> iterator = files.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (file.exists()) continue;
            iterator.remove();
        }
        return files;
    }

    public static File file(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static File file(String path) {
        if (path == null) {
            return null;
        }
        return PathUtil.file(new File(path));
    }

    public static File file(String path, File basedir) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(basedir, path);
        }
        return PathUtil.file(file);
    }

    public static File file(String path, File ... basedirs) {
        if (path == null) {
            return null;
        }
        return PathUtil.file(path, Arrays.asList(basedirs));
    }

    public static File file(String path, List<File> basedirs) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        for (File basedir : basedirs) {
            file = PathUtil.file(path, basedir);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static File file(String path, String basedir) {
        return PathUtil.file(path, PathUtil.file(basedir));
    }

    public static String fileExtention(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getName();
        String[] doted = path.split("\\.");
        if (doted.length == 1) {
            return "";
        }
        if (("gz".equals(doted[doted.length - 1]) || "bz2".equals(doted[doted.length - 1])) && doted.length > 2 && "tar".equals(doted[doted.length - 2].toLowerCase())) {
            return "tar." + doted[doted.length - 1];
        }
        return doted[doted.length - 1];
    }

    public static File[] files(Collection<String> paths) {
        if (paths == null) {
            return null;
        }
        File[] files = new File[paths.size()];
        int i = 0;
        for (String path : paths) {
            files[i++] = PathUtil.file(new File(path));
        }
        return files;
    }

    public static Collection<File> files(List<String> paths, File basedir) {
        if (paths == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String path : paths) {
            files.add(PathUtil.file(path, basedir));
        }
        return files;
    }

    public static File[] files(String ... paths) {
        if (paths == null) {
            return null;
        }
        return PathUtil.files(Arrays.asList(paths));
    }

    public static Collection<File> files(String[] paths, File basedir) {
        if (paths == null) {
            return null;
        }
        return PathUtil.files(Arrays.asList(paths), basedir);
    }

    public static File[] files(String[] paths, List<File> basedirs) {
        if (paths == null) {
            return null;
        }
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = PathUtil.file(paths[i], basedirs);
        }
        return files;
    }

    public static List<File> filesList(Collection<String> paths) {
        if (paths == null) {
            return null;
        }
        return Arrays.asList(PathUtil.files(paths));
    }

    private static String matchPathLists(List<String> r, List<String> f) {
        int j;
        String s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = s + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = s + f.get(j) + File.separator;
            --j;
        }
        s = s + f.get(j);
        return s;
    }

    public static String path(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    private static List<String> pathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        for (File r = PathUtil.file(f); r != null; r = r.getParentFile()) {
            l.add(r.getName());
        }
        return l;
    }

    public static String[] paths(Collection<File> files) {
        if (files == null) {
            return null;
        }
        return PathUtil.paths(files.toArray(new File[files.size()]));
    }

    public static String[] paths(File ... files) {
        if (files == null) {
            return null;
        }
        String[] paths = new String[files.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = PathUtil.path(files[i]);
        }
        return paths;
    }

    public static List<String> pathsList(File[] files) {
        if (files == null) {
            return null;
        }
        return Arrays.asList(PathUtil.paths(files));
    }

    public static List<String> pathsList(List<File> files) {
        if (files == null) {
            return null;
        }
        return Arrays.asList(PathUtil.paths(files));
    }

    public static String pathString(File[] files) {
        if (files == null) {
            return null;
        }
        StringBuilder paths = new StringBuilder();
        for (File file : files) {
            if (paths.length() != 0) {
                paths.append(File.pathSeparatorChar);
            }
            paths.append(PathUtil.path(file));
        }
        return paths.toString();
    }

    public static String relativePath(File home, File f) {
        List<String> homelist = PathUtil.pathList(home);
        List<String> filelist = PathUtil.pathList(f);
        return PathUtil.matchPathLists(homelist, filelist).replace('\\', '/');
    }

    private PathUtil() {
    }

    static {
        new PathUtil();
    }
}

