/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.admin;

import net.greghaines.jesque.Config;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.admin.AdminClient;
import net.greghaines.jesque.json.ObjectMapperFactory;
import net.greghaines.jesque.utils.JesqueUtils;
import redis.clients.jedis.Jedis;

public abstract class AbstractAdminClient
implements AdminClient {
    private final String namespace;

    protected AbstractAdminClient(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.namespace = config.getNamespace();
    }

    protected String getNamespace() {
        return this.namespace;
    }

    @Override
    public void shutdownWorkers(boolean now) {
        this.publish(new Job("ShutdownCommand", now));
    }

    @Override
    public void shutdownWorkers(String channel, boolean now) {
        this.publish(channel, new Job("ShutdownCommand", now));
    }

    @Override
    public void togglePausedWorkers(boolean paused) {
        this.publish(new Job("PauseCommand", paused));
    }

    @Override
    public void togglePausedWorkers(String channel, boolean paused) {
        this.publish(channel, new Job("PauseCommand", paused));
    }

    @Override
    public void publish(Job job) {
        this.publish("admin", job);
    }

    @Override
    public void publish(String channel, Job job) {
        AbstractAdminClient.validateArguments(channel, job);
        try {
            this.doPublish(channel, ObjectMapperFactory.get().writeValueAsString((Object)job));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void doPublish(String var1, String var2) throws Exception;

    public static void doPublish(Jedis jedis, String namespace, String channel, String jobJson) {
        jedis.publish(JesqueUtils.createKey(namespace, "channel", channel), jobJson);
    }

    private static void validateArguments(String channel, Job job) {
        if (channel == null || "".equals(channel)) {
            throw new IllegalArgumentException("channel must not be null or empty: " + channel);
        }
        if (job == null) {
            throw new IllegalArgumentException("job must not be null");
        }
        if (!job.isValid()) {
            throw new IllegalStateException("job is not valid: " + job);
        }
    }
}

