/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.meta.dao.impl;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.greghaines.jesque.Config;
import net.greghaines.jesque.WorkerStatus;
import net.greghaines.jesque.json.ObjectMapperFactory;
import net.greghaines.jesque.meta.WorkerInfo;
import net.greghaines.jesque.meta.dao.WorkerInfoDAO;
import net.greghaines.jesque.utils.CompositeDateFormat;
import net.greghaines.jesque.utils.JesqueUtils;
import net.greghaines.jesque.utils.PoolUtils;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class WorkerInfoDAORedisImpl
implements WorkerInfoDAO {
    private static final Pattern COLON_PATTERN = Pattern.compile(":");
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private final Config config;
    private final Pool<Jedis> jedisPool;

    public WorkerInfoDAORedisImpl(Config config, Pool<Jedis> jedisPool) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (jedisPool == null) {
            throw new IllegalArgumentException("jedisPool must not be null");
        }
        this.config = config;
        this.jedisPool = jedisPool;
    }

    @Override
    public long getWorkerCount() {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Long>(){

            @Override
            public Long doWork(Jedis jedis) throws Exception {
                return jedis.scard(WorkerInfoDAORedisImpl.this.key(new String[]{"workers"}));
            }
        });
    }

    @Override
    public long getActiveWorkerCount() {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Long>(){

            @Override
            public Long doWork(Jedis jedis) throws Exception {
                long activeCount = 0L;
                Set workerNames = jedis.smembers(WorkerInfoDAORedisImpl.this.key(new String[]{"workers"}));
                for (String workerName : workerNames) {
                    if (!WorkerInfoDAORedisImpl.this.isWorkerInState(workerName, WorkerInfo.State.WORKING, jedis)) continue;
                    ++activeCount;
                }
                return activeCount;
            }
        });
    }

    @Override
    public long getPausedWorkerCount() {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Long>(){

            @Override
            public Long doWork(Jedis jedis) throws Exception {
                long pausedCount = 0L;
                Set workerNames = jedis.smembers(WorkerInfoDAORedisImpl.this.key(new String[]{"workers"}));
                for (String workerName : workerNames) {
                    if (!WorkerInfoDAORedisImpl.this.isWorkerInState(workerName, WorkerInfo.State.PAUSED, jedis)) continue;
                    ++pausedCount;
                }
                return pausedCount;
            }
        });
    }

    @Override
    public List<WorkerInfo> getActiveWorkers() {
        return this.getWorkerInfos(WorkerInfo.State.WORKING);
    }

    @Override
    public List<WorkerInfo> getPausedWorkers() {
        return this.getWorkerInfos(WorkerInfo.State.PAUSED);
    }

    @Override
    public List<WorkerInfo> getAllWorkers() {
        return this.getWorkerInfos(null);
    }

    private List<WorkerInfo> getWorkerInfos(final WorkerInfo.State requestedState) {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, List<WorkerInfo>>(){

            @Override
            public List<WorkerInfo> doWork(Jedis jedis) throws Exception {
                Set workerNames = jedis.smembers(WorkerInfoDAORedisImpl.this.key(new String[]{"workers"}));
                ArrayList<WorkerInfo> workerInfos = new ArrayList<WorkerInfo>(workerNames.size());
                for (String workerName : workerNames) {
                    if (!WorkerInfoDAORedisImpl.this.isWorkerInState(workerName, requestedState, jedis)) continue;
                    workerInfos.add(WorkerInfoDAORedisImpl.this.createWorker(workerName, jedis));
                }
                Collections.sort(workerInfos);
                return workerInfos;
            }
        });
    }

    @Override
    public WorkerInfo getWorker(final String workerName) {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, WorkerInfo>(){

            @Override
            public WorkerInfo doWork(Jedis jedis) throws Exception {
                WorkerInfo workerInfo = null;
                if (jedis.sismember(WorkerInfoDAORedisImpl.this.key(new String[]{"workers"}), workerName).booleanValue()) {
                    workerInfo = WorkerInfoDAORedisImpl.this.createWorker(workerName, jedis);
                }
                return workerInfo;
            }
        });
    }

    @Override
    public Map<String, List<WorkerInfo>> getWorkerHostMap() {
        List<WorkerInfo> workerInfos = this.getAllWorkers();
        TreeMap<String, List<WorkerInfo>> hostMap = new TreeMap<String, List<WorkerInfo>>();
        for (WorkerInfo workerInfo : workerInfos) {
            ArrayList<WorkerInfo> hostWIs = (ArrayList<WorkerInfo>)hostMap.get(workerInfo.getHost());
            if (hostWIs == null) {
                hostWIs = new ArrayList<WorkerInfo>();
                hostMap.put(workerInfo.getHost(), hostWIs);
            }
            hostWIs.add(workerInfo);
        }
        return hostMap;
    }

    private String key(String ... parts) {
        return JesqueUtils.createKey(this.config.getNamespace(), parts);
    }

    protected WorkerInfo createWorker(String workerName, Jedis jedis) throws ParseException, IOException {
        String failedStr;
        WorkerInfo workerInfo = new WorkerInfo();
        workerInfo.setName(workerName);
        String[] nameParts = COLON_PATTERN.split(workerName, 3);
        if (nameParts.length < 3) {
            throw new ParseException("Malformed worker name: " + workerName, 0);
        }
        workerInfo.setHost(nameParts[0]);
        workerInfo.setPid(nameParts[1]);
        workerInfo.setQueues(new ArrayList<String>(Arrays.asList(COMMA_PATTERN.split(nameParts[2]))));
        String statusPayload = jedis.get(this.key("worker", workerName));
        if (statusPayload != null) {
            workerInfo.setStatus((WorkerStatus)ObjectMapperFactory.get().readValue(statusPayload, WorkerStatus.class));
            WorkerInfo.State state = workerInfo.getStatus().isPaused() ? WorkerInfo.State.PAUSED : WorkerInfo.State.WORKING;
            workerInfo.setState(state);
        } else {
            workerInfo.setState(WorkerInfo.State.IDLE);
        }
        String startedStr = jedis.get(this.key("worker", workerName, "started"));
        if (startedStr != null) {
            workerInfo.setStarted(new CompositeDateFormat().parse(startedStr));
        }
        if ((failedStr = jedis.get(this.key("stat", "failed", workerName))) != null) {
            workerInfo.setFailed(Long.parseLong(failedStr));
        } else {
            workerInfo.setFailed(0L);
        }
        String processedStr = jedis.get(this.key("stat", "processed", workerName));
        if (processedStr != null) {
            workerInfo.setProcessed(Long.parseLong(processedStr));
        } else {
            workerInfo.setProcessed(0L);
        }
        return workerInfo;
    }

    @Override
    public void removeWorker(final String workerName) {
        PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

            @Override
            public Void doWork(Jedis jedis) throws Exception {
                jedis.srem(WorkerInfoDAORedisImpl.this.key(new String[]{"workers"}), new String[]{workerName});
                jedis.del(new String[]{WorkerInfoDAORedisImpl.this.key(new String[]{"worker", workerName}), WorkerInfoDAORedisImpl.this.key(new String[]{"worker", workerName, "started"}), WorkerInfoDAORedisImpl.this.key(new String[]{"stat", "failed", workerName}), WorkerInfoDAORedisImpl.this.key(new String[]{"stat", "processed", workerName})});
                return null;
            }
        });
    }

    protected boolean isWorkerInState(String workerName, WorkerInfo.State requestedState, Jedis jedis) throws IOException {
        boolean proceed = true;
        if (requestedState != null) {
            String statusPayload = jedis.get(this.key("worker", workerName));
            WorkerStatus status = statusPayload == null ? null : (WorkerStatus)ObjectMapperFactory.get().readValue(statusPayload, WorkerStatus.class);
            switch (requestedState) {
                case IDLE: {
                    proceed = status == null;
                    break;
                }
                case PAUSED: {
                    proceed = status == null ? true : status.isPaused();
                    break;
                }
                case WORKING: {
                    proceed = status == null ? false : !status.isPaused();
                }
            }
        }
        return proceed;
    }
}

